/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.enumtype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsDocumented;
import org.faktorips.runtime.model.annotation.IpsEnumType;
import org.faktorips.runtime.model.annotation.IpsExtensibleEnum;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.enumtype.EnumAttribute;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.util.MessagesHelper;
import org.faktorips.runtime.util.StringBuilderJoiner;

public class EnumType
extends ModelElement {
    public static final String KIND_NAME = "EnumType";
    private final MessagesHelper messagesHelper;
    private final List<String> attributeNames;
    private final LinkedHashMap<String, EnumAttribute> attributeModels;
    private final IpsExtensibleEnum ipsExtensibleEnum;
    private final Class<?> enumTypeClass;

    public EnumType(Class<?> enumTypeClass) {
        super(enumTypeClass.getAnnotation(IpsEnumType.class).name(), enumTypeClass.getAnnotation(IpsExtensionProperties.class), Deprecation.of(AnnotatedDeclaration.from(enumTypeClass)));
        IpsEnumType annotation = enumTypeClass.getAnnotation(IpsEnumType.class);
        this.attributeNames = Arrays.asList(annotation.attributeNames());
        this.attributeModels = EnumAttribute.createFrom(this, enumTypeClass);
        this.ipsExtensibleEnum = enumTypeClass.getAnnotation(IpsExtensibleEnum.class);
        this.messagesHelper = this.createMessageHelper(enumTypeClass.getAnnotation(IpsDocumented.class), enumTypeClass.getClassLoader());
        this.enumTypeClass = enumTypeClass;
    }

    public boolean isExtensible() {
        return this.ipsExtensibleEnum != null;
    }

    public String getEnumContentQualifiedName() {
        return this.isExtensible() ? this.ipsExtensibleEnum.enumContentName() : null;
    }

    public List<EnumAttribute> getAttributes() {
        return new ArrayList<EnumAttribute>(this.attributeModels.values());
    }

    public EnumAttribute getAttribute(String name) {
        return this.attributeModels.get(IpsStringUtils.toLowerFirstChar(name));
    }

    public List<String> getAttributenames() {
        return this.attributeNames;
    }

    public EnumAttribute getIdAttribute() {
        return this.findMarkedAttribute("Identifier", EnumAttribute::isIdentifier);
    }

    public EnumAttribute getDisplayNameAttribute() {
        return this.findMarkedAttribute("DisplayName", EnumAttribute::isDisplayName);
    }

    private EnumAttribute findMarkedAttribute(String marker, AttributeMatcher matcher) {
        for (EnumAttribute attributeModel : this.attributeModels.values()) {
            if (!matcher.matches(attributeModel)) continue;
            return attributeModel;
        }
        throw new IllegalStateException("No attribute of the enum \"" + this.getName() + "\" is marked as " + marker);
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.messagesHelper;
    }

    @Override
    protected String getMessageKey(DocumentationKind messageType) {
        return messageType.getKey(this.getName(), KIND_NAME, "");
    }

    public Class<?> getEnumClass() {
        return this.enumTypeClass;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.isExtensible()) {
            sb.append('[');
            sb.append(this.getEnumContentQualifiedName());
            sb.append(']');
        }
        sb.append('(');
        StringBuilderJoiner.join(sb, this.attributeNames);
        sb.append(')');
        return sb.toString();
    }

    @FunctionalInterface
    private static interface AttributeMatcher {
        public boolean matches(EnumAttribute var1);
    }
}

