/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.faktorips.runtime.caching.Memoizer;
import org.faktorips.runtime.model.annotation.IpsPublishedInterface;

public class AnnotatedDeclaration {
    private static final Memoizer<Class<?>, AnnotatedDeclaration> ANNOTATED_TYPE_CACHE = Memoizer.of(AnnotatedDeclaration.class, AnnotatedDeclaration::new);
    private final List<Class<?>> annotatedClasses = new ArrayList();

    private AnnotatedDeclaration(Class<?> modelClass) {
        this.add(AnnotatedDeclaration.getPublishedInterface(modelClass));
        this.add(AnnotatedDeclaration.getImplementationClass(modelClass));
    }

    private void add(Class<?> annotatedClass) {
        if (annotatedClass != null) {
            this.annotatedClasses.add(annotatedClass);
        }
    }

    public static AnnotatedDeclaration from(Class<?> generatedClass) {
        try {
            return ANNOTATED_TYPE_CACHE.compute(generatedClass);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public boolean is(Class<? extends Annotation> annotationClass) {
        for (Class<?> annotatedClass : this.annotatedClasses) {
            if (!annotatedClass.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    public <T extends Annotation> T get(Class<T> annotationClass) {
        for (Class<?> annotatedClass : this.annotatedClasses) {
            if (!annotatedClass.isAnnotationPresent(annotationClass)) continue;
            return annotatedClass.getAnnotation(annotationClass);
        }
        return null;
    }

    public List<Field> getDeclaredFields() {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> annotatedClass : this.annotatedClasses) {
            result.addAll(Arrays.asList(annotatedClass.getDeclaredFields()));
        }
        return result;
    }

    public List<Method> getDeclaredMethods() {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> annotatedClass : this.annotatedClasses) {
            for (Method declaredMethod : annotatedClass.getDeclaredMethods()) {
                if (declaredMethod.isBridge()) continue;
                result.add(declaredMethod);
            }
        }
        return result;
    }

    public List<AnnotatedElement> getDeclaredElements() {
        ArrayList<AnnotatedElement> result = new ArrayList<AnnotatedElement>();
        result.addAll(this.getDeclaredFields());
        result.addAll(this.getDeclaredMethods());
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.annotatedClasses.get(0).getClassLoader();
    }

    public Class<?> getImplementationClass() {
        return AnnotatedDeclaration.getImplementationClass(this.annotatedClasses.get(0));
    }

    public Class<?> getPublishedInterface() {
        return AnnotatedDeclaration.getPublishedInterface(this.annotatedClasses.get(0));
    }

    public String getDeclarationClassName() {
        return this.getPublishedInterface() != null ? this.getPublishedInterface().getCanonicalName() : this.getImplementationClass().getCanonicalName();
    }

    public int hashCode() {
        return Objects.hash(this.annotatedClasses);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotatedDeclaration other = (AnnotatedDeclaration)obj;
        return Objects.equals(this.annotatedClasses, other.annotatedClasses);
    }

    static Class<?> getPublishedInterface(Class<?> modelObjectClass) {
        Class<?>[] interfaces;
        if (modelObjectClass.isInterface()) {
            return modelObjectClass;
        }
        for (Class<?> iface : interfaces = modelObjectClass.getInterfaces()) {
            if (!iface.isAnnotationPresent(IpsPublishedInterface.class)) continue;
            return iface;
        }
        return null;
    }

    static Class<?> getImplementationClass(Class<?> modelObjectClass) {
        if (modelObjectClass.isInterface()) {
            if (modelObjectClass.isAnnotationPresent(IpsPublishedInterface.class)) {
                return modelObjectClass.getAnnotation(IpsPublishedInterface.class).implementation();
            }
            return null;
        }
        return modelObjectClass;
    }
}

