/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import org.faktorips.runtime.CardinalityRange;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.IProductComponentLinkSource;
import org.faktorips.runtime.internal.IXmlPersistenceSupport;
import org.faktorips.runtime.internal.RuntimeObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProductComponentLink<T extends IProductComponent>
extends RuntimeObject
implements IProductComponentLink<T>,
IXmlPersistenceSupport {
    private final IProductComponentLinkSource source;
    private CardinalityRange cardinality;
    private String targetId;
    private String associationName;

    public ProductComponentLink(IProductComponentGeneration source) {
        this((IProductComponentLinkSource)source);
    }

    public ProductComponentLink(IProductComponentGeneration source, T target) {
        this((IProductComponentLinkSource)source, target, CardinalityRange.FULL_RANGE);
    }

    public ProductComponentLink(IProductComponentGeneration source, T target, CardinalityRange cardinality) {
        this((IProductComponentLinkSource)source, target, cardinality);
    }

    public ProductComponentLink(IProductComponentLinkSource source) {
        this.source = source;
    }

    public ProductComponentLink(IProductComponentLinkSource source, T target) {
        this(source, target, CardinalityRange.FULL_RANGE);
    }

    public ProductComponentLink(IProductComponentLinkSource source, T target, String associationName) {
        this(source, target);
        if (associationName == null) {
            throw new NullPointerException("The associationName for the ProductComponentLink may not be null.");
        }
        this.associationName = associationName;
    }

    public ProductComponentLink(IProductComponentLinkSource source, T target, CardinalityRange cardinality) {
        if (source == null) {
            throw new NullPointerException("The source for the ProductComponentLink may not be null.");
        }
        this.source = source;
        if (target == null) {
            throw new NullPointerException("The targetId for the ProductComponentLink may not be null.");
        }
        this.targetId = target.getId();
        if (cardinality == null) {
            throw new NullPointerException("The cardinality for the ProductComponentLink may not be null.");
        }
        this.cardinality = cardinality;
    }

    public ProductComponentLink(IProductComponentLinkSource source, T target, CardinalityRange cardinality, String associationName) {
        this(source, target, cardinality);
        if (associationName == null) {
            throw new NullPointerException("The associationName for the ProductComponentLink may not be null.");
        }
        this.associationName = associationName;
    }

    @Override
    public CardinalityRange getCardinality() {
        return this.cardinality;
    }

    @Override
    public void initFromXml(Element element) {
        this.associationName = element.getAttribute("association");
        this.targetId = element.getAttribute("targetRuntimeId");
        String maxStr = element.getAttribute("maxCardinality");
        Integer maxCardinality = null;
        maxCardinality = "*".equals(maxStr) || "n".equals(maxStr.toLowerCase()) ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf(maxStr);
        Integer minCardinality = Integer.valueOf(element.getAttribute("minCardinality"));
        Integer defaultCardinality = Integer.valueOf(element.getAttribute("defaultCardinality"));
        this.cardinality = maxCardinality == null || Integer.valueOf(0).equals(maxCardinality) ? CardinalityRange.EXCLUDED : new CardinalityRange(minCardinality, maxCardinality, defaultCardinality);
        this.initExtensionPropertiesFromXml(element);
    }

    @Override
    public Element toXml(Document document) {
        Element linkElement = document.createElement("Link");
        linkElement.setAttribute("association", this.getAssociationName());
        linkElement.setAttribute("targetRuntimeId", this.getTargetId());
        linkElement.setAttribute("minCardinality", Integer.toString((Integer)this.getCardinality().getLowerBound()));
        Integer upperBound = (Integer)this.getCardinality().getUpperBound();
        linkElement.setAttribute("maxCardinality", upperBound == Integer.MAX_VALUE ? "*" : Integer.toString(upperBound));
        linkElement.setAttribute("defaultCardinality", Integer.toString(this.getCardinality().getDefaultCardinality()));
        this.writeExtensionPropertiesToXml(linkElement);
        return linkElement;
    }

    @Override
    public T getTarget() {
        try {
            return (T)this.source.getRepository().getExistingProductComponent(this.targetId);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    @Override
    public String getAssociationName() {
        return this.associationName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.targetId);
        sb.append('(');
        sb.append(this.cardinality.getLowerBound());
        sb.append("..");
        sb.append(Integer.valueOf(Integer.MAX_VALUE).equals(this.cardinality.getUpperBound()) ? "*" : this.cardinality.getUpperBound());
        sb.append(", default:");
        sb.append(this.cardinality.getDefaultCardinality());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public IProductComponentLinkSource getSource() {
        return this.source;
    }
}

