/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.faktorips.runtime.ClassloaderRuntimeRepository;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.IpsStringUtils;

public class TocHierarchyCreator {
    private static final Pattern PACKAGE_WITH_TREE = Pattern.compile("(?:<|>|\\[|\\])");

    private TocHierarchyCreator() {
    }

    public static IRuntimeRepository createRuntimeRepository(List<String> runtimePackages, ClassLoader clazzLoader) {
        if (TocHierarchyCreator.containsTocHierarchyItems(runtimePackages)) {
            Set<TocHierarchy> createTocHierarchy = TocHierarchyCreator.createTocHierarchy(runtimePackages, clazzLoader);
            return TocHierarchyCreator.appendToRootPackage(createTocHierarchy);
        }
        return TocHierarchyCreator.daisyChainRuntimeRepositories(runtimePackages, clazzLoader);
    }

    public static boolean containsTocHierarchyItems(List<String> runtimePackages) {
        for (String string : runtimePackages) {
            if (!PACKAGE_WITH_TREE.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    private static IRuntimeRepository daisyChainRuntimeRepositories(List<String> runtimePackages, ClassLoader clazzLoader) {
        ClassloaderRuntimeRepository additionalRepositories = null;
        IRuntimeRepository currRepository = null;
        for (String pckg : runtimePackages) {
            ClassloaderRuntimeRepository addRep = ClassloaderRuntimeRepository.create(pckg, clazzLoader);
            if (currRepository != null) {
                currRepository.addDirectlyReferencedRepository(addRep);
            } else {
                additionalRepositories = addRep;
            }
            currRepository = addRep;
        }
        return additionalRepositories;
    }

    private static IRuntimeRepository appendToRootPackage(Set<TocHierarchy> hierarchy) {
        if (!hierarchy.isEmpty()) {
            Iterator<TocHierarchy> iter = hierarchy.iterator();
            IRuntimeRepository root = iter.next().getRepository();
            while (iter.hasNext()) {
                root.addDirectlyReferencedRepository(iter.next().getRepository());
            }
            return root;
        }
        return null;
    }

    private static Set<TocHierarchy> createTocHierarchy(List<String> runtimePackages, ClassLoader clazzLoader) {
        HashMap<String, TocHierarchy> cachedTocs = new HashMap<String, TocHierarchy>();
        return TocHierarchyCreator.createTocHierarchy(runtimePackages, cachedTocs, clazzLoader);
    }

    private static Set<TocHierarchy> createTocHierarchy(List<String> tocs, Map<String, TocHierarchy> cachedTocs, ClassLoader clazzLoader) {
        LinkedHashSet<TocHierarchy> pckgs = new LinkedHashSet<TocHierarchy>();
        for (String string : tocs) {
            if (string.contains("[")) {
                String thePckg = string.substring(0, string.indexOf(91));
                TocHierarchy dep = cachedTocs.computeIfAbsent(thePckg, k -> new TocHierarchy((String)k, clazzLoader));
                List<String> internTocs = Arrays.asList(string.substring(string.indexOf(91) + 2, string.lastIndexOf(93) - 1).split(">,<"));
                dep.addAll(TocHierarchyCreator.createTocHierarchy(internTocs, cachedTocs, clazzLoader));
                pckgs.add(dep);
                continue;
            }
            if (!IpsStringUtils.isNotBlank(string)) continue;
            TocHierarchy dep = cachedTocs.computeIfAbsent(string, k -> new TocHierarchy(string, clazzLoader));
            pckgs.add(dep);
        }
        return pckgs;
    }

    private static class TocHierarchy {
        private final String pckg;
        private final IRuntimeRepository classLoaderRepository;
        private final Set<TocHierarchy> dependencies;

        public TocHierarchy(String pckg, ClassLoader clazzLoader) {
            this.pckg = pckg;
            this.classLoaderRepository = ClassloaderRuntimeRepository.create(pckg, clazzLoader);
            this.dependencies = new LinkedHashSet<TocHierarchy>();
        }

        public void addAll(Collection<TocHierarchy> deps) {
            for (TocHierarchy th : deps) {
                this.classLoaderRepository.addDirectlyReferencedRepository(th.classLoaderRepository);
                this.dependencies.add(th);
            }
        }

        public IRuntimeRepository getRepository() {
            return this.classLoaderRepository;
        }

        public String toString() {
            return this.pckg + ":" + this.dependencies.stream().map(TocHierarchy::toString).collect(Collectors.joining(", ", "[", "]"));
        }
    }
}

