/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XmlUtil
extends Enum<XmlUtil> {
    private static final /* synthetic */ XmlUtil[] $VALUES;

    public static XmlUtil[] values() {
        return (XmlUtil[])$VALUES.clone();
    }

    public static XmlUtil valueOf(String name) {
        return Enum.valueOf(XmlUtil.class, name);
    }

    public static final Element getFirstElement(Node parent, String tagName) {
        return XmlUtil.findFirstElement(parent, tagName).orElse(null);
    }

    public static final Optional<Element> findFirstElement(Node parent, String tagName) {
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element element;
            if (!(nl.item(i) instanceof Element) || !(element = (Element)nl.item(i)).getNodeName().equals(tagName)) continue;
            return Optional.of((Element)nl.item(i));
        }
        return Optional.empty();
    }

    public static final Element getFirstElement(Node parent) {
        return XmlUtil.findFirstElement(parent).orElse(null);
    }

    public static final Optional<Element> findFirstElement(Node parent) {
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            return Optional.of((Element)nl.item(i));
        }
        return Optional.empty();
    }

    public static final Element getElement(Node parent, String tagName, int index) {
        NodeList nl = parent.getChildNodes();
        int count = 0;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element element;
            if (!(nl.item(i) instanceof Element) || !(element = (Element)nl.item(i)).getNodeName().equals(tagName)) continue;
            if (count == index) {
                return (Element)nl.item(i);
            }
            ++count;
        }
        throw new IndexOutOfBoundsException();
    }

    public static final List<Element> getElements(Node parent, String tagName) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element element;
            if (!(nl.item(i) instanceof Element) || !(element = (Element)nl.item(i)).getNodeName().equals(tagName)) continue;
            elements.add(element);
        }
        return elements;
    }

    public static final Text getTextNode(Node node) {
        node.normalize();
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 3) continue;
            return (Text)nl.item(i);
        }
        return null;
    }

    public static final CDATASection getFirstCDataSection(Node node) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 4) continue;
            return (CDATASection)nl.item(i);
        }
        return null;
    }

    public static final String getCDATAorTextContent(Node node) {
        if (XmlUtil.getFirstCDataSection(node) != null) {
            return XmlUtil.getFirstCDataSection(node).getData();
        }
        if (XmlUtil.getTextNode(node) != null) {
            return XmlUtil.getTextNode(node).getData();
        }
        return null;
    }

    public static final String getValueFromNode(Element elem, String nodeName) {
        return XmlUtil.findFirstElement(elem, nodeName).map(e -> {
            Node child = e.getFirstChild();
            return child != null ? child.getNodeValue() : null;
        }).orElse(null);
    }

    public static final List<Element> getElementsFromNode(Element elem, String nodeName, String attributeName, String attributeValue) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nl = elem.getChildNodes();
        int max = nl.getLength();
        for (int i = 0; i < max; ++i) {
            Element el;
            String typeAttr;
            if (!(nl.item(i) instanceof Element) || !attributeValue.equals(typeAttr = (el = (Element)nl.item(i)).getAttribute(attributeName)) || !el.getNodeName().equals(nodeName)) continue;
            result.add(el);
        }
        return result;
    }

    private static /* synthetic */ XmlUtil[] $values() {
        return new XmlUtil[0];
    }

    static {
        $VALUES = XmlUtil.$values();
    }
}

