/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.util.Optional;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.model.annotation.IpsConfiguredValidationRule;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsValidationRule;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypePart;

public class ValidationRule
extends TypePart {
    private final IpsValidationRule validationRuleAnnotation;
    private final IpsConfiguredValidationRule validationConfigurationRule;

    public ValidationRule(Type type, IpsValidationRule validationRuleAnnotation, IpsConfiguredValidationRule validationConfigurationRule, IpsExtensionProperties extensionProperties, Optional<Deprecation> deprecation) {
        super(validationRuleAnnotation.name(), type, extensionProperties, deprecation);
        this.validationRuleAnnotation = validationRuleAnnotation;
        this.validationConfigurationRule = validationConfigurationRule;
    }

    public boolean isChangingOverTime() {
        if (this.validationConfigurationRule != null) {
            return this.validationConfigurationRule.changingOverTime();
        }
        return false;
    }

    public boolean isActivatedByDefault() {
        if (this.validationConfigurationRule != null) {
            return this.validationConfigurationRule.defaultActivated();
        }
        return false;
    }

    public boolean isProductRelevant() {
        return this.validationConfigurationRule != null;
    }

    @Override
    public String getName() {
        return this.validationRuleAnnotation.name();
    }

    public String getMsgCode() {
        return this.validationRuleAnnotation.msgCode();
    }

    public Severity getSeverity() {
        return this.validationRuleAnnotation.severity();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("@IpsValidationRule( name = '");
        sb.append(this.getName());
        sb.append("', msgCode = '");
        sb.append(this.getMsgCode());
        sb.append("', severity = '");
        sb.append((Object)this.getSeverity());
        sb.append("')");
        if (this.isProductRelevant()) {
            sb.append("\n");
            sb.append("@IpsConfiguredValidationRule(changeOverTime = ");
            sb.append(this.isChangingOverTime());
            sb.append(", defaultActivated = ");
            sb.append(this.isActivatedByDefault());
            sb.append(")");
        }
        return sb.toString();
    }
}

