/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.jaxb;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.faktorips.runtime.internal.IpsStringUtils;

public class LocalTimeAdapter
extends XmlAdapter<String, LocalTime> {
    public LocalTime unmarshal(String v) {
        if (IpsStringUtils.isBlank(v)) {
            return null;
        }
        try {
            return LocalTime.parse(v);
        }
        catch (DateTimeParseException e) {
            LocalTime localTimeWithMilliseconds = DateTimeFormatter.ofPattern("HH:mm:ss:SSS").parse((CharSequence)v, LocalTime::from);
            return localTimeWithMilliseconds.withNano(0);
        }
    }

    public String marshal(LocalTime v) {
        if (v == null) {
            return null;
        }
        return v.toString();
    }
}

