/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.test;

import java.text.MessageFormat;
import java.util.List;
import org.faktorips.runtime.test.IpsTestCaseBase;
import org.faktorips.runtime.test.IpsTestFailure;
import org.faktorips.runtime.test.IpsTestListener;
import org.faktorips.runtime.test.IpsTestResult;
import org.faktorips.values.ObjectUtil;

public class IpsTestCaseJUnitAdapterUtil {
    private static final String FAILUREFORMAT_FAILUREIN = "Failure in: \"{0}\"";
    private static final String FAILUREFORMAT_OBJECT = ", Object: \"{0}\"";
    private static final String FAILUREFORMAT_ATTRIBUTE = ", Attribute: \"{0}\".";
    private static final String FAILUREFORMAT_EXPECTED = ", expected: \"{0}\"";
    private static final String FAILUREFORMAT_ACTUAL = " but was: \"{0}\"";

    private IpsTestCaseJUnitAdapterUtil() {
    }

    public static void runTestCase(IpsTestCaseBase ipsTestCase, IpsTestListener listener) {
        if (ipsTestCase == null) {
            return;
        }
        IpsTestResult ipsTestResult = new IpsTestResult();
        ipsTestResult.addListener(listener);
        ipsTestCase.run(ipsTestResult);
    }

    public static String createFailureEntries(List<IpsTestFailure> failures) {
        StringBuilder sb = new StringBuilder(failures.size() * 40);
        for (IpsTestFailure failure : failures) {
            if (failure.isError()) {
                throw new RuntimeException(failure.getThrowable());
            }
            if (sb.length() > 0) {
                sb.append(System.lineSeparator());
            }
            sb.append(IpsTestCaseJUnitAdapterUtil.failureToString(failure));
        }
        return sb.toString();
    }

    private static String failureToString(IpsTestFailure failure) {
        StringBuilder failureMessage = new StringBuilder();
        failureMessage.append(MessageFormat.format(FAILUREFORMAT_FAILUREIN, failure.getTestCase() != null ? failure.getTestCase().getQualifiedName() : null));
        IpsTestCaseJUnitAdapterUtil.appendFormatted(failureMessage, FAILUREFORMAT_EXPECTED, failure.getExpectedValue());
        IpsTestCaseJUnitAdapterUtil.appendFormatted(failureMessage, FAILUREFORMAT_ACTUAL, failure.getActualValue());
        IpsTestCaseJUnitAdapterUtil.appendFormatted(failureMessage, FAILUREFORMAT_OBJECT, failure.getTestObject());
        IpsTestCaseJUnitAdapterUtil.appendFormatted(failureMessage, FAILUREFORMAT_ATTRIBUTE, failure.getTestedAttribute());
        return failureMessage.toString();
    }

    private static void appendFormatted(StringBuilder sb, String pattern, Object value) {
        if (value == null) {
            sb.append(MessageFormat.format(pattern, "<null>"));
        } else if (ObjectUtil.isNullObject((Object)value)) {
            sb.append(MessageFormat.format(pattern, value.toString()));
        } else {
            sb.append(MessageFormat.format(pattern, value));
        }
    }
}

