/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.faktorips.annotation.UtilityClass;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.Severity;

@UtilityClass
public class MessageLists {
    private MessageLists() {
    }

    public static final MessageList emptyMessageList() {
        return new MessageList();
    }

    public static final MessageList orEmptyMessageList(MessageList ml) {
        if (ml == null) {
            return MessageLists.emptyMessageList();
        }
        return ml;
    }

    public static final MessageList sortBySeverity(MessageList unsortedMessageList) {
        if (unsortedMessageList == null) {
            return MessageLists.emptyMessageList();
        }
        return StreamSupport.stream(unsortedMessageList.spliterator(), false).collect(Collectors.groupingBy(Message::getSeverity)).entrySet().stream().sorted((e1, e2) -> ((Severity)((Object)((Object)e2.getKey()))).compareTo((Severity)((Object)((Object)e1.getKey())))).flatMap(e -> ((List)e.getValue()).stream()).collect(MessageLists.collectMessages());
    }

    public static final MessageList filtered(MessageList ml, Predicate<Message> predicate) {
        if (ml == null) {
            return MessageLists.emptyMessageList();
        }
        return StreamSupport.stream(ml.spliterator(), false).filter(predicate).collect(MessageLists.collectMessages());
    }

    public static final Collector<MessageList, ?, MessageList> flatten() {
        return new MessageListCollector();
    }

    public static final Collector<Message, ?, MessageList> collectMessages() {
        return new MessageCollector();
    }

    public static final MessageList join(MessageList ... messageLists) {
        if (messageLists == null) {
            return new MessageList();
        }
        return Stream.of(messageLists).collect(MessageLists.flatten());
    }

    private static class MessageCollector
    implements Collector<Message, MessageList, MessageList> {
        private MessageCollector() {
        }

        @Override
        public Supplier<MessageList> supplier() {
            return MessageList::new;
        }

        @Override
        public BiConsumer<MessageList, Message> accumulator() {
            return MessageList::add;
        }

        @Override
        public BinaryOperator<MessageList> combiner() {
            return (ml1, ml2) -> {
                MessageList ml = new MessageList();
                ml.add((MessageList)ml1);
                ml.add((MessageList)ml2);
                return ml;
            };
        }

        @Override
        public Function<MessageList, MessageList> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.singleton(Collector.Characteristics.IDENTITY_FINISH);
        }
    }

    private static class MessageListCollector
    implements Collector<MessageList, MessageList, MessageList> {
        private MessageListCollector() {
        }

        @Override
        public Supplier<MessageList> supplier() {
            return MessageList::new;
        }

        @Override
        public BiConsumer<MessageList, MessageList> accumulator() {
            return MessageList::add;
        }

        @Override
        public BinaryOperator<MessageList> combiner() {
            return (ml1, ml2) -> {
                MessageList ml = new MessageList();
                ml.add((MessageList)ml1);
                ml.add((MessageList)ml2);
                return ml;
            };
        }

        @Override
        public Function<MessageList, MessageList> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.singleton(Collector.Characteristics.IDENTITY_FINISH);
        }
    }
}

