/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IModelObjectVisitor;
import org.faktorips.runtime.IVisitorSupport;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.AssociationKind;
import org.faktorips.runtime.model.type.PolicyAssociation;

public class GenericVisitorSupport
implements IVisitorSupport {
    private final IModelObject modelObject;

    public GenericVisitorSupport(IModelObject modelObject) {
        this.modelObject = modelObject;
    }

    @Override
    public boolean accept(IModelObjectVisitor visitor) {
        if (!visitor.visit(this.modelObject)) {
            return false;
        }
        IpsModel.getPolicyCmptType(this.modelObject).getAssociations().stream().filter(GenericVisitorSupport::shouldFollow).flatMap(a -> a.getTargetObjects(this.modelObject).stream()).map(IVisitorSupport::orGenericVisitorSupport).forEach(c -> c.accept(visitor));
        return true;
    }

    private static boolean shouldFollow(PolicyAssociation association) {
        return !association.isDerivedUnion() && AssociationKind.Composition == association.getAssociationKind();
    }
}

