/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.faktorips.runtime.GenerationId;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.caching.IComputable;
import org.faktorips.runtime.internal.AbstractRuntimeRepository;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.IpsEnum;
import org.faktorips.runtime.xml.IIpsXmlAdapter;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.InternationalString;

public abstract class AbstractCachingRuntimeRepository
extends AbstractRuntimeRepository {
    private ICacheFactory cacheFactory;
    private volatile IComputable<String, IProductComponent> productCmptCache;
    private volatile IComputable<GenerationId, IProductComponentGeneration> productCmptGenerationCache;
    private volatile IComputable<String, ITable<?>> tableCacheByQName;
    private volatile IComputable<Class<?>, IpsEnum<?>> enumValuesCacheByClass;
    private List<IIpsXmlAdapter<?, ?>> enumXmlAdapters;
    private volatile Map<Class<?>, IComputable<String, Object>> customRuntimeObjectsByTypeCache = new HashMap();

    public AbstractCachingRuntimeRepository(String name, ICacheFactory cacheFactory, ClassLoader cl) {
        super(name);
        this.cacheFactory = cacheFactory;
        this.initCaches(cl);
    }

    protected void initCaches(ClassLoader cl) {
        try {
            Class<?> productCmptClass = cl.loadClass(IProductComponent.class.getName());
            IComputable<String, IProductComponent> productCmptComputer = IComputable.of(productCmptClass, this::getNotCachedProductComponent);
            this.productCmptCache = this.cacheFactory.createProductCmptCache(productCmptComputer);
            Class<?> productCmptGenClass = cl.loadClass(IProductComponentGeneration.class.getName());
            this.productCmptGenerationCache = this.cacheFactory.createProductCmptGenerationCache(IComputable.of(productCmptGenClass, this::getNotCachedProductComponentGeneration));
            Class<?> tableClass = cl.loadClass(ITable.class.getName());
            this.tableCacheByQName = this.cacheFactory.createTableCache(IComputable.of(tableClass, this::getNotCachedTable));
            this.enumValuesCacheByClass = this.cacheFactory.createIpsEnumCache(IComputable.of(IpsEnum.class, this::getNotCachedEnumValues));
            this.enumXmlAdapters = new ArrayList();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected IProductComponent getProductComponentInternal(String id) {
        try {
            return this.productCmptCache.compute(id);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract IProductComponent getNotCachedProductComponent(String var1);

    protected IProductComponentGeneration getProductComponentGenerationInternal(String id, DateTime validFrom) {
        GenerationId generationId = new GenerationId(id, validFrom);
        try {
            return this.productCmptGenerationCache.compute(generationId);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract IProductComponentGeneration getNotCachedProductComponentGeneration(GenerationId var1);

    @Override
    protected <T> List<T> getEnumValuesInternal(Class<T> clazz) {
        try {
            IpsEnum<?> ipsEnum = this.enumValuesCacheByClass.compute(clazz);
            return AbstractCachingRuntimeRepository.cast(ipsEnum != null ? ipsEnum.getEnums() : null);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> List<T> cast(List<?> enumValues) {
        return enumValues;
    }

    protected abstract <T> IpsEnum<T> getNotCachedEnumValues(Class<T> var1);

    @Override
    protected ITable<?> getTableInternal(String qualifiedTableName) {
        try {
            return this.tableCacheByQName.compute(qualifiedTableName);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract ITable<?> getNotCachedTable(String var1);

    @Override
    protected List<IIpsXmlAdapter<?, ?>> getAllInternalEnumXmlAdapters(IRuntimeRepository repository) {
        if (!this.enumXmlAdapters.isEmpty()) {
            return this.enumXmlAdapters;
        }
        this.enumXmlAdapters = this.getNotCachedEnumXmlAdapter(repository);
        return this.enumXmlAdapters;
    }

    protected abstract List<IIpsXmlAdapter<?, ?>> getNotCachedEnumXmlAdapter(IRuntimeRepository var1);

    @Override
    protected <T> T getCustomRuntimeObjectInternal(Class<T> type, String ipsObjectQualifiedName) {
        try {
            IComputable<String, T> cache = this.getCache(type);
            return cache.compute(ipsObjectQualifiedName);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> IComputable<String, T> getCache(Class<T> type) {
        IComputable<String, Object> cache = this.customRuntimeObjectsByTypeCache.get(type);
        if (cache == null) {
            IComputable<String, Object> cache2 = cache = this.initCache(type);
            this.customRuntimeObjectsByTypeCache.put(type, cache2);
        }
        return cache;
    }

    private <T> IComputable<String, T> initCache(Class<T> type) {
        return this.cacheFactory.createCache(IComputable.of(type, key -> this.getNotCachedCustomObject(type, (String)key)));
    }

    protected abstract <T> T getNotCachedCustomObject(Class<T> var1, String var2);

    public <T> InternationalString getEnumDescription(Class<T> type) {
        try {
            IpsEnum<?> ipsEnum = this.enumValuesCacheByClass.compute(type);
            if (ipsEnum != null) {
                return ipsEnum.getDescription();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return new DefaultInternationalString(new ArrayList(), Locale.getDefault());
    }
}

