/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.tableindex;

import java.util.HashSet;
import java.util.Set;
import org.faktorips.runtime.internal.tableindex.MergeAndCopyStructure;
import org.faktorips.runtime.internal.tableindex.SearchStructure;

public class UniqueResultStructure<R>
extends SearchStructure<R>
implements MergeAndCopyStructure<UniqueResultStructure<R>> {
    private final R uniqueResult;

    UniqueResultStructure(R result) {
        if (result == null) {
            throw new NullPointerException("Result value must not be null");
        }
        this.uniqueResult = result;
    }

    public static <R> UniqueResultStructure<R> createWith(R resultValue) {
        return new UniqueResultStructure<R>(resultValue);
    }

    @Override
    public SearchStructure<R> get(Object key) {
        return this;
    }

    @Override
    public Set<R> get() {
        HashSet<R> result = new HashSet<R>();
        result.add(this.uniqueResult);
        return result;
    }

    @Override
    public void merge(UniqueResultStructure<R> otherStructure) {
        throw new UnsupportedOperationException("Unique key violation: " + this + " cannot be merged with " + otherStructure.uniqueResult + "");
    }

    @Override
    public R getUnique(R defaultValue) {
        return this.uniqueResult;
    }

    @Override
    public R getUnique() {
        return this.uniqueResult;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + this.uniqueResult.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UniqueResultStructure other = (UniqueResultStructure)obj;
        return other.uniqueResult.equals(this.uniqueResult);
    }

    public String toString() {
        return "UniqueResultStructure [" + this.uniqueResult + "]";
    }

    @Override
    public UniqueResultStructure<R> copy() {
        return this;
    }
}

