/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.WildcardType;
import java.util.Calendar;
import java.util.List;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.type.Attribute;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;

public class ProductAttribute
extends Attribute {
    private final Method getter;
    private final Method setter;

    public ProductAttribute(Type type, boolean changingOverTime, Method getter, Method setter) {
        super(type, getter.getAnnotation(IpsAttribute.class), getter.getAnnotation(IpsExtensionProperties.class), ProductAttribute.getInnermostGenericClass(getter.getGenericReturnType()), changingOverTime, Deprecation.of(getter));
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public ProductCmptType getType() {
        return (ProductCmptType)super.getType();
    }

    @Override
    @Deprecated
    public ProductCmptType getModelType() {
        return this.getType();
    }

    @Override
    public boolean isProductRelevant() {
        return true;
    }

    @Override
    public Attribute createOverwritingAttributeFor(Type subType) {
        return new ProductAttribute(subType, this.isChangingOverTime(), this.getter, this.setter);
    }

    public Object getValue(IProductComponent productComponent, Calendar effectiveDate) {
        return ProductAttribute.invokeMethod(this.getter, this.getRelevantProductObject(productComponent, effectiveDate), new Object[0]);
    }

    public Boolean isMultiValue() {
        return this.getter.getReturnType().equals(List.class);
    }

    private static final Class<?> getInnermostGenericClass(java.lang.reflect.Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ProductAttribute.getInnermostGenericClass(((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        if (type instanceof WildcardType) {
            return ProductAttribute.getInnermostGenericClass(((WildcardType)type).getUpperBounds()[0]);
        }
        throw new IllegalArgumentException("can't find class for " + type.toString());
    }
}

