/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.validation.DefaultGenericAttributeValidationConfiguration;
import org.faktorips.runtime.validation.IGenericAttributeValidationConfiguration;

public class ValidationContext
implements IValidationContext {
    private final Locale locale;
    private final Map<String, Object> propertyValues = new HashMap<String, Object>();
    private final ClassLoader resourceClassLoader;
    private final IGenericAttributeValidationConfiguration genericAttributeValidationConfiguration;

    public ValidationContext(Locale locale, ClassLoader resourceClassLoader, IGenericAttributeValidationConfiguration genericAttributeValidationConfiguration) {
        this.locale = Objects.requireNonNull(locale, "The parameter locale cannot be null.");
        this.resourceClassLoader = Objects.requireNonNull(resourceClassLoader, "The parameter resourceClassLoader cannot be null.");
        this.genericAttributeValidationConfiguration = Objects.requireNonNull(genericAttributeValidationConfiguration, "The parameter genericAttributeValidationConfiguration cannot be null.");
    }

    public ValidationContext(Locale locale, ClassLoader resourceClassLoader) {
        this(locale, resourceClassLoader, new DefaultGenericAttributeValidationConfiguration(locale));
    }

    public ValidationContext(Locale locale) {
        this(locale, ValidationContext.class.getClassLoader());
    }

    public ValidationContext() {
        this(Locale.getDefault());
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public Object getValue(String propertyName) {
        return this.propertyValues.get(propertyName);
    }

    public void setValue(String propertyName, Object value) {
        this.propertyValues.put(propertyName, value);
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    @Override
    public IGenericAttributeValidationConfiguration getGenericAttributeValidationConfiguration() {
        return this.genericAttributeValidationConfiguration;
    }
}

