/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.TableSaxHandler;
import org.faktorips.runtime.xml.IToXmlSupport;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.InternationalString;
import org.faktorips.values.LocalizedString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Table<R>
implements ITable<R> {
    private static final String XML_ELEMENT_TABLE_CONTENTS = "TableContents";
    private static final String ATTRIBUTE_LOCALE = "locale";
    private static final String XML_ELEMENT_DESCRIPTION = "Description";
    protected List<R> rows;
    protected InternationalString description;
    private String name;

    public Table() {
    }

    public Table(String qualifiedTableName) {
        this.name = qualifiedTableName;
    }

    protected abstract void addRow(List<String> var1, IRuntimeRepository var2);

    protected abstract void initKeyMaps();

    public void initFromXml(InputStream is, IRuntimeRepository productRepository, String qualifiedTableName) throws Exception {
        this.rows = new ArrayList<R>(200);
        this.name = qualifiedTableName;
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        saxParser.parse(new InputSource(is), (DefaultHandler)new TableSaxHandler(this, productRepository));
        ((ArrayList)this.rows).trimToSize();
        this.init();
    }

    protected void init() {
        this.initKeyMaps();
        this.performAdditionalInitializations();
    }

    protected void performAdditionalInitializations() {
    }

    protected boolean isNull(Element valueElement) {
        return Boolean.parseBoolean(valueElement.getAttribute("isNull"));
    }

    public String toString() {
        return this.rows.stream().limit(10L).map(Object::toString).collect(Collectors.joining("\n"));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription(Locale locale) {
        String string = this.description.get(locale);
        if (string == null) {
            return "";
        }
        return string;
    }

    @Override
    public List<R> getAllRows() {
        return Collections.unmodifiableList(this.rows);
    }

    private void writeDescriptionToXml(Element tableElement) {
        if (this.description != null) {
            for (LocalizedString localizedString : ((DefaultInternationalString)this.description).getLocalizedStrings()) {
                Element descriptionElement = tableElement.getOwnerDocument().createElement(XML_ELEMENT_DESCRIPTION);
                descriptionElement.setAttribute(ATTRIBUTE_LOCALE, localizedString.getLocale().toString());
                descriptionElement.setTextContent(localizedString.getValue());
                tableElement.appendChild(descriptionElement);
            }
        }
    }

    @Override
    public Element toXml(Document document) {
        IToXmlSupport.check(this);
        Element tableElement = document.createElement(XML_ELEMENT_TABLE_CONTENTS);
        this.writeDescriptionToXml(tableElement);
        ((IToXmlSupport)((Object)this)).writePropertiesToXml(tableElement);
        return tableElement;
    }
}

