/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productswitch;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.model.type.PolicyAssociation;

public class ProductSwitchResults {
    private final Map<IConfigurableModelObject, ProductSwitchResult> result;

    public ProductSwitchResults(Map<IConfigurableModelObject, ProductSwitchResult> result) {
        this.result = result;
    }

    public Map<IConfigurableModelObject, ProductSwitchResult> asMap() {
        return Collections.unmodifiableMap(this.result);
    }

    public ProductSwitchResult getResultFor(IConfigurableModelObject modelObject) {
        return this.result.get(modelObject);
    }

    public Map<IConfigurableModelObject, SuccessfulProductSwitch> successfulAsMap() {
        return Collections.unmodifiableMap(this.result.entrySet().stream().filter(e -> e.getValue() instanceof SuccessfulProductSwitch).collect(Collectors.toMap(Map.Entry::getKey, e -> (SuccessfulProductSwitch)e.getValue())));
    }

    public Map<IConfigurableModelObject, FailedProductSwitch> failureAsMap() {
        return Collections.unmodifiableMap(this.result.entrySet().stream().filter(e -> e.getValue() instanceof FailedProductSwitch).collect(Collectors.toMap(Map.Entry::getKey, e -> (FailedProductSwitch)e.getValue())));
    }

    public boolean containsFailures() {
        return this.result.values().stream().anyMatch(FailedProductSwitch.class::isInstance);
    }

    public int size() {
        return this.result.size();
    }

    public static interface ProductSwitchResult {
        public boolean isSuccessful();
    }

    public static class FailedProductSwitch
    implements ProductSwitchResult {
        private final IConfigurableModelObject parent;
        private final PolicyAssociation association;
        private final String message;

        public FailedProductSwitch(IConfigurableModelObject parent, PolicyAssociation association, String message) {
            this.parent = parent;
            this.association = association;
            this.message = message;
        }

        public IConfigurableModelObject getParent() {
            return this.parent;
        }

        public PolicyAssociation getAssociation() {
            return this.association;
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }
    }

    public static class SuccessfulProductSwitch
    implements ProductSwitchResult {
        private final IProductComponent oldProduct;
        private final IProductComponent newProduct;

        public SuccessfulProductSwitch(IProductComponent oldProduct, IProductComponent newProduct) {
            this.oldProduct = oldProduct;
            this.newProduct = newProduct;
        }

        public IProductComponent getOldProduct() {
            return this.oldProduct;
        }

        public IProductComponent getNewProduct() {
            return this.newProduct;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }
    }
}

