/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.tableindex;

import java.util.TreeMap;
import org.faktorips.runtime.internal.tableindex.AbstractMapStructure;
import org.faktorips.runtime.internal.tableindex.MergeAndCopyStructure;
import org.faktorips.runtime.internal.tableindex.RangeType;
import org.faktorips.runtime.internal.tableindex.SearchStructure;

public class RangeStructure<K extends Comparable<? super K>, V extends SearchStructure<R>, R>
extends AbstractMapStructure<K, V, R>
implements MergeAndCopyStructure<RangeStructure<K, V, R>> {
    private final RangeType rangeType;

    RangeStructure(RangeType rangeType) {
        super(new TreeMap());
        if (rangeType == null) {
            throw new NullPointerException("RangeType must not be null");
        }
        this.rangeType = rangeType;
    }

    public static <K extends Comparable<? super K>, V extends SearchStructure<R>, R> RangeStructure<K, V, R> create(RangeType keyType) {
        return new RangeStructure<K, V, R>(keyType);
    }

    public static <K extends Comparable<? super K>, V extends SearchStructure<R>, R> RangeStructure<K, V, R> createWith(RangeType keyType, K key, V value) {
        RangeStructure<K, V, R> structure = new RangeStructure<K, V, R>(keyType);
        structure.put(key, value);
        return structure;
    }

    @Override
    public SearchStructure<R> get(Object key) {
        if (key == null) {
            return this.emptyResult();
        }
        Comparable kKey = (Comparable)key;
        SearchStructure result = (SearchStructure)this.rangeType.getValue(this.getMap(), kKey);
        return this.getValidResult(result);
    }

    @Override
    protected TreeMap<K, V> getMap() {
        return (TreeMap)super.getMap();
    }

    @Override
    public void merge(RangeStructure<K, V, R> map) {
        super.merge(map);
    }

    @Override
    public RangeStructure<K, V, R> copy() {
        return this.fillCopy(new RangeStructure<K, V, R>(this.rangeType));
    }
}

