/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.faktorips.runtime.IModifiableRuntimeRepository;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IRuntimeObject;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.internal.AbstractRuntimeRepository;
import org.faktorips.runtime.test.IpsTest2;
import org.faktorips.runtime.test.IpsTestCaseBase;
import org.faktorips.runtime.xml.IIpsXmlAdapter;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.InternationalString;

public class InMemoryRuntimeRepository
extends AbstractRuntimeRepository
implements IModifiableRuntimeRepository {
    private HashMap<String, IProductComponent> productCmpts = new HashMap();
    private HashMap<String, SortedSet<IProductComponentGeneration>> productCmptGenLists = new HashMap();
    private List<ITable<?>> tables = new ArrayList();
    private Map<String, ITable<?>> multipleContentTables = new HashMap();
    private HashMap<String, IpsTestCaseBase> testCasesByQName = new HashMap();
    private Map<Class<?>, List<?>> enumValuesMap = new HashMap();
    private Map<Class<?>, InternationalString> enumDescriptionMap = new HashMap();
    private List<IIpsXmlAdapter<?, ?>> enumXmlAdapters = new LinkedList();
    private Map<Class<?>, Map<String, IRuntimeObject>> customRuntimeObjectsByType = new HashMap();

    public InMemoryRuntimeRepository() {
        super("InMemoryRuntimeRepository");
    }

    public InMemoryRuntimeRepository(String name) {
        super(name);
    }

    @Override
    protected IProductComponent getProductComponentInternal(String id) {
        return this.productCmpts.get(id);
    }

    @Override
    protected IProductComponent getProductComponentInternal(String kindId, String versionId) {
        if (kindId == null) {
            return null;
        }
        if (versionId == null) {
            throw new RuntimeException("Not implemented yet.");
        }
        for (IProductComponent cmpt : this.productCmpts.values()) {
            if (!kindId.equals(cmpt.getKindId()) || !versionId.equals(cmpt.getVersionId())) continue;
            return cmpt;
        }
        return null;
    }

    @Override
    public void getAllProductComponents(String kindId, List<IProductComponent> result) {
        for (IProductComponent cmpt : this.productCmpts.values()) {
            if (!kindId.equals(cmpt.getKindId())) continue;
            result.add(cmpt);
        }
    }

    private SortedSet<IProductComponentGeneration> getLoadedProductCmptGenerations(String productCmptId) {
        return this.productCmptGenLists.get(productCmptId);
    }

    @Override
    public void getProductComponentGenerations(IProductComponent productCmpt, List<IProductComponentGeneration> result) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(productCmpt.getId());
        if (genSet != null) {
            result.addAll(genSet);
        }
    }

    public void initialize() {
    }

    @Override
    protected void getAllTables(List<ITable<?>> result) {
        result.addAll(this.tables);
    }

    @Override
    protected <T extends ITable<?>> T getTableInternal(Class<T> tableClass) {
        for (ITable<?> table : this.tables) {
            if (!tableClass.isAssignableFrom(table.getClass())) continue;
            return (T)((ITable)tableClass.cast(table));
        }
        return null;
    }

    @Override
    public void putTable(ITable<?> table) {
        Class<?> tableClass = table.getClass();
        Iterator<ITable<?>> it = this.tables.iterator();
        while (it.hasNext()) {
            ITable<?> each = it.next();
            if (!each.getClass().isAssignableFrom(tableClass)) continue;
            it.remove();
        }
        this.tables.add(table);
    }

    public void putTable(ITable<?> table, String qName) {
        this.multipleContentTables.put(qName, table);
        this.putTable(table);
    }

    @Override
    public <T> void putEnumValues(Class<T> enumTypeClass, List<T> enumValues, InternationalString description) {
        this.enumValuesMap.put(enumTypeClass, new ArrayList<T>(enumValues));
        this.enumDescriptionMap.put(enumTypeClass, description);
    }

    @Override
    public <T> InternationalString getEnumDescription(Class<T> enumClazz) {
        return this.enumDescriptionMap.getOrDefault(enumClazz, DefaultInternationalString.EMPTY);
    }

    @Override
    protected ITable<?> getTableInternal(String qualifiedTableName) {
        return this.multipleContentTables.get(qualifiedTableName);
    }

    @Override
    public void getAllProductComponents(List<IProductComponent> result) {
        result.addAll(this.productCmpts.values());
    }

    @Override
    public void getAllProductComponentIds(List<String> result) {
        result.addAll(this.productCmpts.keySet());
    }

    @Override
    protected void getAllEnumClasses(LinkedHashSet<Class<?>> result) {
        result.addAll(this.enumValuesMap.keySet());
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public void putProductComponent(IProductComponent productCmpt) {
        Objects.requireNonNull(productCmpt);
        this.productCmpts.put(productCmpt.getId(), productCmpt);
    }

    @Override
    public void putProductComponent(IProductComponent productCmpt, String qName) {
        this.putProductComponent(productCmpt);
    }

    @Override
    protected IProductComponentGeneration getProductComponentGenerationInternal(String productCmptId, Calendar effectiveDate) {
        if (productCmptId == null || effectiveDate == null) {
            return null;
        }
        SortedSet<IProductComponentGeneration> genSortedSet = this.getGenerationSortedSet(productCmptId);
        IProductComponentGeneration foundGen = null;
        long effectiveTime = effectiveDate.getTimeInMillis();
        long foundGenValidFrom = Long.MIN_VALUE;
        for (IProductComponentGeneration gen : genSortedSet) {
            long genValidFrom = gen.getValidFrom(effectiveDate.getTimeZone()).getTime();
            if (effectiveTime < genValidFrom || genValidFrom <= foundGenValidFrom) continue;
            foundGen = gen;
            foundGenValidFrom = genValidFrom;
        }
        return foundGen;
    }

    public void putProductCmptGeneration(IProductComponentGeneration generation) {
        Objects.requireNonNull(generation);
        this.getGenerationSortedSet(generation.getProductComponent().getId()).add(generation);
        this.putProductComponent(generation.getProductComponent());
    }

    @Override
    public void putProductCmptGeneration(IProductComponentGeneration generation, String qName) {
        this.putProductCmptGeneration(generation);
    }

    private SortedSet<IProductComponentGeneration> getGenerationSortedSet(String productCmptId) {
        return this.productCmptGenLists.computeIfAbsent(productCmptId, $ -> new TreeSet<IProductComponentGeneration>(new ProductCmptGenerationComparator(TimeZone.getDefault())));
    }

    @Override
    protected void getAllIpsTestCases(List<IpsTest2> result, IRuntimeRepository runtimeRepository) {
        result.addAll(this.testCasesByQName.values());
    }

    @Override
    protected void getIpsTestCasesStartingWith(String qNamePrefix, List<IpsTest2> result, IRuntimeRepository runtimeRepository) {
        for (String qName : this.testCasesByQName.keySet()) {
            if (!qName.startsWith(qNamePrefix)) continue;
            result.add(this.testCasesByQName.get(qName));
        }
    }

    @Override
    protected IpsTestCaseBase getIpsTestCaseInternal(String qName, IRuntimeRepository runtimeRepository) {
        return this.testCasesByQName.get(qName);
    }

    @Override
    public void putIpsTestCase(IpsTestCaseBase test) {
        this.testCasesByQName.put(test.getQualifiedName(), test);
    }

    @Override
    protected void getAllModelTypeImplementationClasses(Set<String> result) {
        throw new RuntimeException("Currently not supported by InMemoryRuntimeRepository.");
    }

    @Override
    protected IProductComponentGeneration getNextProductComponentGenerationInternal(IProductComponentGeneration generation) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(generation.getProductComponent().getId());
        SortedSet<IProductComponentGeneration> successor = genSet.tailSet(generation);
        if (successor == null) {
            return null;
        }
        for (IProductComponentGeneration next : successor) {
            if (next.equals(generation)) continue;
            return next;
        }
        return null;
    }

    @Override
    protected int getNumberOfProductComponentGenerationsInternal(IProductComponent productCmpt) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(productCmpt.getId());
        return genSet.size();
    }

    @Override
    protected IProductComponentGeneration getPreviousProductComponentGenerationInternal(IProductComponentGeneration generation) {
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(generation.getProductComponent().getId());
        SortedSet<IProductComponentGeneration> predecessors = genSet.headSet(generation);
        if (predecessors.isEmpty()) {
            return null;
        }
        return predecessors.last();
    }

    @Override
    protected IProductComponentGeneration getLatestProductComponentGenerationInternal(IProductComponent productCmpt) {
        Objects.requireNonNull(productCmpt);
        SortedSet<IProductComponentGeneration> genSet = this.getLoadedProductCmptGenerations(productCmpt.getId());
        return genSet.last();
    }

    @Override
    protected <T> List<T> getEnumValuesInternal(Class<T> clazz) {
        List<?> values = this.enumValuesMap.get(clazz);
        if (values == null) {
            return null;
        }
        return Collections.unmodifiableList(values);
    }

    public void addEnumXmlAdapter(IIpsXmlAdapter<?, ?> enumXmlAdapter) {
        this.enumXmlAdapters.add(enumXmlAdapter);
    }

    @Override
    protected List<IIpsXmlAdapter<?, ?>> getAllInternalEnumXmlAdapters(IRuntimeRepository repository) {
        return this.enumXmlAdapters;
    }

    @Override
    public <T extends IRuntimeObject> void putCustomRuntimeObject(Class<T> type, String ipsObjectQualifiedName, T runtimeObject) {
        Map customRuntimeObjects = this.customRuntimeObjectsByType.computeIfAbsent(type, $ -> new HashMap());
        customRuntimeObjects.put(ipsObjectQualifiedName, runtimeObject);
    }

    @Override
    protected <T> T getCustomRuntimeObjectInternal(Class<T> type, String id) {
        Map<String, IRuntimeObject> otherRuntimeObjects = this.customRuntimeObjectsByType.get(type);
        if (otherRuntimeObjects != null) {
            return InMemoryRuntimeRepository.cast(otherRuntimeObjects.get(id));
        }
        return null;
    }

    private static <T> T cast(IRuntimeObject runtimeObject) {
        return (T)runtimeObject;
    }

    private static class ProductCmptGenerationComparator
    implements Comparator<IProductComponentGeneration> {
        private TimeZone timeZone;

        private ProductCmptGenerationComparator(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public int compare(IProductComponentGeneration gen1, IProductComponentGeneration gen2) {
            if (Objects.equals(gen1, gen2)) {
                return 0;
            }
            if (gen1.getValidFrom(this.timeZone).before(gen2.getValidFrom(this.timeZone))) {
                return -1;
            }
            if (gen1.getValidFrom(this.timeZone).after(gen2.getValidFrom(this.timeZone))) {
                return 1;
            }
            return 0;
        }
    }
}

