/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.util.Calendar;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.type.AttributeKind;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.Documentation;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypePart;
import org.faktorips.runtime.model.type.ValueSetKind;

public abstract class Attribute
extends TypePart {
    private final IpsAttribute attributeAnnotation;
    private final Class<?> datatype;
    private final boolean changingOverTime;

    public Attribute(Type type, IpsAttribute attributeAnnotation, IpsExtensionProperties extensionProperties, Class<?> datatype, boolean changingOverTime, Optional<Deprecation> deprecation) {
        super(attributeAnnotation.name(), type, extensionProperties, deprecation);
        this.attributeAnnotation = attributeAnnotation;
        this.datatype = datatype;
        this.changingOverTime = changingOverTime;
    }

    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    public abstract boolean isProductRelevant();

    public Class<?> getDatatype() {
        return this.datatype;
    }

    public AttributeKind getAttributeKind() {
        return this.attributeAnnotation.kind();
    }

    public ValueSetKind getValueSetKind() {
        return this.attributeAnnotation.valueSetKind();
    }

    public boolean isOverriding() {
        return this.getType().findSuperType().map(s -> s.isAttributePresent(this.getName())).orElse(false);
    }

    public Attribute getSuperAttribute() {
        return this.findSuperAttribute().orElse(null);
    }

    public Optional<Attribute> findSuperAttribute() {
        return this.isOverriding() ? this.getType().findSuperType().map(s -> s.getAttribute(this.getName())) : Optional.empty();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(": ");
        sb.append(this.datatype.getSimpleName());
        sb.append('(');
        sb.append((Object)this.getAttributeKind());
        sb.append(", ");
        sb.append((Object)this.getValueSetKind());
        if (this.isProductRelevant()) {
            sb.append(", ");
            sb.append("isProductRelevant");
        }
        sb.append(')');
        return sb.toString();
    }

    public abstract Attribute createOverwritingAttributeFor(Type var1);

    protected Object getRelevantProductObject(IProductComponent productComponent, Calendar effectiveDate) {
        return Attribute.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime());
    }

    @Override
    protected String getDocumentation(Locale locale, DocumentationKind type, String fallback) {
        return Documentation.of(this, type, locale, fallback, this::findSuperAttribute);
    }

    public void validate(MessageList list, IValidationContext context, IProductComponent product, Calendar effectiveDate) {
        Objects.requireNonNull(list, "list must not be null");
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(product, "product must not be null");
    }
}

