/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentLinkSource;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.annotation.IpsAllowedValues;
import org.faktorips.runtime.model.annotation.IpsAllowedValuesSetter;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsConfiguredAttribute;
import org.faktorips.runtime.model.annotation.IpsDefaultValue;
import org.faktorips.runtime.model.annotation.IpsDefaultValueSetter;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.faktorips.values.ObjectUtil;
import org.faktorips.valueset.OrderedValueSet;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.faktorips.valueset.ValueSet;

public class DefaultPolicyAttribute
extends PolicyAttribute {
    public static final String MSGCODE_DEFAULT_VALUE_NOT_IN_VALUE_SET = "POLICY_ATTRIBUTE-DEFAULT_VALUE_NOT_IN_VALUE_SET";
    public static final String MSGCODE_VALUE_SET_NOT_IN_VALUE_SET = "POLICY_ATTRIBUTE-VALUE_SET_NOT_IN_VALUE_SET";
    public static final String PROPERTY_DEFAULT_VALUE = "defaultValue";
    public static final String PROPERTY_VALUE_SET = "valueSet";
    private static final Map<Class<?>, Object> NULL_OBJECTS = new HashMap();
    private static final String RESOURCE_BUNDLE_NAME = DefaultPolicyAttribute.class.getName();
    private static final String MSGKEY_DEFAULT_VALUE_NOT_IN_VALUE_SET = "Validation.DefaultValueNotInValueSet";
    private static final String MSGKEY_VALUE_SET_NOT_IN_VALUE_SET = "Validation.ValueSetNotInValueSet";
    private final Method getter;
    private final Method setter;
    private Method defaultValueGetter;
    private Method defaultValueSetter;
    private Field defaultValueField;
    private Map<Type, Method> valueSetMethods = new HashMap<Type, Method>(2);
    private Map<Type, Field> valueSetFields = new HashMap<Type, Field>(2);
    private Method allowedValuesSetter;

    public DefaultPolicyAttribute(PolicyCmptType policyCmptType, Method getter, Method setter, boolean changingOverTime) {
        super(policyCmptType, getter.getAnnotation(IpsAttribute.class), getter.getAnnotation(IpsExtensionProperties.class), getter.getReturnType(), changingOverTime, Deprecation.of(getter));
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public boolean isProductRelevant() {
        return this.getter.isAnnotationPresent(IpsConfiguredAttribute.class);
    }

    @Override
    public Object getValue(IModelObject modelObject) {
        return DefaultPolicyAttribute.invokeMethod(this.getter, modelObject, new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(IModelObject modelObject, Object value) {
        if (this.setter == null) {
            if (!this.isOverriding()) throw new IllegalArgumentException(String.format("There is no setter for attribute %s in type %s.", this.getName(), this.getType().getName()));
            this.getSuperAttribute().setValue(modelObject, value);
            return;
        } else {
            DefaultPolicyAttribute.invokeMethod(this.setter, modelObject, value);
        }
    }

    @Override
    public Object getDefaultValue(IModelObject modelObject) {
        if (!this.isProductRelevant()) {
            return DefaultPolicyAttribute.invokeField(this.getDefaultValueField(), modelObject);
        }
        IConfigurableModelObject configurableModelObject = (IConfigurableModelObject)modelObject;
        return this.getDefaultValue(configurableModelObject.getProductComponent(), configurableModelObject.getEffectiveFromAsCalendar());
    }

    private Field getDefaultValueField() {
        if (this.defaultValueField == null) {
            this.defaultValueField = this.findDefaultValueField(this.getType());
        }
        return this.defaultValueField;
    }

    private Field findDefaultValueField(Type type) {
        return type.findDeclaredField(IpsDefaultValue.class, a -> a.value().equals(this.getName())).orElseThrow(() -> new IllegalStateException("No field found for retrieving the default value of attribute: " + this.getType().getName() + '.' + this.getName()));
    }

    @Override
    public Object getDefaultValue(IProductComponent source, Calendar effectiveDate) {
        if (!this.isProductRelevant()) {
            throw new IllegalStateException("Trying to find default value method in product class, but policy attribute " + this.getType().getName() + '.' + this.getName() + " is not configurable.");
        }
        return DefaultPolicyAttribute.invokeMethod(this.getDefaultValueGetter(this.getType().getProductCmptType()), this.getRelevantProductObject(source, effectiveDate), new Object[0]);
    }

    private Method getDefaultValueGetter(Type type) {
        if (this.defaultValueGetter == null) {
            this.defaultValueGetter = this.findDefaultValueGetter(type);
        }
        return this.defaultValueGetter;
    }

    private Method findDefaultValueGetter(Type type) {
        return type.findDeclaredMethod(IpsDefaultValue.class, a -> a.value().equals(this.getName())).orElseThrow(() -> new IllegalStateException("No method found for retrieving the default value of attribute: " + this.getType().getName() + '.' + this.getName()));
    }

    @Override
    public void setDefaultValue(IConfigurableModelObject modelObject, Object defaultValue) {
        this.setDefaultValue(modelObject.getProductComponent(), modelObject.getEffectiveFromAsCalendar(), defaultValue);
    }

    @Override
    public void setDefaultValue(IProductComponent source, Calendar effectiveDate, Object defaultValue) {
        if (!this.isProductRelevant()) {
            throw new IllegalStateException("Trying to find default value method in product class, but policy attribute " + this.getType().getName() + '.' + this.getName() + " is not configurable.");
        }
        DefaultPolicyAttribute.invokeMethod(this.getDefaultValueSetter(this.getType().getProductCmptType()), this.getRelevantProductObject(source, effectiveDate), defaultValue);
    }

    private Method getDefaultValueSetter(Type type) {
        if (this.defaultValueSetter == null) {
            this.defaultValueSetter = this.findDefaultValueSetter(type);
        }
        return this.defaultValueSetter;
    }

    private Method findDefaultValueSetter(Type type) {
        Method method = type.searchDeclaredMethod(IpsDefaultValueSetter.class, a -> a.value().equals(this.getName()));
        if (method == null) {
            throw new IllegalStateException("No method found for setting the default value of attribute: " + this.getName());
        }
        return method;
    }

    @Override
    public ValueSet<?> getValueSet(IModelObject modelObject, IValidationContext context) {
        Method valueSetMethod = this.getValueSetMethod(this.getType());
        return this.getValueSet(valueSetMethod, modelObject, context);
    }

    @Override
    public ValueSet<?> getValueSet(IProductComponent source, Calendar effectiveDate, IValidationContext context) {
        Method valueSetMethod = this.getValueSetMethod(this.getType().getProductCmptType());
        Object productObject = this.getRelevantProductObject(source, effectiveDate);
        return this.getValueSet(valueSetMethod, productObject, context);
    }

    @Override
    public ValueSet<?> getValueSetFromModel() {
        Field valueSetField = this.getValueSetField(this.getType());
        try {
            return valueSetField == null ? new UnrestrictedValueSet() : (ValueSet)valueSetField.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("The value can not be retrieved.");
        }
    }

    private ValueSet<?> getValueSet(Method valueSetMethod, Object object, IValidationContext context) {
        if (valueSetMethod == null) {
            if (Boolean.class.equals(this.getDatatype()) || Boolean.TYPE.equals(this.getDatatype())) {
                return new OrderedValueSet(!this.getDatatype().isPrimitive(), null, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
            }
            if (this.getDatatype().isEnum()) {
                return new OrderedValueSet(true, null, (Object[])this.getDatatype().getEnumConstants());
            }
            if (IpsModel.isEnumType(this.getDatatype()) && IpsModel.getEnumType(this.getDatatype()).isExtensible()) {
                IProductComponent productComponent;
                if (object instanceof IProductComponentLinkSource) {
                    IRuntimeRepository repository = ((IProductComponentLinkSource)object).getRepository();
                    return new OrderedValueSet(repository.getEnumValues(this.getDatatype()), true, null);
                }
                if (object instanceof IConfigurableModelObject && (productComponent = ((IConfigurableModelObject)object).getProductComponent()) != null) {
                    IRuntimeRepository repository = productComponent.getRepository();
                    return new OrderedValueSet(repository.getEnumValues(this.getDatatype()), true, null);
                }
            }
            return new UnrestrictedValueSet(!this.getDatatype().isPrimitive());
        }
        if (valueSetMethod.getParameterTypes().length == 0) {
            return (ValueSet)DefaultPolicyAttribute.invokeMethod(valueSetMethod, object, new Object[0]);
        }
        if (valueSetMethod.getParameterTypes().length == 1) {
            return (ValueSet)DefaultPolicyAttribute.invokeMethod(valueSetMethod, object, context);
        }
        throw new IllegalStateException("The method for retrieving the allowed values of attribute: " + this.getName() + " has too many arguments: " + valueSetMethod);
    }

    private Method getValueSetMethod(Type model) {
        if (this.valueSetMethods.containsKey(model)) {
            return this.valueSetMethods.get(model);
        }
        Method valueSetMethod = this.findValueSetMethod(model);
        this.valueSetMethods.put(model, valueSetMethod);
        return valueSetMethod;
    }

    private Field getValueSetField(Type model) {
        if (this.valueSetFields.containsKey(model)) {
            return this.valueSetFields.get(model);
        }
        Field valueSetField = this.findValueSetField(model);
        this.valueSetFields.put(model, valueSetField);
        return valueSetField;
    }

    @Override
    public DefaultPolicyAttribute createOverwritingAttributeFor(Type subType) {
        return new DefaultPolicyAttribute((PolicyCmptType)subType, this.getter, this.setter, this.isChangingOverTime());
    }

    private Method findValueSetMethod(Type type) {
        return type.searchDeclaredMethod(IpsAllowedValues.class, a -> a.value().equals(this.getName()));
    }

    private Field findValueSetField(Type type) {
        return type.findDeclaredField(IpsAllowedValues.class, a -> a.value().equals(this.getName())).orElse(null);
    }

    @Override
    public void setValueSet(IConfigurableModelObject modelObject, ValueSet<?> valueSet) {
        this.setValueSet(modelObject.getProductComponent(), modelObject.getEffectiveFromAsCalendar(), valueSet);
    }

    @Override
    public void setValueSet(IProductComponent source, Calendar effectiveDate, ValueSet<?> valueSet) {
        if (!this.isProductRelevant()) {
            throw new IllegalStateException("Trying to find setter method for allowed values in product class, but policy attribute " + this.getType().getName() + '.' + this.getName() + " is not configurable.");
        }
        DefaultPolicyAttribute.invokeMethod(this.getAllowedValuesSetter(this.getType().getProductCmptType()), this.getRelevantProductObject(source, effectiveDate), valueSet);
    }

    private Method getAllowedValuesSetter(Type type) {
        if (this.allowedValuesSetter == null) {
            this.allowedValuesSetter = this.findAllowedValuesSetter(type);
        }
        return this.allowedValuesSetter;
    }

    private Method findAllowedValuesSetter(Type type) {
        Method method = type.searchDeclaredMethod(IpsAllowedValuesSetter.class, a -> a.value().equals(this.getName()));
        if (method == null) {
            throw new IllegalStateException("No method found for setting the allowed values of attribute: " + this.getName());
        }
        return method;
    }

    @Override
    public void removeValue(IModelObject modelObject) {
        this.setValue(modelObject, NULL_OBJECTS.get(this.getDatatype()));
    }

    @Override
    public void validate(MessageList list, IValidationContext context, IProductComponent product, Calendar effectiveDate) {
        super.validate(list, context, product, effectiveDate);
        this.validateDefaultValue(list, context, product, effectiveDate);
        this.validateValueSet(list, context, product, effectiveDate);
    }

    <T> void validateDefaultValue(MessageList list, IValidationContext context, IProductComponent source, Calendar effectiveDate) {
        this.validate(list, context, () -> this.getDefaultValue(source, effectiveDate), () -> this.getValueSet(source, effectiveDate, context), (defaultValue, valueSet) -> valueSet.contains(defaultValue), MSGCODE_DEFAULT_VALUE_NOT_IN_VALUE_SET, MSGKEY_DEFAULT_VALUE_NOT_IN_VALUE_SET, PROPERTY_DEFAULT_VALUE);
    }

    <T> void validateValueSet(MessageList list, IValidationContext context, IProductComponent source, Calendar effectiveDate) {
        this.validate(list, context, () -> this.getValueSet(source, effectiveDate, context), () -> this.getValueSetFromModel(), ValueSet::isSubsetOf, MSGCODE_VALUE_SET_NOT_IN_VALUE_SET, MSGKEY_VALUE_SET_NOT_IN_VALUE_SET, PROPERTY_VALUE_SET);
    }

    private <V, R> void validate(MessageList list, IValidationContext context, Supplier<V> valueGetter, Supplier<R> referenceValueGetter, BiPredicate<V, R> valueChecker, String msgCode, String msgKey, String property) {
        R referenceValue;
        V value = valueGetter.get();
        if (!(ObjectUtil.isNull(value) || ObjectUtil.isNull(referenceValue = referenceValueGetter.get()) || valueChecker.test(value, referenceValue))) {
            Locale locale = context.getLocale();
            ResourceBundle messages = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale);
            list.newError(msgCode, String.format(messages.getString(msgKey), value, this.getLabel(locale), referenceValue), this, property);
        }
    }

    static {
        NULL_OBJECTS.put(Decimal.class, Decimal.NULL);
        NULL_OBJECTS.put(Money.class, Money.NULL);
        NULL_OBJECTS.put(String.class, "");
    }
}

