/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.TreeMap;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.IProductObject;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.IllegalRepositoryModificationException;
import org.faktorips.runtime.formula.IFormulaEvaluator;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.FormulaHandler;
import org.faktorips.runtime.internal.IXmlPersistenceSupport;
import org.faktorips.runtime.internal.ProductComponentGeneration;
import org.faktorips.runtime.internal.ProductComponentXmlUtil;
import org.faktorips.runtime.internal.RuntimeObject;
import org.faktorips.runtime.internal.ValidationRules;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.runtime.xml.IToXmlSupport;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.InternationalString;
import org.faktorips.values.LocalizedString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ProductComponent
extends RuntimeObject
implements IProductComponent,
IXmlPersistenceSupport {
    public static final String PROPERTY_IMPLEMENTATION_CLASS = "implementationClass";
    protected static final String ATTRIBUTE_NAME_VARIED_PRODUCT_CMPT = "variedProductCmpt";
    private static final String XML_ELEMENT_DESCRIPTION = "Description";
    private static final String XML_ELEMENT_ATTRIBUTE_VALUE = "AttributeValue";
    private static final String XML_ELEMENT_GENERATION = "Generation";
    private static final String XML_ELEMENT_CONFIGURED_VALUE_SET = "ConfiguredValueSet";
    private static final String XML_ATTRIBUTE_LOCALE = "locale";
    private static final String XML_ATTRIBUTE_ATTRIBUTE = "attribute";
    private static final String XML_ATTRIBUTE_VALID_FROM = "validFrom";
    private static final String XML_ATTRIBUTE_IS_NULL = "isNull";
    private static final String XML_ATTRIBUTE_VALID_TO = "validTo";
    private String id;
    private transient IRuntimeRepository repository;
    private final String productKindId;
    private final String versionId;
    private String variedBase;
    private DateTime validFrom;
    private DateTime validTo;
    private final FormulaHandler formulaHandler;
    private InternationalString description;
    private final ValidationRules validationRules;
    private String qualifiedName;

    public ProductComponent(IRuntimeRepository repository, String id, String productKindId, String versionId) {
        if (repository == null) {
            throw new NullPointerException("RuntimeRepository was null!");
        }
        if (id == null) {
            throw new NullPointerException("Id was null!");
        }
        if (productKindId == null) {
            throw new NullPointerException("ProductKindId was null");
        }
        if (versionId == null) {
            throw new NullPointerException("VersionId was null");
        }
        this.repository = repository;
        this.id = id;
        this.productKindId = productKindId;
        this.versionId = versionId;
        this.formulaHandler = new FormulaHandler(this, this.repository);
        this.validationRules = new ValidationRules(this);
    }

    @Override
    public String getKindId() {
        return this.productKindId;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    @Override
    public boolean isVariant() {
        return this.variedBase != null;
    }

    @Override
    public IProductComponent getVariedBase() {
        if (this.isVariant()) {
            return this.repository.getProductComponent(this.variedBase);
        }
        return null;
    }

    public void setVariedBase(ProductComponent variedBase) {
        if (this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.variedBase = variedBase == null ? null : variedBase.id;
    }

    @Override
    public DateTime getValidFrom() {
        return this.validFrom;
    }

    @Override
    public Date getValidFrom(TimeZone zone) {
        return this.validFrom.toDate(zone);
    }

    public void setValidFrom(DateTime validfrom) {
        if (this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        if (validfrom == null) {
            throw new NullPointerException();
        }
        this.validFrom = validfrom;
    }

    @Override
    public DateTime getValidTo() {
        return this.validTo;
    }

    public void setValidTo(DateTime validTo) {
        if (this.getRepository() != null && !this.getRepository().isModifiable()) {
            throw new IllegalRepositoryModificationException();
        }
        this.validTo = validTo;
    }

    @Override
    public IRuntimeRepository getRepository() {
        return this.repository;
    }

    @Override
    public IProductComponentGeneration getGenerationBase(Calendar effectiveDate) {
        if (!this.isChangingOverTime()) {
            throw new UnsupportedOperationException();
        }
        return this.getRepository().getProductComponentGeneration(this.id, effectiveDate);
    }

    @Override
    public IProductComponentGeneration getLatestProductComponentGeneration() {
        if (!this.isChangingOverTime()) {
            throw new UnsupportedOperationException();
        }
        return this.getRepository().getLatestProductComponentGeneration(this);
    }

    public IFormulaEvaluator getFormulaEvaluator() {
        return this.formulaHandler.getFormulaEvaluator();
    }

    @Override
    public String getDescription(Locale locale) {
        String string = this.description.get(locale);
        if (string == null) {
            return "";
        }
        return string;
    }

    @Override
    public void initFromXml(Element cmptElement) {
        String validFromValue = cmptElement.getAttribute(XML_ATTRIBUTE_VALID_FROM);
        this.validFrom = DateTime.parseIso(validFromValue);
        Element validToNode = (Element)cmptElement.getElementsByTagName(XML_ATTRIBUTE_VALID_TO).item(0);
        this.validTo = validToNode == null || Boolean.parseBoolean(validToNode.getAttribute(XML_ATTRIBUTE_IS_NULL)) ? null : DateTime.parseIso(validToNode.getTextContent());
        Map<String, Element> propertyElements = ProductComponentXmlUtil.getPropertyElements(cmptElement);
        this.doInitPropertiesFromXml(propertyElements);
        this.doInitTableUsagesFromXml(propertyElements);
        this.doInitFormulaFromXml(cmptElement);
        this.doInitReferencesFromXml(ProductComponentXmlUtil.getLinkElements(cmptElement));
        this.doInitValidationRuleConfigsFromXml(cmptElement);
        this.initExtensionPropertiesFromXml(cmptElement);
        this.initDescriptions(cmptElement);
        this.variedBase = cmptElement.getAttribute(ATTRIBUTE_NAME_VARIED_PRODUCT_CMPT);
        if ("".equals(this.variedBase)) {
            this.variedBase = null;
        }
    }

    protected void doInitPropertiesFromXml(Map<String, Element> map) {
    }

    protected void doInitTableUsagesFromXml(Map<String, Element> map) {
    }

    protected void doInitFormulaFromXml(Element element) {
        this.formulaHandler.doInitFormulaFromXml(element);
    }

    protected boolean isFormulaAvailable(String formularSignature) {
        return this.formulaHandler.isFormulaAvailable(formularSignature);
    }

    protected void doInitReferencesFromXml(Map<String, List<Element>> linkElements) {
    }

    protected void doInitValidationRuleConfigsFromXml(Element element) {
        this.validationRules.doInitValidationRuleConfigsFromXml(element);
    }

    private void initDescriptions(Element cmptElement) {
        List<Element> descriptionElements = XmlUtil.getElements(cmptElement, XML_ELEMENT_DESCRIPTION);
        ArrayList<LocalizedString> descriptions = new ArrayList<LocalizedString>(descriptionElements.size());
        for (Element descriptionElement : descriptionElements) {
            String localeCode = descriptionElement.getAttribute(XML_ATTRIBUTE_LOCALE);
            Locale locale = "".equals(localeCode) ? null : new Locale(localeCode);
            String text = descriptionElement.getTextContent();
            descriptions.add(new LocalizedString(locale, text));
        }
        this.description = new DefaultInternationalString(descriptions, descriptions.isEmpty() ? null : ((LocalizedString)descriptions.get(0)).getLocale());
    }

    public String toString() {
        return this.id;
    }

    @Override
    public Element toXml(Document document) {
        return this.toXml(document, true);
    }

    public Element toXml(Document document, boolean includeGenerations) {
        IToXmlSupport.check(this);
        Element prodCmptElement = document.createElement("ProductCmpt");
        prodCmptElement.setAttribute(PROPERTY_IMPLEMENTATION_CLASS, this.getClass().getName());
        prodCmptElement.setAttribute("xml:space", "preserve");
        this.writeValidFromToXml(prodCmptElement);
        this.writeValidToToXml(prodCmptElement);
        this.writeDescriptionToXml(prodCmptElement);
        if (this.getRepository().getNumberOfProductComponentGenerations(this) == 0) {
            Element emptyGenerationElement = prodCmptElement.getOwnerDocument().createElement(XML_ELEMENT_GENERATION);
            if (this.validFrom != null) {
                emptyGenerationElement.setAttribute(XML_ATTRIBUTE_VALID_FROM, this.validFrom.toIsoFormat());
            }
            prodCmptElement.appendChild(emptyGenerationElement);
        }
        if (includeGenerations) {
            List<IProductComponentGeneration> generations = this.getRepository().getProductComponentGenerations(this);
            Collections.sort(generations, Comparator.comparing(IProductObject::getValidFrom));
            for (IProductComponentGeneration generation : generations) {
                ProductComponentGeneration gen = (ProductComponentGeneration)generation;
                prodCmptElement.appendChild(gen.toXml(document));
            }
        }
        ((IToXmlSupport)((Object)this)).writePropertiesToXml(prodCmptElement);
        this.writeTableUsagesToXml(prodCmptElement);
        this.writeFormulaToXml(prodCmptElement);
        this.writeReferencesToXml(prodCmptElement);
        this.writeValidationRuleConfigsToXml(prodCmptElement);
        this.writeExtensionPropertiesToXml(prodCmptElement);
        return this.sortAttributeNodesInAlphabeticalOrder(prodCmptElement);
    }

    private Element sortAttributeNodesInAlphabeticalOrder(Element prodCmptElement) {
        this.sortAttributeValues(prodCmptElement);
        this.sortConfiguredValues(prodCmptElement);
        NodeList childNodes = prodCmptElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!node.getNodeName().equals(XML_ELEMENT_GENERATION)) continue;
            this.sortAttributeValues((Element)node);
            this.sortConfiguredValues((Element)node);
        }
        return prodCmptElement;
    }

    private void sortAttributeValues(Element root) {
        List<Node> nodes = this.getChildNodes(root);
        ArrayList<Element> toSort = new ArrayList<Element>();
        for (Node node : nodes) {
            if (!node.getNodeName().equals(XML_ELEMENT_ATTRIBUTE_VALUE)) continue;
            toSort.add((Element)node);
        }
        Collections.sort(toSort, (o1, o2) -> o1.getAttribute(XML_ATTRIBUTE_ATTRIBUTE).compareTo(o2.getAttribute(XML_ATTRIBUTE_ATTRIBUTE)));
        Node refChild = this.getFirstNodeOf(nodes, XML_ELEMENT_ATTRIBUTE_VALUE);
        for (Element element : toSort) {
            if (!element.equals(refChild)) {
                root.insertBefore(element, refChild);
            }
            refChild = element.getNextSibling();
        }
    }

    private void sortConfiguredValues(Element root) {
        List<Node> nodes = this.getChildNodes(root);
        TreeMap<Element, Element> toSort = new TreeMap<Element, Element>((o1, o2) -> o1.getAttribute(XML_ATTRIBUTE_ATTRIBUTE).compareTo(o2.getAttribute(XML_ATTRIBUTE_ATTRIBUTE)));
        Iterator<Node> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (!node.getNodeName().equals(XML_ELEMENT_CONFIGURED_VALUE_SET)) continue;
            toSort.put((Element)node, (Element)iterator.next());
        }
        Node refChild = this.getFirstNodeOf(nodes, XML_ELEMENT_CONFIGURED_VALUE_SET);
        for (Map.Entry e : toSort.entrySet()) {
            Element valueSet = (Element)e.getKey();
            Element defaultValue = (Element)e.getValue();
            root.insertBefore(valueSet, refChild);
            root.insertBefore(defaultValue, valueSet.getNextSibling());
            refChild = defaultValue.getNextSibling();
        }
    }

    private Node getFirstNodeOf(List<Node> nodes, String name) {
        Node refChild = null;
        Optional<Node> ft = nodes.stream().filter(n -> n.getNodeName().equals(name)).findFirst();
        if (ft.isPresent()) {
            refChild = ft.get();
        }
        return refChild;
    }

    private List<Node> getChildNodes(Element prodCmptElement) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList childNodes = prodCmptElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            nodes.add(childNodes.item(i));
        }
        return nodes;
    }

    private void writeValidFromToXml(Element prodCmptElement) {
        if (this.validFrom != null) {
            prodCmptElement.setAttribute(XML_ATTRIBUTE_VALID_FROM, this.validFrom.toIsoFormat());
        }
    }

    private void writeValidToToXml(Element prodCmptElement) {
        Element validToElement = prodCmptElement.getOwnerDocument().createElement(XML_ATTRIBUTE_VALID_TO);
        if (this.validTo != null) {
            validToElement.setTextContent(this.validTo.toIsoFormat());
        } else {
            validToElement.setAttribute(XML_ATTRIBUTE_IS_NULL, Boolean.TRUE.toString());
        }
        prodCmptElement.appendChild(validToElement);
    }

    protected void writeTableUsagesToXml(Element element) {
    }

    protected void writeTableUsageToXml(Element element, String structureUsage, String tableContentName) {
        ValueToXmlHelper.addTableUsageToElement(element, structureUsage, tableContentName);
    }

    private void writeDescriptionToXml(Element prodCmptElement) {
        if (this.description != null) {
            for (LocalizedString localizedString : ((DefaultInternationalString)this.description).getLocalizedStrings()) {
                Element descriptionElement = prodCmptElement.getOwnerDocument().createElement(XML_ELEMENT_DESCRIPTION);
                descriptionElement.setAttribute(XML_ATTRIBUTE_LOCALE, localizedString.getLocale().toString());
                descriptionElement.setTextContent(localizedString.getValue());
                prodCmptElement.appendChild(descriptionElement);
            }
        }
    }

    @Override
    public IProductComponentLink<? extends IProductComponent> getLink(String linkName, IProductComponent target) {
        return null;
    }

    @Override
    public List<IProductComponentLink<? extends IProductComponent>> getLinks() {
        return new ArrayList<IProductComponentLink<? extends IProductComponent>>();
    }

    protected void writeReferencesToXml(Element element) {
    }

    protected void writeValidationRuleConfigsToXml(Element genElement) {
        this.validationRules.writeValidationRuleConfigsToXml(genElement);
    }

    protected void writeFormulaToXml(Element element) {
        this.formulaHandler.writeFormulaToXml(element);
    }

    @Override
    public boolean isValidationRuleActivated(String ruleName) {
        return this.validationRules.isValidationRuleActivated(ruleName);
    }

    @Override
    public void setValidationRuleActivated(String ruleName, boolean active) {
        this.validationRules.setValidationRuleActivated(ruleName, active);
    }
}

