/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.type.Attribute;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;

public class ProductAttribute
extends Attribute {
    public static final String MSGCODE_VALUE_NOT_IN_VALUE_SET = "PRODUCT_ATTRIBUTE-VALUE_NOT_IN_VALUE_SET";
    public static final String MSGKEY_VALUE_NOT_IN_VALUE_SET = "Validation.ValueNotInValueSet";
    public static final String MSGCODE_DUPLICATE_VALUE = "PRODUCT_ATTRIBUTE-DUPLICATE_VALUE";
    public static final String MSGKEY_DUPLICATE_VALUE = "Validation.DuplicateValue";
    public static final String PROPERTY_VALUE = "value";
    private final Method getter;
    private final Method setter;

    public ProductAttribute(Type type, boolean changingOverTime, Method getter, Method setter) {
        super(type, getter.getAnnotation(IpsAttribute.class), getter.getAnnotation(IpsExtensionProperties.class), ProductAttribute.findDatatype(getter), changingOverTime, Deprecation.of(getter));
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public ProductCmptType getType() {
        return (ProductCmptType)super.getType();
    }

    @Override
    @Deprecated
    public ProductCmptType getModelType() {
        return this.getType();
    }

    @Override
    public boolean isProductRelevant() {
        return true;
    }

    @Override
    public Attribute createOverwritingAttributeFor(Type subType) {
        return new ProductAttribute(subType, this.isChangingOverTime(), this.getter, this.setter);
    }

    public <T> T getValue(IProductComponent productComponent, Calendar effectiveDate) {
        return (T)ProductAttribute.invokeMethod(this.getter, this.getRelevantProductObject(productComponent, effectiveDate), new Object[0]);
    }

    public void setValue(IProductComponent productComponent, Calendar effectiveDate, Object value) {
        ProductAttribute.invokeMethod(this.setter, this.getRelevantProductObject(productComponent, effectiveDate), value);
    }

    public boolean isMultiValue() {
        return this.getter.getReturnType().equals(List.class);
    }

    @Override
    public void validate(MessageList list, IValidationContext context, IProductComponent product, Calendar effectiveDate) {
        super.validate(list, context, product, effectiveDate);
        this.validateValue(list, context, product, effectiveDate);
    }

    private <T> void validateValue(MessageList list, IValidationContext context, IProductComponent product, Calendar effectiveDate) {
        this.validate(list, context, () -> this.getValue(product, effectiveDate), () -> this.getValueSetFromModel(), (value, valueSet) -> valueSet.contains(value), MSGCODE_VALUE_NOT_IN_VALUE_SET, MSGKEY_VALUE_NOT_IN_VALUE_SET, PROPERTY_VALUE);
        this.validate(list, context, () -> this.getValue(product, effectiveDate), this::isMultiValue, (value, multiValue) -> multiValue == false || new HashSet((List)value).size() == ((List)value).size(), MSGCODE_DUPLICATE_VALUE, MSGKEY_DUPLICATE_VALUE, PROPERTY_VALUE);
    }

    @Override
    public <T> T getDefaultValueFromModel() {
        Object defaultValue = super.getDefaultValueFromModel();
        if (this.isMultiValue() && "".equals(defaultValue)) {
            return (T)Arrays.asList(defaultValue);
        }
        return defaultValue;
    }

    private static final Class<?> findDatatype(Method getter) {
        return ProductAttribute.getInnermostGenericClass(getter.getGenericReturnType(), getter.getAnnotation(IpsAttribute.class).primitive());
    }

    private static final Class<?> getInnermostGenericClass(java.lang.reflect.Type type, boolean primitive) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (primitive && !clazz.isPrimitive()) {
                try {
                    clazz = (Class)clazz.getDeclaredField("TYPE").get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    throw new IllegalArgumentException("can't find class for " + type.toString(), e);
                }
            }
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            return ProductAttribute.getInnermostGenericClass(((ParameterizedType)type).getActualTypeArguments()[0], primitive);
        }
        if (type instanceof WildcardType) {
            return ProductAttribute.getInnermostGenericClass(((WildcardType)type).getUpperBounds()[0], primitive);
        }
        throw new IllegalArgumentException("can't find class for " + type.toString());
    }

    @Override
    protected String getResourceBundleName() {
        return ProductAttribute.class.getName();
    }
}

