/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.faktorips.runtime.CardinalityRange;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.IProductComponentLinkSource;
import org.faktorips.runtime.internal.IXmlPersistenceSupport;
import org.faktorips.runtime.internal.RuntimeObject;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.InternationalString;
import org.faktorips.values.LocalizedString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProductComponentLink<T extends IProductComponent>
extends RuntimeObject
implements IProductComponentLink<T>,
IXmlPersistenceSupport {
    private static final String XML_ELEMENT_DESCRIPTION = "Description";
    private static final String XML_ATTRIBUTE_LOCALE = "locale";
    private final IProductComponentLinkSource source;
    private CardinalityRange cardinality;
    private String targetName;
    private String targetId;
    private String associationName;
    private InternationalString description;

    public ProductComponentLink(IProductComponentGeneration source) {
        this((IProductComponentLinkSource)source);
    }

    public ProductComponentLink(IProductComponentGeneration source, T target) {
        this((IProductComponentLinkSource)source, target, CardinalityRange.FULL_RANGE);
    }

    public ProductComponentLink(IProductComponentGeneration source, T target, CardinalityRange cardinality) {
        this((IProductComponentLinkSource)source, target, cardinality);
    }

    public ProductComponentLink(IProductComponentLinkSource source) {
        this.source = source;
    }

    public ProductComponentLink(IProductComponentLinkSource source, T target) {
        this(source, target, CardinalityRange.FULL_RANGE);
    }

    public ProductComponentLink(IProductComponentLinkSource source, T target, String associationName) {
        this(source, target);
        if (associationName == null) {
            throw new NullPointerException("The associationName for the ProductComponentLink may not be null.");
        }
        this.associationName = associationName;
    }

    public ProductComponentLink(IProductComponentLinkSource source, T target, CardinalityRange cardinality) {
        if (source == null) {
            throw new NullPointerException("The source for the ProductComponentLink may not be null.");
        }
        this.source = source;
        if (target == null) {
            throw new NullPointerException("The targetId for the ProductComponentLink may not be null.");
        }
        this.targetId = target.getId();
        this.targetName = target.getQualifiedName();
        if (cardinality == null) {
            throw new NullPointerException("The cardinality for the ProductComponentLink may not be null.");
        }
        this.cardinality = cardinality;
    }

    public ProductComponentLink(IProductComponentLinkSource source, T target, CardinalityRange cardinality, String associationName) {
        this(source, target, cardinality);
        if (associationName == null) {
            throw new NullPointerException("The associationName for the ProductComponentLink may not be null.");
        }
        this.associationName = associationName;
    }

    @Override
    public CardinalityRange getCardinality() {
        return this.cardinality;
    }

    @Override
    public void initFromXml(Element element) {
        this.associationName = element.getAttribute("association");
        this.targetId = element.getAttribute("targetRuntimeId");
        this.targetName = element.getAttribute("target");
        String maxStr = element.getAttribute("maxCardinality");
        Integer maxCardinality = null;
        maxCardinality = "*".equals(maxStr) || "n".equals(maxStr.toLowerCase()) ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf(maxStr);
        Integer minCardinality = Integer.valueOf(element.getAttribute("minCardinality"));
        Integer defaultCardinality = Integer.valueOf(element.getAttribute("defaultCardinality"));
        this.cardinality = maxCardinality == null || Integer.valueOf(0).equals(maxCardinality) ? CardinalityRange.EXCLUDED : new CardinalityRange(minCardinality, maxCardinality, defaultCardinality);
        this.initExtensionPropertiesFromXml(element);
        this.initDescriptions(element);
    }

    @Override
    public Element toXml(Document document) {
        Integer upperBound = (Integer)this.getCardinality().getUpperBound();
        Element linkElement = document.createElement("Link");
        linkElement.setAttribute("association", this.getAssociationName());
        linkElement.setAttribute("defaultCardinality", Integer.toString(this.getCardinality().getDefaultCardinality()));
        linkElement.setAttribute("maxCardinality", upperBound == Integer.MAX_VALUE ? "*" : Integer.toString(upperBound));
        linkElement.setAttribute("minCardinality", Integer.toString((Integer)this.getCardinality().getLowerBound()));
        linkElement.setAttribute("target", this.targetName);
        linkElement.setAttribute("targetRuntimeId", this.getTargetId());
        this.writeExtensionPropertiesToXml(linkElement);
        this.writeDescriptionToXml(linkElement);
        return linkElement;
    }

    @Override
    public T getTarget() {
        try {
            return (T)this.source.getRepository().getExistingProductComponent(this.targetId);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    @Override
    public String getAssociationName() {
        return this.associationName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.targetId);
        sb.append('(');
        sb.append(this.cardinality.getLowerBound());
        sb.append("..");
        sb.append(Integer.valueOf(Integer.MAX_VALUE).equals(this.cardinality.getUpperBound()) ? "*" : this.cardinality.getUpperBound());
        sb.append(", default:");
        sb.append(this.cardinality.getDefaultCardinality());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public IProductComponentLinkSource getSource() {
        return this.source;
    }

    @Override
    public String getDescription(Locale locale) {
        String string = this.description.get(locale);
        if (string == null) {
            return "";
        }
        return string;
    }

    private void initDescriptions(Element cmptElement) {
        List<Element> descriptionElements = XmlUtil.getElements(cmptElement, XML_ELEMENT_DESCRIPTION);
        ArrayList<LocalizedString> descriptions = new ArrayList<LocalizedString>(descriptionElements.size());
        for (Element descriptionElement : descriptionElements) {
            String localeCode = descriptionElement.getAttribute(XML_ATTRIBUTE_LOCALE);
            Locale locale = "".equals(localeCode) ? null : new Locale(localeCode);
            String text = descriptionElement.getTextContent();
            descriptions.add(new LocalizedString(locale, text));
        }
        this.description = new DefaultInternationalString(descriptions, descriptions.isEmpty() ? null : ((LocalizedString)descriptions.get(0)).getLocale());
    }

    private void writeDescriptionToXml(Element linkElement) {
        if (this.description != null) {
            for (LocalizedString localizedString : ((DefaultInternationalString)this.description).getLocalizedStrings()) {
                Element descriptionElement = linkElement.getOwnerDocument().createElement(XML_ELEMENT_DESCRIPTION);
                descriptionElement.setAttribute(XML_ATTRIBUTE_LOCALE, localizedString.getLocale().toString());
                descriptionElement.setTextContent(localizedString.getValue());
                linkElement.appendChild(descriptionElement);
            }
        }
    }
}

