/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.xml;

import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.AbstractRuntimeRepository;
import org.faktorips.runtime.xml.IIpsXmlAdapter;
import org.faktorips.runtime.xml.IXmlBindingSupport;

public class XmlBindingSupportHelper<JAXBContext>
implements IXmlBindingSupport<JAXBContext> {
    private final Class<? extends Annotation> xmlRootAnnotationClass;
    private final Function<Class<?>[], JAXBContext> jaxbContextConstructor;
    private final XmlBindingContextConstructor<JAXBContext> xmlBindingContextConstructor;

    public XmlBindingSupportHelper(Class<? extends Annotation> xmlRootAnnotationClass, Function<Class<?>[], JAXBContext> jaxbContextConstructor, XmlBindingContextConstructor<JAXBContext> xmlBindingContextConstructor) {
        this.xmlRootAnnotationClass = xmlRootAnnotationClass;
        this.jaxbContextConstructor = jaxbContextConstructor;
        this.xmlBindingContextConstructor = xmlBindingContextConstructor;
    }

    @Override
    public JAXBContext newJAXBContext(IRuntimeRepository repository) {
        ClassLoader tccl = null;
        try {
            Class<?>[] classes = XmlBindingSupportHelper.collectAnnotatedClasses(repository, this.xmlRootAnnotationClass);
            tccl = XmlBindingSupportHelper.getPrivilegedCurrentThreadContextClassLoader();
            Thread.currentThread().setContextClassLoader(repository.getClassLoader());
            JAXBContext ctx = this.jaxbContextConstructor.apply(classes);
            JAXBContext JAXBContext = this.newJAXBContext(ctx, repository);
            return JAXBContext;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (tccl != null) {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    @Override
    public JAXBContext newJAXBContext(JAXBContext ctx, IRuntimeRepository repository) {
        LinkedList adapters = new LinkedList();
        ((AbstractRuntimeRepository)repository).addAllEnumXmlAdapters(adapters, repository);
        for (IRuntimeRepository runtimeRepository : repository.getAllReferencedRepositories()) {
            AbstractRuntimeRepository refRepository = (AbstractRuntimeRepository)runtimeRepository;
            refRepository.addAllEnumXmlAdapters(adapters, repository);
        }
        return this.xmlBindingContextConstructor.invoke(ctx, adapters, repository);
    }

    private static Class<?>[] collectAnnotatedClasses(IRuntimeRepository repository, Class<? extends Annotation> xmlRootAnnotationClass) throws ClassNotFoundException {
        Set<String> classNames = repository.getAllModelTypeImplementationClasses();
        LinkedHashSet classes = new LinkedHashSet(classNames.size());
        for (String className : classNames) {
            Class<?> clazz = repository.getClassLoader().loadClass(className);
            if (!XmlBindingSupportHelper.isAnnotatedXmlRootElement(clazz, xmlRootAnnotationClass)) continue;
            classes.add(clazz);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static ClassLoader getPrivilegedCurrentThreadContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(Thread.currentThread()::getContextClassLoader);
    }

    private static boolean isAnnotatedXmlRootElement(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            if (!c.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface XmlBindingContextConstructor<JAXBContext> {
        public JAXBContext invoke(JAXBContext var1, List<? extends IIpsXmlAdapter<?, ?>> var2, IRuntimeRepository var3);
    }
}

