/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.util.Calendar;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.type.AttributeKind;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.Documentation;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.FieldFinder;
import org.faktorips.runtime.model.type.NullObjects;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypePart;
import org.faktorips.runtime.model.type.ValueSetKind;
import org.faktorips.values.ObjectUtil;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.faktorips.valueset.ValueSet;

public abstract class Attribute
extends TypePart {
    private final IpsAttribute attributeAnnotation;
    private final Class<?> datatype;
    private final boolean changingOverTime;
    private final FieldFinder.ModelValueSet modelValueSet;
    private final FieldFinder.ModelDefaultValue modelDefaultValue;

    public Attribute(Type type, IpsAttribute attributeAnnotation, IpsExtensionProperties extensionProperties, Class<?> datatype, boolean changingOverTime, Optional<Deprecation> deprecation) {
        super(attributeAnnotation.name(), type, extensionProperties, deprecation);
        this.attributeAnnotation = attributeAnnotation;
        this.datatype = datatype;
        this.changingOverTime = changingOverTime;
        this.modelValueSet = new FieldFinder.ModelValueSet(type, this.getName(), changingOverTime);
        this.modelDefaultValue = new FieldFinder.ModelDefaultValue(type, this.getName(), changingOverTime);
    }

    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    public abstract boolean isProductRelevant();

    public Class<?> getDatatype() {
        return this.datatype;
    }

    public AttributeKind getAttributeKind() {
        return this.attributeAnnotation.kind();
    }

    public ValueSetKind getValueSetKind() {
        return this.attributeAnnotation.valueSetKind();
    }

    public boolean isOverriding() {
        return this.getType().findSuperType().map(s -> s.isAttributePresent(this.getName())).orElse(false);
    }

    public Attribute getSuperAttribute() {
        return this.findSuperAttribute().orElse(null);
    }

    public Optional<Attribute> findSuperAttribute() {
        return this.isOverriding() ? this.getType().findSuperType().map(s -> s.getAttribute(this.getName())) : Optional.empty();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(": ");
        sb.append(this.datatype.getSimpleName());
        sb.append('(');
        sb.append((Object)this.getAttributeKind());
        sb.append(", ");
        sb.append((Object)this.getValueSetKind());
        if (this.isProductRelevant()) {
            sb.append(", ");
            sb.append("isProductRelevant");
        }
        sb.append(')');
        return sb.toString();
    }

    public abstract Attribute createOverwritingAttributeFor(Type var1);

    protected Object getRelevantProductObject(IProductComponent productComponent, Calendar effectiveDate) {
        return Attribute.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime());
    }

    @Override
    protected String getDocumentation(Locale locale, DocumentationKind type, String fallback) {
        return Documentation.of(this, type, locale, fallback, this::findSuperAttribute);
    }

    public void validate(MessageList list, IValidationContext context, IProductComponent product, Calendar effectiveDate) {
        Objects.requireNonNull(list, "list must not be null");
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(product, "product must not be null");
    }

    public ValueSet<?> getValueSetFromModel() {
        return this.modelValueSet.get().orElseGet(UnrestrictedValueSet::new);
    }

    public <T> T getDefaultValueFromModel() {
        return (T)this.modelDefaultValue.get().orElseGet(() -> NullObjects.of(this.getDatatype()));
    }

    protected <V, R> void validate(MessageList list, IValidationContext context, Supplier<V> valueGetter, Supplier<R> referenceValueGetter, BiPredicate<V, R> valueChecker, String msgCode, String msgKey, String property) {
        R referenceValue;
        V value = valueGetter.get();
        if (!(ObjectUtil.isNull(value) || ObjectUtil.isNull(referenceValue = referenceValueGetter.get()) || valueChecker.test(value, referenceValue))) {
            Locale locale = context.getLocale();
            ResourceBundle messages = ResourceBundle.getBundle(this.getResourceBundleName(), locale);
            list.newError(msgCode, String.format(messages.getString(msgKey), value, this.getLabel(locale), referenceValue), this, property);
        }
    }

    protected abstract String getResourceBundleName();
}

