/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.validation;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.faktorips.runtime.IMarker;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.validation.GenericRelevanceValidation;
import org.faktorips.runtime.validation.IGenericAttributeValidationConfiguration;
import org.faktorips.values.ObjectUtil;
import org.faktorips.valueset.Range;
import org.faktorips.valueset.ValueSet;

public class DefaultGenericAttributeValidationConfiguration
implements IGenericAttributeValidationConfiguration {
    public static final String ERROR_MANDATORY_MSG_CODE_PREFIX = "InvalidAttribute.Mandatory";
    public static final String ERROR_IRRELEVANT_MSG_CODE_PREFIX = "InvalidAttribute.Irrelevant";
    public static final String ERROR_INVALID_MSG_CODE_PREFIX = "InvalidAttribute.Invalid";
    private static final String MSG_KEY_VALUE_IN_RANGE = "ValueInRange";
    private static final String MSG_KEY_VALUE_IN_RANGE_LOWER = "ValueInRangeLower";
    private static final String MSG_KEY_VALUE_IN_RANGE_UPPER = "ValueInRangeUpper";
    private static final String MSG_KEY_VALUE_IN_RANGE_STEPS = "ValueInRangeSteps";
    private static final String RESOURCE_BUNDLE_NAME = DefaultGenericAttributeValidationConfiguration.class.getName();
    private final Locale locale;
    private final ResourceBundle messages;
    private final IMarker missingMandatoryValueMarker;

    public DefaultGenericAttributeValidationConfiguration(Locale locale) {
        this(locale, null);
    }

    public DefaultGenericAttributeValidationConfiguration(Locale locale, @CheckForNull IMarker requiredInformationMissingMarker) {
        this(ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale), locale, requiredInformationMissingMarker);
    }

    public DefaultGenericAttributeValidationConfiguration(ResourceBundle messages, Locale locale) {
        this(messages, locale, null);
    }

    public DefaultGenericAttributeValidationConfiguration(ResourceBundle messages, Locale locale, @CheckForNull IMarker requiredInformationMissingMarker) {
        this.messages = Objects.requireNonNull(messages, "messages must not be null");
        this.locale = Objects.requireNonNull(locale, "locale must not be null");
        this.missingMandatoryValueMarker = requiredInformationMissingMarker;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ResourceBundle getMessages() {
        return this.messages;
    }

    public IMarker getMissingMandatoryValueMarker() {
        return this.missingMandatoryValueMarker;
    }

    @Override
    public boolean shouldValidate(PolicyAttribute policyAttribute, IModelObject modelObject) {
        return true;
    }

    protected Message createErrorMessage(PolicyAttribute policyAttribute, IModelObject modelObject, GenericRelevanceValidation.Error error, Class<? extends IModelObject> definingModelObjectClass, String message) {
        return this.builderForErrorMessage(policyAttribute, modelObject, error, definingModelObjectClass, message).create();
    }

    protected Message.Builder builderForErrorMessage(PolicyAttribute policyAttribute, IModelObject modelObject, GenericRelevanceValidation.Error error, Class<? extends IModelObject> definingModelObjectClass, String message) {
        String msgCode = this.createMsgCode(error, policyAttribute, definingModelObjectClass);
        return Message.error(message).code(msgCode).invalidObjectWithProperties(modelObject, policyAttribute.getName());
    }

    protected String createMsgCode(GenericRelevanceValidation.Error error, PolicyAttribute policyAttribute, Class<? extends IModelObject> definingModelObjectClass) {
        return error.getDefaultMessageCode(definingModelObjectClass, policyAttribute.getName());
    }

    protected String format(String msgKey, Object ... replacementParameters) {
        return String.format(this.getMessages().getString(msgKey), replacementParameters);
    }

    protected String getLabelFor(PolicyAttribute policyAttribute, IModelObject modelObject) {
        return '\"' + policyAttribute.getLabel(this.locale) + '\"';
    }

    @Override
    public Message createMessageForMissingMandatoryValue(PolicyAttribute policyAttribute, IModelObject modelObject, Class<? extends IModelObject> definingModelObjectClass) {
        Message message = this.createErrorMessage(policyAttribute, modelObject, GenericRelevanceValidation.Error.MandatoryValueMissing, definingModelObjectClass, this.format(ERROR_MANDATORY_MSG_CODE_PREFIX, this.getLabelFor(policyAttribute, modelObject)));
        IMarker marker = this.getMissingMandatoryValueMarker();
        if (marker != null) {
            message = new Message.Builder(message).markers(marker).create();
        }
        return message;
    }

    @Override
    public Message createMessageForValuePresentForIrrelevantAttribute(PolicyAttribute policyAttribute, IModelObject modelObject, Class<? extends IModelObject> definingModelObjectClass) {
        return this.createErrorMessage(policyAttribute, modelObject, GenericRelevanceValidation.Error.IrrelevantValuePresent, definingModelObjectClass, this.format(ERROR_IRRELEVANT_MSG_CODE_PREFIX, this.getLabelFor(policyAttribute, modelObject)));
    }

    @Override
    public Message createMessageForValueNotInAllowedValueSet(PolicyAttribute policyAttribute, IModelObject modelObject, Class<? extends IModelObject> definingModelObjectClass) {
        StringBuilder sb = new StringBuilder(this.format(ERROR_INVALID_MSG_CODE_PREFIX, this.getLabelFor(policyAttribute, modelObject)));
        ValueSet<?> valueSet = policyAttribute.getValueSet(modelObject);
        if (valueSet.isRange()) {
            String stepLabel;
            sb.append(' ');
            Range range = (Range)valueSet;
            Comparable lowerBound = range.getLowerBound();
            Comparable upperBound = range.getUpperBound();
            Comparable step = range.getStep();
            String string = stepLabel = ObjectUtil.isNull((Object)step) ? "" : this.format(MSG_KEY_VALUE_IN_RANGE_STEPS, step);
            if (ObjectUtil.isNull((Object)lowerBound)) {
                sb.append(this.format(MSG_KEY_VALUE_IN_RANGE_UPPER, upperBound, stepLabel));
            } else if (ObjectUtil.isNull((Object)upperBound)) {
                sb.append(this.format(MSG_KEY_VALUE_IN_RANGE_LOWER, lowerBound, stepLabel));
            } else {
                sb.append(this.format(MSG_KEY_VALUE_IN_RANGE, lowerBound, upperBound, stepLabel));
            }
        }
        return this.createErrorMessage(policyAttribute, modelObject, GenericRelevanceValidation.Error.ValueNotInValueSet, definingModelObjectClass, sb.toString());
    }
}

