/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.InputStream;
import java.util.List;
import org.faktorips.runtime.ICacheFactory;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.internal.AbstractXmlInputStreamRepository;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TocEntry;

public abstract class AbstractClassLoadingRuntimeRepository
extends AbstractXmlInputStreamRepository {
    private final ClassLoader cl;

    public AbstractClassLoadingRuntimeRepository(String name, ICacheFactory cacheFactory, ClassLoader cl) {
        super(name, cacheFactory, cl);
        this.cl = cl;
    }

    @Override
    protected <T extends IProductComponent> void getAllProductComponentsInternal(Class<T> productCmptClass, List<T> result) {
        List<ProductCmptTocEntry> entries = this.getTableOfContents().getProductCmptTocEntries();
        for (ProductCmptTocEntry entry : entries) {
            Class<?> clazz = this.getClass(entry.getImplementationClassName(), this.cl);
            if (!productCmptClass.isAssignableFrom(clazz)) continue;
            IProductComponent productComponentInternal = this.getProductComponentInternal(entry.getIpsObjectId());
            result.add(productComponentInternal);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cl;
    }

    @Override
    protected InputStream getXmlAsStream(TocEntry tocEntry) {
        String resource = tocEntry.getXmlResourceName();
        InputStream is = this.getClassLoader().getResourceAsStream(resource);
        if (is == null) {
            throw new RuntimeException("Can't find resource " + resource + " for ToC entry " + tocEntry);
        }
        return is;
    }

    protected abstract String getProductComponentGenerationImplClass(GenerationTocEntry var1);
}

