/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.faktorips.runtime.IRuntimeObject;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.toc.AbstractReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.EnumXmlAdapterTocEntry;
import org.faktorips.runtime.internal.toc.FormulaTestTocEntry;
import org.faktorips.runtime.internal.toc.ModelTypeTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.table.TableStructure;
import org.faktorips.runtime.model.table.TableStructureKind;
import org.w3c.dom.Element;

public class ReadonlyTableOfContents
extends AbstractReadonlyTableOfContents {
    private Map<String, ProductCmptTocEntry> pcIdTocEntryMap;
    private Map<String, ProductCmptTocEntry> pcNameTocEntryMap;
    private Map<String, Map<String, ProductCmptTocEntry>> kindIdTocEntryListMap;
    private Map<String, TableContentTocEntry> tableImplClassTocEntryMap;
    private Map<String, TableContentTocEntry> tableContentNameTocEntryMap;
    private Map<String, TestCaseTocEntry> testCaseNameTocEntryMap;
    private Map<String, ModelTypeTocEntry> modelTypeNameTocEntryMap;
    private Map<String, EnumContentTocEntry> enumContentImplClassTocEntryMap;
    private Map<String, EnumXmlAdapterTocEntry> enumXmlAdapterTocEntryMap;
    private Map<Class<?>, Map<String, CustomTocEntryObject<?>>> otherTocEntryMaps;

    public ReadonlyTableOfContents() {
        super(ReadonlyTableOfContents.class.getClassLoader());
    }

    public ReadonlyTableOfContents(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public void initFromXml(Element tocElement) {
        int size = tocElement.getChildNodes().getLength();
        this.initHashMaps(size);
        super.initFromXml(tocElement);
    }

    protected void initHashMaps(int tocSize) {
        this.pcIdTocEntryMap = new HashMap<String, ProductCmptTocEntry>(tocSize);
        this.pcNameTocEntryMap = new HashMap<String, ProductCmptTocEntry>(tocSize);
        this.kindIdTocEntryListMap = new HashMap<String, Map<String, ProductCmptTocEntry>>(tocSize);
        this.tableImplClassTocEntryMap = new HashMap<String, TableContentTocEntry>(tocSize / 4);
        this.tableContentNameTocEntryMap = new HashMap<String, TableContentTocEntry>(tocSize / 4);
        this.testCaseNameTocEntryMap = new HashMap<String, TestCaseTocEntry>();
        this.modelTypeNameTocEntryMap = new HashMap<String, ModelTypeTocEntry>(tocSize / 4);
        this.enumContentImplClassTocEntryMap = new HashMap<String, EnumContentTocEntry>(tocSize / 4);
        this.enumXmlAdapterTocEntryMap = new HashMap<String, EnumXmlAdapterTocEntry>(tocSize / 4);
        this.otherTocEntryMaps = new HashMap();
    }

    @Override
    protected void internalAddEntry(TocEntryObject entry) {
        if (entry instanceof ProductCmptTocEntry) {
            ProductCmptTocEntry prodEntry = (ProductCmptTocEntry)entry;
            this.pcIdTocEntryMap.put(prodEntry.getIpsObjectId(), prodEntry);
            this.pcNameTocEntryMap.put(prodEntry.getIpsObjectQualifiedName(), prodEntry);
            Map<String, ProductCmptTocEntry> versions = this.getVersions(prodEntry.getKindId());
            versions.put(prodEntry.getVersionId(), prodEntry);
            return;
        }
        if (entry instanceof TableContentTocEntry) {
            TableContentTocEntry previousTocEntry = this.tableImplClassTocEntryMap.put(entry.getImplementationClassName(), (TableContentTocEntry)entry);
            this.removePreviousSingleContent(entry, previousTocEntry);
            this.tableContentNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (TableContentTocEntry)entry);
            return;
        }
        if (entry instanceof TestCaseTocEntry) {
            this.testCaseNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (TestCaseTocEntry)entry);
            return;
        }
        if (entry instanceof FormulaTestTocEntry) {
            this.testCaseNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (FormulaTestTocEntry)entry);
            return;
        }
        if (entry instanceof ModelTypeTocEntry) {
            this.modelTypeNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (ModelTypeTocEntry)entry);
            return;
        }
        if (entry instanceof EnumContentTocEntry) {
            this.addEnumContentTocEntry(entry);
            return;
        }
        if (entry instanceof EnumXmlAdapterTocEntry) {
            this.enumXmlAdapterTocEntryMap.put(entry.getIpsObjectId(), (EnumXmlAdapterTocEntry)entry);
            return;
        }
        if (entry instanceof CustomTocEntryObject) {
            this.putTypedTocEntryToMap((CustomTocEntryObject)entry);
            return;
        }
        throw new IllegalArgumentException("Unknown entry type " + entry);
    }

    private void removePreviousSingleContent(TocEntryObject entry, TableContentTocEntry previousTocEntry) {
        if (previousTocEntry != null) {
            try {
                TableStructure tableStructure = IpsModel.getTableStructure(this.getClassLoader().loadClass(entry.getImplementationClassName()));
                if (tableStructure.getKind().equals((Object)TableStructureKind.SINGLE_CONTENT)) {
                    this.tableContentNameTocEntryMap.remove(previousTocEntry.getIpsObjectQualifiedName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void addEnumContentTocEntry(TocEntryObject entry) {
        EnumContentTocEntry previousEntry = this.enumContentImplClassTocEntryMap.get(entry.getImplementationClassName());
        if (previousEntry == null || IpsStringUtils.isEmpty(previousEntry.getXmlResourceName())) {
            this.enumContentImplClassTocEntryMap.put(entry.getImplementationClassName(), (EnumContentTocEntry)entry);
        }
    }

    private <T> void putTypedTocEntryToMap(CustomTocEntryObject<T> tocEntry) {
        Map otherTocEntryMap = this.otherTocEntryMaps.computeIfAbsent(tocEntry.getRuntimeObjectClass(), $ -> new HashMap());
        otherTocEntryMap.put(tocEntry.getIpsObjectQualifiedName(), tocEntry);
    }

    @Override
    public List<ProductCmptTocEntry> getProductCmptTocEntries() {
        return new ArrayList<ProductCmptTocEntry>(this.pcIdTocEntryMap.values());
    }

    @Override
    public ProductCmptTocEntry getProductCmptTocEntry(String id) {
        return this.pcIdTocEntryMap.get(id);
    }

    @Override
    public ProductCmptTocEntry getProductCmptTocEntry(String kindId, String versionId) {
        if (kindId == null) {
            return null;
        }
        if (versionId == null) {
            throw new RuntimeException("VersionId must not be null!");
        }
        return this.getVersions(kindId).get(versionId);
    }

    @Override
    public List<ProductCmptTocEntry> getProductCmptTocEntries(String kindId) {
        return new ArrayList<ProductCmptTocEntry>(this.getVersions(kindId).values());
    }

    private Map<String, ProductCmptTocEntry> getVersions(String kindId) {
        return this.kindIdTocEntryListMap.computeIfAbsent(kindId, $ -> new TreeMap());
    }

    @Override
    public List<TableContentTocEntry> getTableTocEntries() {
        return new ArrayList<TableContentTocEntry>(this.tableContentNameTocEntryMap.values());
    }

    @Override
    public TableContentTocEntry getTableTocEntryByClassname(String implementationClass) {
        return this.tableImplClassTocEntryMap.get(implementationClass);
    }

    @Override
    public TableContentTocEntry getTableTocEntryByQualifiedTableName(String qualifiedTableName) {
        return this.tableContentNameTocEntryMap.get(qualifiedTableName);
    }

    @Override
    public List<TestCaseTocEntry> getTestCaseTocEntries() {
        return new ArrayList<TestCaseTocEntry>(this.testCaseNameTocEntryMap.values());
    }

    @Override
    public TestCaseTocEntry getTestCaseTocEntryByQName(String qName) {
        return this.testCaseNameTocEntryMap.get(qName);
    }

    @Override
    public Set<ModelTypeTocEntry> getModelTypeTocEntries() {
        return new HashSet<ModelTypeTocEntry>(this.modelTypeNameTocEntryMap.values());
    }

    @Override
    public List<EnumContentTocEntry> getEnumContentTocEntries() {
        return new ArrayList<EnumContentTocEntry>(this.enumContentImplClassTocEntryMap.values());
    }

    @Override
    public EnumContentTocEntry getEnumContentTocEntry(String className) {
        return this.enumContentImplClassTocEntryMap.get(className);
    }

    @Override
    public Set<EnumXmlAdapterTocEntry> getEnumXmlAdapterTocEntries() {
        return new HashSet<EnumXmlAdapterTocEntry>(this.enumXmlAdapterTocEntryMap.values());
    }

    public List<TocEntryObject> getEntries() {
        TreeSet<TocEntryObject> sortedEntries = new TreeSet<TocEntryObject>(Comparator.comparing(TocEntryObject::getPackageName).thenComparing(TocEntryObject::getUnqualifiedName).thenComparing(TocEntry::getXmlElementTag));
        sortedEntries.addAll(this.pcIdTocEntryMap.values());
        sortedEntries.addAll(this.tableContentNameTocEntryMap.values());
        sortedEntries.addAll(this.testCaseNameTocEntryMap.values());
        sortedEntries.addAll(this.modelTypeNameTocEntryMap.values());
        sortedEntries.addAll(this.enumContentImplClassTocEntryMap.values());
        sortedEntries.addAll(this.enumXmlAdapterTocEntryMap.values());
        for (Map<String, CustomTocEntryObject<?>> otherTocEntryMap : this.otherTocEntryMaps.values()) {
            sortedEntries.addAll(otherTocEntryMap.values());
        }
        return new ArrayList<TocEntryObject>(sortedEntries);
    }

    @Override
    public <T> CustomTocEntryObject<T> getCustomTocEntry(Class<T> type, String ipsObjectQualifiedName) {
        Map<String, CustomTocEntryObject<?>> otherTocEntryMap = this.otherTocEntryMaps.get(type);
        if (otherTocEntryMap != null) {
            return this.castCustomEntryObject(ipsObjectQualifiedName, otherTocEntryMap);
        }
        return null;
    }

    private <T> CustomTocEntryObject<T> castCustomEntryObject(String ipsObjectQualifiedName, Map<String, CustomTocEntryObject<?>> otherTocEntryMap) {
        return otherTocEntryMap.get(ipsObjectQualifiedName);
    }

    @Override
    public <T extends IRuntimeObject> List<CustomTocEntryObject<T>> getTypedTocEntries(Class<T> type) {
        Map<String, CustomTocEntryObject<?>> otherTocEntryMap = this.otherTocEntryMaps.get(type);
        ArrayList<CustomTocEntryObject<T>> list = new ArrayList<CustomTocEntryObject<T>>();
        if (otherTocEntryMap != null) {
            Collection<CustomTocEntryObject<?>> values = otherTocEntryMap.values();
            Iterator<CustomTocEntryObject<?>> iterator = values.iterator();
            while (iterator.hasNext()) {
                CustomTocEntryObject<?> typedTocEntryObject;
                CustomTocEntryObject<?> tocEntryObject = typedTocEntryObject = iterator.next();
                list.add(tocEntryObject);
            }
        }
        return list;
    }
}

