/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.test;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.faktorips.runtime.ClassloaderRuntimeRepository;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.test.AbstractIpsTestRunner;
import org.faktorips.runtime.test.IpsTest2;
import org.faktorips.runtime.test.IpsTestCaseBase;
import org.faktorips.runtime.test.IpsTestFailure;
import org.faktorips.runtime.test.IpsTestSuite;

public class SocketIpsTestRunner
extends AbstractIpsTestRunner {
    public static final String ALL_TESTS_STARTED = "Starting tests ";
    public static final String ALL_TESTS_FINISHED = "Ending tests ";
    public static final String TEST_STARTED = "Starting test ";
    public static final String TEST_FINISHED = "Ending test ";
    public static final String TEST_FAILED = "Test failed ";
    public static final String TEST_FAILED_DELIMITERS = "|";
    public static final String TEST_ERROR = "Test error ";
    public static final String TEST_ERROR_END = "ERROR_END";
    public static final String TEST_ERROR_MESSAGE_INDICATOR = ">>>";
    public static final String TEST_ERROR_STACK_INDICATOR = "---";
    private int port;
    private Socket socket;
    private PrintWriter writer;

    public SocketIpsTestRunner() {
    }

    public SocketIpsTestRunner(int port, String repositoryPackages, String additionalRepositoryPackages) {
        this();
        this.port = port;
        this.setRepositoryPackages(repositoryPackages);
        this.setAdditionalRepositoryPackages(additionalRepositoryPackages);
    }

    public static void main(String[] args) throws Exception {
        String suiteName = "";
        String additionalRepositoryPackages = "";
        if (args.length >= 3) {
            suiteName = args[2];
        }
        if (args.length >= 4) {
            additionalRepositoryPackages = args[3];
        }
        new SocketIpsTestRunner(Integer.parseInt(args[0]), args[1], additionalRepositoryPackages).run(suiteName);
    }

    @Override
    public void run(String name) {
        long testStartTime = System.currentTimeMillis();
        try {
            Exception exceptionDuringTestCount = null;
            this.openClientSocket();
            if (this.writer == null) {
                return;
            }
            int testCount = 0;
            try {
                testCount = super.countTests(name);
            }
            catch (Exception e) {
                exceptionDuringTestCount = e;
            }
            this.writer.print(ALL_TESTS_STARTED);
            this.writer.print("(");
            this.writer.print(testCount);
            this.writer.print(") [");
            this.writer.print(this.getRepositoryPackages());
            this.writer.print("].[");
            this.writer.print(name);
            this.writer.print("]");
            this.printAllTests(testCount);
            this.writer.println();
            if (exceptionDuringTestCount != null) {
                throw exceptionDuringTestCount;
            }
            testStartTime = System.currentTimeMillis();
            super.run(name);
        }
        catch (Throwable e) {
            this.postError(e, null);
        }
        if (this.writer != null) {
            this.writer.println(ALL_TESTS_FINISHED + (System.currentTimeMillis() - testStartTime));
            this.closeClientSocket();
        }
    }

    private void printAllTests(int testCount) {
        List<IpsTest2> tests = this.getTests();
        ArrayList<IpsTest2> testCases = new ArrayList<IpsTest2>(testCount);
        this.writer.print(":");
        for (IpsTest2 currTest : tests) {
            this.addTestCasesAsFlatList(currTest, testCases);
        }
        for (IpsTest2 testCase2 : testCases) {
            this.printTestCase2(testCase2);
            this.writer.print(",");
        }
    }

    private void addTestCasesAsFlatList(IpsTest2 currTest, List<IpsTest2> testCases) {
        if (currTest instanceof IpsTestCaseBase) {
            testCases.add(currTest);
        } else if (currTest instanceof IpsTestSuite) {
            List<IpsTest2> testsInSuite = ((IpsTestSuite)currTest).getTests();
            for (IpsTest2 testInSuite : testsInSuite) {
                this.addTestCasesAsFlatList(testInSuite, testCases);
            }
        } else {
            throw new RuntimeException("Wrong instance of ips test: " + currTest.getClass().getName());
        }
    }

    @Override
    protected List<IRuntimeRepository> createRepositories() throws Exception {
        List<String> repositoryNameList = this.getRepositoryListFromInputString(this.getRepositoryPackages());
        ArrayList<IRuntimeRepository> runtimeRepositories = new ArrayList<IRuntimeRepository>(repositoryNameList.size());
        for (String repositoryName : repositoryNameList) {
            runtimeRepositories.add(ClassloaderRuntimeRepository.create(repositoryName, this.getClassLoader()));
        }
        return runtimeRepositories;
    }

    private void openClientSocket() throws Exception {
        IOException lastException = null;
        for (int i = 0; i < 2; ++i) {
            try {
                lastException = null;
                this.socket = new Socket("localhost", this.port);
                this.writer = new PrintWriter(this.socket.getOutputStream(), true);
                return;
            }
            catch (IOException e) {
                lastException = e;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (lastException != null) {
            throw new Exception(lastException);
        }
    }

    private void closeClientSocket() {
        this.writer.close();
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void testStarted(IpsTest2 test) {
        this.writer.print(TEST_STARTED);
        this.printTestCase2(test);
        this.writer.println();
    }

    private void printTestCase2(IpsTest2 test) {
        this.writer.print(test.getQualifiedName());
        this.writer.print("{");
        this.writer.print(test.getFullPath());
        this.writer.print("}");
    }

    @Override
    public void testFinished(IpsTest2 test) {
        this.writer.print(TEST_FINISHED);
        this.writer.println(test.getQualifiedName());
    }

    @Override
    public void testFailureOccured(IpsTestFailure failure) {
        if (failure.isError()) {
            this.postError(failure.getThrowable(), failure.getTestCase().getQualifiedName());
        } else {
            this.writer.print(TEST_FAILED);
            this.writer.println(this.testFailureToStr(failure));
        }
    }

    private String testFailureToStr(IpsTestFailure failure) {
        StringBuilder formattedFailure = new StringBuilder();
        formattedFailure.append(failure.getTestCase().getQualifiedName());
        formattedFailure.append(TEST_FAILED_DELIMITERS);
        formattedFailure.append(failure.getTestObject() == null ? "<null>" : failure.getTestObject());
        formattedFailure.append(TEST_FAILED_DELIMITERS);
        formattedFailure.append(failure.getTestedAttribute() == null ? "<null>" : failure.getTestedAttribute());
        formattedFailure.append(TEST_FAILED_DELIMITERS);
        formattedFailure.append(failure.getExpectedValue() == null ? "<null>" : failure.getExpectedValue());
        formattedFailure.append(TEST_FAILED_DELIMITERS);
        formattedFailure.append(failure.getActualValue() == null ? "<null>" : failure.getActualValue());
        formattedFailure.append(TEST_FAILED_DELIMITERS);
        formattedFailure.append(failure.getMessage() == null ? "<null>" : failure.getMessage());
        formattedFailure.append(TEST_FAILED_DELIMITERS);
        if (this.actualValueStringRepresentationDiffers(failure)) {
            formattedFailure.append(failure.getActualValueAsString());
            formattedFailure.append(TEST_FAILED_DELIMITERS);
        }
        return formattedFailure.toString();
    }

    private boolean actualValueStringRepresentationDiffers(IpsTestFailure failure) {
        return failure.getActualValue() != null && !failure.getActualValue().toString().equals(failure.getActualValueAsString());
    }

    private void postError(Throwable t, String qualifiedTestName) {
        if (this.writer == null) {
            return;
        }
        this.writer.print(TEST_ERROR);
        this.writer.print(qualifiedTestName == null ? "" : qualifiedTestName);
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            String errorMsg = cause.getLocalizedMessage();
            if (IpsStringUtils.isBlank(errorMsg)) {
                errorMsg = cause.getMessage();
            }
            if (IpsStringUtils.isBlank(errorMsg)) {
                errorMsg = cause.getClass().getName();
            }
            errorMsg = this.wrapNull(cause, errorMsg);
            this.writer.print((errorMsg = this.wrapClassNotFoundException(cause, errorMsg)) == null || errorMsg.length() <= 0 ? "" : "{");
            this.writer.print(TEST_ERROR_MESSAGE_INDICATOR);
            this.writer.print(errorMsg);
            this.writer.print("}");
            this.printStack(cause);
        }
        this.writer.println();
        this.writer.println(TEST_ERROR_END);
    }

    private String wrapClassNotFoundException(Throwable cause, String errorMsg) {
        if (cause instanceof ClassNotFoundException) {
            return "ClassNotFoundException " + errorMsg;
        }
        return errorMsg;
    }

    private String wrapNull(Throwable cause, String errorMsg) {
        if ("null".equals(errorMsg)) {
            return cause.getClass().getName() + " " + errorMsg;
        }
        return errorMsg;
    }

    private void printStack(Throwable cause) {
        StackTraceElement[] stackElems;
        for (StackTraceElement stackElem : stackElems = cause.getStackTrace()) {
            this.writer.print("{");
            this.writer.print(TEST_ERROR_STACK_INDICATOR);
            this.writer.print(stackElem.toString());
            this.writer.print("}");
        }
    }
}

