/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.internal.AbstractCachingRuntimeRepository;
import org.faktorips.runtime.internal.DescriptionXmlHelper;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.enumtype.EnumType;
import org.faktorips.runtime.xml.IToXmlSupport;
import org.faktorips.values.InternationalString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IpsEnumToXmlWriter {
    public static final String XML_ELEMENT_ENUMATTRIBUTEVALUE = "EnumAttributeValue";
    private static final String XML_ELEMENT_ENUMVALUE = "EnumValue";
    private static final String XML_ELEMENT_ENUMCONTENT = "EnumContent";
    private static final String XML_ELEMENT_ENUMATTRIBUTEREFERENCE = "EnumAttributeReference";
    private static final String XML_ATTRIBUTE_ENUM_TYPE = "enumType";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private final IRuntimeRepository repository;
    private final Class<?> enumClass;
    private List<?> enumValues;

    public IpsEnumToXmlWriter(IRuntimeRepository repository, Class<?> enumClass) {
        this(repository, enumClass, repository.getEnumValues(enumClass));
    }

    public IpsEnumToXmlWriter(IRuntimeRepository repository, Class<?> enumClass, List<?> enumValues) {
        this.repository = Objects.requireNonNull(repository);
        this.enumClass = Objects.requireNonNull(enumClass);
        this.enumValues = Objects.requireNonNull(enumValues);
    }

    public Element toXml(Document document) {
        IToXmlSupport.check(this.enumClass);
        Element enumContentElement = document.createElement(XML_ELEMENT_ENUMCONTENT);
        this.writeDescriptionToXml(enumContentElement, false);
        this.writeValuesToXml(enumContentElement);
        this.writeHeaderToXml(enumContentElement);
        return enumContentElement;
    }

    private void writeValuesToXml(Element element) {
        for (Object enumValue : this.enumValues) {
            if (this.isModelValue(enumValue)) continue;
            Element enumValueElement = element.getOwnerDocument().createElement(XML_ELEMENT_ENUMVALUE);
            this.writeDescriptionToXml(enumValueElement, true);
            ((IToXmlSupport)enumValue).writePropertiesToXml(enumValueElement);
            element.appendChild(enumValueElement);
        }
    }

    private boolean isModelValue(Object enumValue) {
        try {
            Field valuesField;
            try {
                valuesField = enumValue.getClass().getField("VALUES");
            }
            catch (NoSuchFieldException e) {
                return false;
            }
            List values = (List)valuesField.get(enumValue);
            return values.contains(enumValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException("Can't determine whether " + enumValue + " is an extension value of " + enumValue.getClass(), e);
        }
    }

    private void writeHeaderToXml(Element element) {
        EnumType enumType = IpsModel.getEnumType(this.enumClass);
        element.setAttribute(XML_ATTRIBUTE_ENUM_TYPE, enumType.getEnumContentQualifiedName());
        for (String name : enumType.getAttributenames()) {
            Element refElement = element.getOwnerDocument().createElement(XML_ELEMENT_ENUMATTRIBUTEREFERENCE);
            refElement.setAttribute(XML_ATTRIBUTE_NAME, name);
            element.appendChild(refElement);
        }
    }

    private void writeDescriptionToXml(Element element, boolean skipTextContent) {
        if (this.repository instanceof AbstractCachingRuntimeRepository) {
            AbstractCachingRuntimeRepository runtimeRepository = (AbstractCachingRuntimeRepository)this.repository;
            InternationalString enumDescription = runtimeRepository.getEnumDescription(this.enumClass);
            DescriptionXmlHelper.write(enumDescription, element, skipTextContent);
        }
    }
}

