/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.InternationalString;
import org.faktorips.values.LocalizedString;
import org.w3c.dom.Element;

public class DescriptionXmlHelper {
    public static final String XML_ELEMENT_DESCRIPTION = "Description";
    public static final String XML_ATTRIBUTE_LOCALE = "locale";

    private DescriptionXmlHelper() {
    }

    public static void write(@CheckForNull InternationalString description, Element parentElement) {
        DescriptionXmlHelper.write(description, parentElement, false);
    }

    public static void write(@CheckForNull InternationalString description, Element parentElement, boolean skipTextContent) {
        if (description != null) {
            for (LocalizedString localizedString : ((DefaultInternationalString)description).getLocalizedStrings()) {
                Element descriptionElement = parentElement.getOwnerDocument().createElement(XML_ELEMENT_DESCRIPTION);
                descriptionElement.setAttribute(XML_ATTRIBUTE_LOCALE, localizedString.getLocale().toString());
                if (!skipTextContent) {
                    descriptionElement.setTextContent(localizedString.getValue());
                }
                parentElement.appendChild(descriptionElement);
            }
        }
    }

    public static InternationalString read(Element parentElement) {
        List<Element> descriptionElements = XmlUtil.getElements(parentElement, XML_ELEMENT_DESCRIPTION);
        ArrayList<LocalizedString> descriptions = new ArrayList<LocalizedString>(descriptionElements.size());
        for (Element descriptionElement : descriptionElements) {
            String localeCode = descriptionElement.getAttribute(XML_ATTRIBUTE_LOCALE);
            Locale locale = "".equals(localeCode) ? null : new Locale(localeCode);
            String text = descriptionElement.getTextContent();
            descriptions.add(new LocalizedString(locale, text));
        }
        return new DefaultInternationalString(descriptions, descriptions.isEmpty() ? null : ((LocalizedString)descriptions.get(0)).getLocale());
    }
}

