/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type.read;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.faktorips.runtime.model.type.Attribute;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.read.PartDescriptor;

public abstract class AbstractAttributeDescriptor<T extends Attribute>
extends PartDescriptor<T> {
    private AnnotatedElement annotatedElement;
    private Method setterMethod;

    public boolean isValid() {
        return this.getAnnotatedElement() instanceof Field || this.getAnnotatedElement() instanceof Method;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        this.annotatedElement = annotatedElement;
    }

    public Method getSetterMethod() {
        return this.setterMethod;
    }

    public void setSetterMethod(Method setterMethod) {
        this.setterMethod = setterMethod;
    }

    @Override
    public T create(ModelElement parentElement) {
        Type type = (Type)parentElement;
        if (this.isValid()) {
            return this.createValid(type);
        }
        Type superType = type.findSuperType().orElseThrow(() -> new IllegalArgumentException(type.getDeclarationClass() + " lists \"" + this.getName() + "\" as one of it's @IpsAttributes but no matching @IpsAttribute could be found."));
        Attribute attribute = Optional.ofNullable(superType.getAttribute(this.getName())).orElseThrow(() -> new IllegalArgumentException(type.getDeclarationClass() + " lists \"" + this.getName() + "\" as one of it's @IpsAttributes but no matching @IpsAttribute could be found."));
        return this.castOverwritingAttribute(type, attribute);
    }

    private T castOverwritingAttribute(Type type, Attribute attribute) {
        return (T)attribute.createOverwritingAttributeFor(type);
    }

    protected abstract T createValid(Type var1);
}

