/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsTableUsage;
import org.faktorips.runtime.model.table.TableStructure;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypePart;

public class TableUsage
extends TypePart {
    private final Method getter;

    public TableUsage(Type parent, Method getter) {
        super(getter.getAnnotation(IpsTableUsage.class).name(), parent, getter.getAnnotation(IpsExtensionProperties.class), Deprecation.of(getter));
        this.getter = getter;
    }

    public ITable<?> getTable(IProductComponent productComponent, Calendar effectiveDate) {
        try {
            return (ITable)this.getter.invoke(TableUsage.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime()), new Object[0]);
        }
        catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
            throw this.getterError(productComponent, e);
        }
    }

    public String getTableName(IProductComponent productComponent, Calendar effectiveDate) {
        String tableName = null;
        try {
            Method getterForName = this.getter.getDeclaringClass().getDeclaredMethod(this.getter.getName() + "Name", new Class[0]);
            tableName = (String)getterForName.invoke(TableUsage.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime()), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Could not get table name for table usage %s on product component %s.", this.getName(), productComponent), e);
        }
        return tableName;
    }

    private boolean isChangingOverTime() {
        return IProductComponentGeneration.class.isAssignableFrom(this.getter.getDeclaringClass());
    }

    public TableStructure getTableStructure() {
        Class<ITable> tableClass = this.getter.getReturnType().asSubclass(ITable.class);
        if (tableClass.equals(ITable.class)) {
            throw new UnsupportedOperationException("Cannot create new TableStructure as the table usage " + this.getName() + " uses multiple table structures.");
        }
        return IpsModel.getTableStructure(tableClass);
    }

    private IllegalArgumentException getterError(IProductComponent source, Exception e) {
        return new IllegalArgumentException(String.format("Could not get table %s on product component %s.", this.getName(), source), e);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(": ");
        sb.append(this.getter.getReturnType());
        return sb.toString();
    }
}

