/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.faktorips.runtime.AssociationChangedEvent;

public class IpsPropertyChangeSupport
extends PropertyChangeSupport {
    private static final long serialVersionUID = -236185652576376253L;
    private final Object sourceBean;
    private final List<PropertyChangeListener> childChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();

    public IpsPropertyChangeSupport(Object sourceBean) {
        super(sourceBean);
        this.sourceBean = sourceBean;
    }

    public void fireAssociationChange(AssociationChangedEvent evt) {
        Object addedAssociationTarget = evt.getAddedAssociationTarget();
        Object removedAssociationTarget = evt.getRemovedAssociationTarget();
        if (addedAssociationTarget == null && removedAssociationTarget == null) {
            return;
        }
        this.firePropertyChange(evt);
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.sourceBean) {
            super.firePropertyChange(evt);
        } else {
            this.fireChildPropertyChange(evt);
        }
    }

    public void fireAssociationAdded(String associationName, Object addedAssociationTarget) {
        if (addedAssociationTarget == null) {
            return;
        }
        this.fireAssociationChange(new AssociationChangedEvent(this.sourceBean, associationName, null, addedAssociationTarget));
    }

    public void fireAssociationRemoved(String associationName, Object removedAssociationTarget) {
        if (removedAssociationTarget == null) {
            return;
        }
        this.fireAssociationChange(new AssociationChangedEvent(this.sourceBean, associationName, removedAssociationTarget, null));
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener, boolean propagateEventsFromChildren) {
        super.addPropertyChangeListener(listener);
        if (propagateEventsFromChildren) {
            this.childChangeListeners.add(listener);
        }
    }

    public void fireChildPropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener target : this.childChangeListeners) {
            target.propertyChange(evt);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.childChangeListeners.contains(listener)) {
            this.childChangeListeners.remove(listener);
        }
    }
}

