/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.caching;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Function;
import org.faktorips.runtime.caching.IComputable;
import org.faktorips.runtime.caching.Memoizer;

public class HardMemoizer<A, V>
implements IComputable<A, V> {
    private final ConcurrentMap<A, Future<V>> cache = new ConcurrentHashMap<A, Future<V>>();
    private final IComputable<A, V> computable;

    private HardMemoizer(IComputable<A, V> computable) {
        this.computable = computable;
    }

    public static <K, V> HardMemoizer<K, V> of(IComputable<K, V> computable) {
        return new HardMemoizer<K, V>(computable);
    }

    public static <K, V> HardMemoizer<K, V> of(Class<? super V> valueClass, Function<K, V> function) {
        return new HardMemoizer<K, V>(IComputable.of(valueClass, function));
    }

    @Override
    public Class<? super V> getValueClass() {
        return this.computable.getValueClass();
    }

    /*
     * Loose catch block
     */
    @Override
    public V compute(A arg) throws InterruptedException {
        while (true) {
            Callable<Object> eval;
            FutureTask<Object> ft;
            FutureTask<Object> f;
            if ((f = (FutureTask<Object>)this.cache.get(arg)) == null && (f = (Future)this.cache.putIfAbsent(arg, ft = new FutureTask<Object>(eval = () -> this.computable.compute(arg)))) == null) {
                f = ft;
                ft.run();
            }
            try {
                return f.get();
            }
            catch (CancellationException e) {
                this.cache.remove(arg, f);
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw Memoizer.launderThrowable(e.getCause());
        }
    }
}

