/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.internal.FormulaUtil;
import org.faktorips.runtime.internal.ProductComponent;
import org.faktorips.runtime.internal.ProductComponentGeneration;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsFormula;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypePart;

public class Formula
extends TypePart {
    private final IpsFormula annotation;
    private final Method getter;
    private final boolean changingOverTime;

    public Formula(Type type, Method getter, boolean changingOverTime) {
        super(getter.getAnnotation(IpsFormula.class).name(), type, getter.getAnnotation(IpsExtensionProperties.class), Deprecation.of(getter));
        this.annotation = getter.getAnnotation(IpsFormula.class);
        this.getter = getter;
        this.changingOverTime = changingOverTime;
    }

    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    public String getFormulaText(IProductComponent productComponent, @CheckForNull Calendar effectiveDate) {
        Object relevantProductObject = Formula.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime());
        if (relevantProductObject instanceof ProductComponent) {
            return FormulaUtilAccess.getFormulaText((ProductComponent)relevantProductObject, this.getFormulaName());
        }
        return FormulaUtilAccess.getFormulaText((ProductComponentGeneration)relevantProductObject, this.getFormulaName());
    }

    public void setFormulaText(IProductComponent productComponent, @CheckForNull Calendar effectiveDate, String formulaText) {
        Object relevantProductObject = Formula.getRelevantProductObject(productComponent, effectiveDate, this.isChangingOverTime());
        if (relevantProductObject instanceof ProductComponent) {
            FormulaUtilAccess.setFormulaText((ProductComponent)relevantProductObject, this.getFormulaName(), formulaText);
        } else {
            FormulaUtilAccess.setFormulaText((ProductComponentGeneration)relevantProductObject, this.getFormulaName(), formulaText);
        }
    }

    public String getFormulaName() {
        return this.annotation.name();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getFormulaName());
        sb.append("(");
        sb.append(Stream.of(this.getter.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")));
        sb.append(")");
        sb.append(": ");
        sb.append(this.getter.getReturnType());
        return sb.toString();
    }

    private static class FormulaUtilAccess
    extends FormulaUtil {
        private FormulaUtilAccess() {
        }

        private static String getFormulaText(ProductComponent product, String formulaSignature) {
            return FormulaUtil.getFormula(product, formulaSignature);
        }

        private static void setFormulaText(ProductComponent product, String formulaSignature, String formulaText) {
            FormulaUtil.setFormula(product, formulaSignature, formulaText);
        }

        private static String getFormulaText(ProductComponentGeneration productGeneration, String formulaSignature) {
            return FormulaUtil.getFormula(productGeneration, formulaSignature);
        }

        private static void setFormulaText(ProductComponentGeneration productGeneration, String formulaSignature, String formulaText) {
            FormulaUtil.setFormula(productGeneration, formulaSignature, formulaText);
        }
    }
}

