/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.faktorips.runtime.util.StringBuilderJoiner;

public final class IpsStringUtils {
    public static final String EMPTY = "";

    private IpsStringUtils() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNotEmpty(String s) {
        return !IpsStringUtils.isEmpty(s);
    }

    public static boolean isBlank(String s) {
        return s == null || s.isBlank();
    }

    public static boolean isNotBlank(String s) {
        return !IpsStringUtils.isBlank(s);
    }

    public static boolean trimEquals(String s1, String s2) {
        return Objects.equals(s1 != null ? s1.trim() : s1, s2 != null ? s2.trim() : s2);
    }

    public static boolean equalsNullAsEmpty(String s1, String s2) {
        return Objects.equals(s1 == null ? EMPTY : s1, s2 == null ? EMPTY : s2);
    }

    public static String join(Collection<?> collection, String separator) {
        return IpsStringUtils.join(collection, separator);
    }

    public static String join(Iterable<?> iterable, String separator) {
        StringBuilder stringBuilder = new StringBuilder(256);
        StringBuilderJoiner.join(stringBuilder, iterable, separator, t -> stringBuilder.append(Objects.toString(t)));
        return stringBuilder.toString();
    }

    public static String join(Iterable<?> iterable) {
        return IpsStringUtils.join(iterable, ", ");
    }

    public static String join(Object[] objectArray) {
        return IpsStringUtils.join(Arrays.asList(objectArray));
    }

    public static String join(Object[] objectArray, String separator) {
        return IpsStringUtils.join(Arrays.asList(objectArray), separator);
    }

    public static <T> String join(Iterable<T> iterable, Function<? super T, String> toString) {
        StringBuilder stringBuilder = new StringBuilder(256);
        StringBuilderJoiner.join(stringBuilder, iterable, (? super T t) -> stringBuilder.append((String)toString.apply(t)));
        return stringBuilder.toString();
    }

    public static <T> String join(Iterable<T> iterable, Function<? super T, String> toString, String separator) {
        StringBuilder stringBuilder = new StringBuilder(256);
        StringBuilderJoiner.join(stringBuilder, iterable, separator, t -> stringBuilder.append((String)toString.apply(t)));
        return stringBuilder.toString();
    }

    public static String toLowerFirstChar(String string) {
        return IpsStringUtils.changeFirstChar(string, Character::isLowerCase, Character::toLowerCase);
    }

    public static String toUpperFirstChar(String string) {
        return IpsStringUtils.changeFirstChar(string, Character::isUpperCase, Character::toUpperCase);
    }

    private static String changeFirstChar(String string, Predicate<Character> isAlreadyChanged, UnaryOperator<Character> change) {
        if (IpsStringUtils.isEmpty(string)) {
            return string;
        }
        char firstChar = string.charAt(0);
        if (isAlreadyChanged.test(Character.valueOf(firstChar))) {
            return string;
        }
        return change.apply(Character.valueOf(firstChar)) + string.substring(1);
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        if (IpsStringUtils.isEmpty(text) || IpsStringUtils.isEmpty(searchList) || IpsStringUtils.isEmpty(replacementList)) {
            return text;
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i] || IpsStringUtils.isEmpty(searchList[i]) || replacementList[i] == null) continue;
            tempIndex = text.indexOf(searchList[i]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int greater;
            if (searchList[i] == null || replacementList[i] == null || (greater = replacementList[i].length() - searchList[i].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
                tempIndex = text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        return buf.toString();
    }

    private static boolean isEmpty(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        return stringArray.length == 0;
    }
}

