/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IDeltaComputationOptions;
import org.faktorips.runtime.IDeltaSupport;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IModelObjectDelta;
import org.faktorips.runtime.IModelObjectDeltaVisitor;
import org.faktorips.runtime.ITimedConfigurableModelObject;
import org.faktorips.runtime.internal.delta.ChildDeltaCreator;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.AssociationKind;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.util.StringBuilderJoiner;

public class ModelObjectDelta
implements IModelObjectDelta {
    private static final int STRUCTURAL_CHANGES = 30;
    private final IModelObject original;
    private final IModelObject referenceObject;
    private final Class<?> modelClass;
    private int kind;
    private int kindOfChange;
    private String association;
    private AssociationKind associationKind;
    private Set<String> changedProperties = null;
    private final List<IModelObjectDelta> children = new ArrayList<IModelObjectDelta>(0);

    private ModelObjectDelta(IModelObject original, IModelObject referenceModelObject, int kind, String association, AssociationKind associationKind) {
        this(original, referenceModelObject, kind, 0, association, associationKind);
    }

    private ModelObjectDelta(IModelObject original, IModelObject referenceModelObject, int deltaKind, int kindOfChange) {
        this(original, referenceModelObject, deltaKind, kindOfChange, null, null);
    }

    private ModelObjectDelta(IModelObject original, IModelObject referenceModelObject, int deltaKind, int kindOfChange, String association, AssociationKind associationKind) {
        this.original = original;
        this.referenceObject = referenceModelObject;
        this.modelClass = original != null ? original.getClass() : referenceModelObject.getClass();
        this.kind = deltaKind;
        this.kindOfChange = kindOfChange;
        this.association = association;
        this.associationKind = associationKind;
    }

    public static final ModelObjectDelta newDelta(IModelObject object, IModelObject refObject, IDeltaComputationOptions options) {
        IConfigurableModelObject confRefObject;
        IConfigurableModelObject confObject;
        if (object != null && refObject != null && !object.getClass().equals(refObject.getClass())) {
            return new ModelObjectDelta(object, refObject, 1, 8, null, null);
        }
        ModelObjectDelta delta = ModelObjectDelta.newEmptyDelta(object, refObject);
        if (object instanceof IConfigurableModelObject && refObject != null) {
            confObject = (IConfigurableModelObject)object;
            confRefObject = (IConfigurableModelObject)refObject;
            delta.checkPropertyChange("productComponent", confObject.getProductComponent(), confRefObject.getProductComponent(), options);
        }
        if (object instanceof ITimedConfigurableModelObject && refObject != null) {
            confObject = (ITimedConfigurableModelObject)object;
            confRefObject = (ITimedConfigurableModelObject)refObject;
            delta.checkPropertyChange("productCmptGeneration", confObject.getProductCmptGeneration(), confRefObject.getProductCmptGeneration(), options);
        }
        return delta;
    }

    public static final ModelObjectDelta newEmptyDelta(IModelObject object, IModelObject refObject) {
        return new ModelObjectDelta(object, refObject, 0, 0);
    }

    public static final void createChildDeltas(ModelObjectDelta delta, IModelObject original, IModelObject refObject, String association, IDeltaComputationOptions options) {
        new ChildDeltaCreator(association, AssociationKind.Composition, options).createChildDeltas(delta, original, refObject);
    }

    public static final void createAssociatedChildDeltas(ModelObjectDelta delta, IModelObject original, IModelObject refObject, String association, IDeltaComputationOptions options) {
        new ChildDeltaCreator(association, AssociationKind.Association, options).createChildDeltas(delta, original, refObject);
    }

    public static final void createChildDeltas(ModelObjectDelta delta, List<? extends IModelObject> originals, List<? extends IModelObject> refObjects, String association, IDeltaComputationOptions options) {
        new ChildDeltaCreator(association, AssociationKind.Composition, options).createChildDeltas(delta, originals, refObjects);
    }

    public static final void createAssociatedChildDeltas(ModelObjectDelta delta, List<? extends IModelObject> originals, List<? extends IModelObject> refObjects, String association, IDeltaComputationOptions options) {
        new ChildDeltaCreator(association, AssociationKind.Association, options).createChildDeltas(delta, originals, refObjects);
    }

    @Deprecated
    public static final ModelObjectDelta newAddDelta(IModelObject addedObject, String association, IDeltaComputationOptions options) {
        return ModelObjectDelta.newAddDelta(addedObject, association, AssociationKind.Composition, options);
    }

    public static final ModelObjectDelta newAddDelta(IModelObject addedObject, String association, AssociationKind associationKind, IDeltaComputationOptions options) {
        ModelObjectDelta addDelta = new ModelObjectDelta(null, addedObject, 16, association, associationKind);
        ModelObjectDelta.createSubtreeDeltaIfNeeded(addedObject, addDelta, options);
        return addDelta;
    }

    @Deprecated
    public static final ModelObjectDelta newRemoveDelta(IModelObject removedObject, String association, IDeltaComputationOptions options) {
        return ModelObjectDelta.newRemoveDelta(removedObject, association, AssociationKind.Composition, options);
    }

    public static final ModelObjectDelta newRemoveDelta(IModelObject removedObject, String association, AssociationKind associationKind, IDeltaComputationOptions options) {
        ModelObjectDelta delta = new ModelObjectDelta(removedObject, null, 8, association, associationKind);
        ModelObjectDelta.createSubtreeDeltaIfNeeded(removedObject, delta, options);
        return delta;
    }

    private static void createSubtreeDeltaIfNeeded(IModelObject existingObject, ModelObjectDelta delta, IDeltaComputationOptions options) {
        if (options != null && options.isCreateSubtreeDelta()) {
            ModelObjectDelta.createSubtreeDelta(existingObject, delta, options);
        }
    }

    private static void createSubtreeDelta(IModelObject existingObject, ModelObjectDelta delta, IDeltaComputationOptions options) {
        Class<?> addedObjectClass = existingObject.getClass();
        try {
            IModelObjectDelta childDelta;
            Constructor<?> constructor = addedObjectClass.getConstructor(new Class[0]);
            IModelObject newInstance = (IModelObject)constructor.newInstance(new Object[0]);
            if (delta.isAdded()) {
                childDelta = ((IDeltaSupport)((Object)newInstance)).computeDelta(existingObject, options);
            } else if (delta.isRemoved()) {
                childDelta = ((IDeltaSupport)((Object)existingObject)).computeDelta(newInstance, options);
            } else {
                throw new IllegalArgumentException("Illegal delta type " + delta);
            }
            for (IModelObjectDelta childAddedDelta : childDelta.getChildDeltas()) {
                delta.addChildDelta(childAddedDelta);
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Error in delta computation. Cannot find default construcor for " + addedObjectClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error in delta computation. Cannot create instance of " + addedObjectClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error in delta computation. Cannot access constructor of " + addedObjectClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error in delta computation. Exception while calling constructor of" + addedObjectClass.getName(), e);
        }
    }

    @Deprecated
    public static final ModelObjectDelta newDifferentObjectAtPositionChangedDelta(IModelObject original, IModelObject refObject, String association) {
        return ModelObjectDelta.newDifferentObjectAtPositionChangedDelta(original, refObject, association, AssociationKind.Composition);
    }

    public static final ModelObjectDelta newDifferentObjectAtPositionChangedDelta(IModelObject original, IModelObject refObject, String association, AssociationKind associationKind) {
        return new ModelObjectDelta(original, refObject, 2, association, associationKind);
    }

    public static final ModelObjectDelta newChangeDelta(IModelObject original, IModelObject refObject, int kindOfChange) {
        return new ModelObjectDelta(original, refObject, 1, kindOfChange);
    }

    public void addChildDelta(IModelObjectDelta childDelta) {
        if (childDelta == null || childDelta.isEmpty()) {
            return;
        }
        if ((childDelta.getKind() & 0x1E) > 0) {
            this.kindOfChange |= 1;
        }
        if (childDelta.isChanged()) {
            this.kindOfChange |= 4;
        }
        this.kind |= 1;
        this.children.add(childDelta);
    }

    @Override
    public IModelObject getOriginalObject() {
        return this.original;
    }

    @Override
    public IModelObject getReferenceObject() {
        return this.referenceObject;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public int getKindOfChange() {
        return this.kindOfChange;
    }

    @Override
    public String getAssociation() {
        return this.association;
    }

    public void setAssociation(String association) {
        this.association = association;
    }

    @Override
    public AssociationKind getAssociationKind() {
        return this.associationKind;
    }

    public void setAssociationKind(AssociationKind associationKind) {
        this.associationKind = associationKind;
    }

    public void checkPropertyChange(String property, Object value1, Object value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (!options.areValuesEqual(this.modelClass, property, value1, value2)) {
            this.markPropertyChanged(property);
        }
    }

    public void checkPropertyChange(String property, int value1, int value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (value1 != value2) {
            this.markPropertyChanged(property);
        }
    }

    public void checkPropertyChange(String property, boolean value1, boolean value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (value1 != value2) {
            this.markPropertyChanged(property);
        }
    }

    public void checkPropertyChange(String property, double value1, double value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (value1 != value2) {
            this.markPropertyChanged(property);
        }
    }

    public void checkPropertyChange(String property, float value1, float value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (value1 != value2) {
            this.markPropertyChanged(property);
        }
    }

    public void checkPropertyChange(String property, char value1, char value2, IDeltaComputationOptions options) {
        if (options.ignore(this.modelClass, property)) {
            return;
        }
        if (value1 != value2) {
            this.markPropertyChanged(property);
        }
    }

    public void markPropertyChanged(String property) {
        if (this.changedProperties == null) {
            this.changedProperties = new TreeSet<String>(new AttributePositionComparator(this.original));
        }
        this.changedProperties.add(property);
        this.kind |= 1;
        this.kindOfChange |= 2;
    }

    @Override
    public boolean isClassChanged() {
        return (this.kindOfChange & 8) > 0;
    }

    @Override
    public boolean isPropertyChanged() {
        return (this.kindOfChange & 2) > 0;
    }

    @Override
    public List<String> getChangedProperties() {
        if (this.changedProperties == null) {
            return List.of();
        }
        return List.copyOf(this.changedProperties);
    }

    @Override
    public boolean isPropertyChanged(String propertyName) {
        if (this.changedProperties == null || propertyName == null) {
            return false;
        }
        return this.changedProperties.contains(propertyName);
    }

    public void markMoved() {
        this.kind |= 4;
    }

    @Override
    public boolean isMoved() {
        return (this.kind & 4) > 0;
    }

    @Override
    public boolean isDifferentObjectAtPosition() {
        return (this.kind & 2) > 0;
    }

    @Override
    public boolean isAdded() {
        return (this.kind & 0x10) > 0;
    }

    @Override
    public boolean isChanged() {
        return (this.kind & 1) > 0;
    }

    @Override
    public boolean isChildChanged() {
        return (this.kindOfChange & 4) > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.kind == 0;
    }

    @Override
    public boolean isRemoved() {
        return (this.kind & 8) > 0;
    }

    @Override
    public boolean isStructureChanged() {
        return (this.kindOfChange & 1) > 0;
    }

    @Override
    public List<IModelObjectDelta> getChildDeltas() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public List<IModelObjectDelta> getChildDeltas(int kind) {
        ArrayList<IModelObjectDelta> childrenOfKind = new ArrayList<IModelObjectDelta>();
        for (IModelObjectDelta child : this.children) {
            if ((child.getKind() & kind) <= 0) continue;
            childrenOfKind.add(child);
        }
        return childrenOfKind;
    }

    @Override
    public void accept(IModelObjectDeltaVisitor visitor) {
        if (visitor.visit(this)) {
            for (IModelObjectDelta child : this.children) {
                child.accept(visitor);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, "");
        return builder.toString();
    }

    public void toString(StringBuilder builder, String indentation) {
        builder.append(indentation);
        if (this.isAdded()) {
            builder.append("+");
            builder.append(this.referenceObject);
        } else if (this.isRemoved()) {
            builder.append("-");
            builder.append(this.original);
        } else if (this.isDifferentObjectAtPosition()) {
            builder.append("differentObject");
        } else {
            builder.append(this.isChanged() ? "*" : "empty ");
            builder.append(this.original);
        }
        if (this.isMoved()) {
            builder.append(" (moved)");
        }
        if (this.changedProperties != null) {
            builder.append(" [");
            StringBuilderJoiner.join(builder, this.changedProperties);
            builder.append(']');
        }
        builder.append(System.lineSeparator());
        for (IModelObjectDelta delta : this.getChildDeltas()) {
            ((ModelObjectDelta)delta).toString(builder, indentation + "    ");
        }
    }

    private static class AttributePositionComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, Integer> propertyPositions = new HashMap<String, Integer>();

        private AttributePositionComparator(IModelObject object) {
            if (IpsModel.isPolicyCmptType(object.getClass())) {
                List<PolicyAttribute> attributes = IpsModel.getPolicyCmptType(object).getAttributes();
                for (int i = 0; i < attributes.size(); ++i) {
                    this.propertyPositions.put(attributes.get(i).getName(), i);
                }
            }
        }

        @Override
        public int compare(String o1, String o2) {
            Integer index1 = this.propertyPositions.get(o1);
            Integer index2 = this.propertyPositions.get(o2);
            if (index1 != null && index2 != null) {
                return index1.compareTo(index2);
            }
            int diff = o1.compareTo(o2);
            if (index1 != null) {
                return Math.abs(diff);
            }
            if (index2 != null) {
                return -Math.abs(diff);
            }
            return diff;
        }
    }
}

