/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Field;
import java.util.Calendar;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.model.annotation.IpsAttribute;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.values.NullObject;
import org.faktorips.valueset.OrderedValueSet;
import org.faktorips.valueset.ValueSet;

public class ConstantPolicyAttribute
extends PolicyAttribute {
    private final Field field;

    public ConstantPolicyAttribute(Type type, Field field, boolean changingOverTime) {
        super(type, field.getAnnotation(IpsAttribute.class), field.getAnnotation(IpsExtensionProperties.class), field.getType(), changingOverTime, Deprecation.of(field));
        this.field = field;
    }

    @Override
    public boolean isProductRelevant() {
        return false;
    }

    @Override
    public Object getValue(IModelObject modelObject) {
        return ConstantPolicyAttribute.invokeField(this.field, modelObject);
    }

    @Override
    public void setValue(IModelObject modelObject, Object value) {
        throw new UnsupportedOperationException("Cannot modify a constant field.");
    }

    @Override
    public void removeValue(IModelObject modelObject) {
        throw new UnsupportedOperationException("Cannot modify a constant field.");
    }

    @Override
    public ConstantPolicyAttribute createOverwritingAttributeFor(Type subType) {
        return new ConstantPolicyAttribute(subType, this.field, this.isChangingOverTime());
    }

    @Override
    public Object getDefaultValue(IModelObject modelObject) {
        return this.getValue(modelObject);
    }

    @Override
    public Object getDefaultValue(IProductComponent source, Calendar effectiveDate) {
        throw new UnsupportedOperationException(this.getName() + " is a constant field and has no product configuration");
    }

    @Override
    public void setDefaultValue(IConfigurableModelObject modelObject, Object defaultValue) {
        throw new UnsupportedOperationException(this.getName() + " is a constant field and has no product configuration");
    }

    @Override
    public void setDefaultValue(IProductComponent source, Calendar effectiveDate, Object defaultValue) {
        throw new UnsupportedOperationException(this.getName() + " is a constant field and has no product configuration");
    }

    @Override
    public ValueSet<?> getValueSet(IModelObject modelObject, IValidationContext context) {
        Object value = this.getValue(modelObject);
        if (value == null) {
            return new OrderedValueSet(true, null, new Object[0]);
        }
        if (value instanceof NullObject) {
            return new OrderedValueSet(true, value, new Object[0]);
        }
        return new OrderedValueSet(false, null, new Object[]{value});
    }

    @Override
    public ValueSet<?> getValueSetFromModel() {
        throw new UnsupportedOperationException(this.getName() + " is a constant field.");
    }

    @Override
    public ValueSet<?> getValueSet(IProductComponent source, Calendar effectiveDate, IValidationContext context) {
        throw new UnsupportedOperationException(this.getName() + " is a constant field and has no product configuration");
    }

    @Override
    public void setValueSet(IProductComponent source, Calendar effectiveDate, ValueSet<?> valueSet) {
        throw new UnsupportedOperationException(this.getName() + " is a constant field and has no product configuration");
    }

    @Override
    public void setValueSet(IConfigurableModelObject modelObject, ValueSet<?> valueSet) {
        throw new UnsupportedOperationException(this.getName() + " is a constant field and has no product configuration");
    }

    @Override
    protected String getResourceBundleName() {
        return ConstantPolicyAttribute.class.getName();
    }
}

