/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type.read;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.faktorips.runtime.model.annotation.IpsConfiguredAttribute;
import org.faktorips.runtime.model.type.ConstantPolicyAttribute;
import org.faktorips.runtime.model.type.DefaultPolicyAttribute;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.read.AbstractAttributeDescriptor;
import org.faktorips.runtime.model.type.read.AttributeCollector;

public class PolicyAttributeCollector
extends AttributeCollector<PolicyAttribute, PolicyAttributeDescriptor> {
    public PolicyAttributeCollector() {
        super(List.of(new AttributeCollector.IpsAttributeProcessor(), new AttributeCollector.IpsAttributeSetterProcessor()));
    }

    @Override
    protected PolicyAttributeDescriptor createDescriptor() {
        return new PolicyAttributeDescriptor();
    }

    protected static class PolicyAttributeDescriptor
    extends AbstractAttributeDescriptor<PolicyAttribute> {
        protected PolicyAttributeDescriptor() {
        }

        @Override
        protected PolicyAttribute createValid(Type type) {
            if (this.getAnnotatedElement() instanceof Field) {
                boolean changingOverTime = this.isChangingOverTime();
                return new ConstantPolicyAttribute(type, (Field)this.getAnnotatedElement(), changingOverTime);
            }
            return new DefaultPolicyAttribute((PolicyCmptType)type, (Method)this.getAnnotatedElement(), this.getSetterMethod(), this.isChangingOverTime());
        }

        private boolean isChangingOverTime() {
            boolean changingOverTime = false;
            if (this.getAnnotatedElement().isAnnotationPresent(IpsConfiguredAttribute.class)) {
                changingOverTime = this.getAnnotatedElement().getAnnotation(IpsConfiguredAttribute.class).changingOverTime();
            }
            return changingOverTime;
        }
    }
}

