/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.enumtype;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.annotation.IpsEnumAttribute;
import org.faktorips.runtime.model.annotation.IpsEnumType;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.enumtype.EnumType;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.Documentation;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.read.SimpleTypePartsReader;
import org.faktorips.runtime.util.MessagesHelper;
import org.faktorips.values.DefaultInternationalString;
import org.faktorips.values.LocalizedString;
import org.faktorips.values.ObjectUtil;

public class EnumAttribute
extends ModelElement {
    public static final String MSGCODE_MANDATORY_ATTRIBUTE_IS_EMPTY = "ENUM_ATTRIBUTE-MANDATORY_ATTRIBUTE_IS_EMPTY";
    public static final String MSGCODE_NOT_UNIQUE = "ENUM_ATTRIBUTE-NOT_UNIQUE";
    protected static final String MSGKEY_MANDATORY_ATTRIBUTE_IS_EMPTY = "Validation.MandatoryAttributeIsEmpty";
    protected static final String MSGKEY_MANDATORY_MULTILINGUAL_ATTRIBUTE_IS_EMPTY = "Validation.MandatoryMultilingualAttributeIsEmpty";
    protected static final String MSGKEY_NOT_UNIQUE = "Validation.AttributeNotUnique";
    private final EnumType enumType;
    private final Class<?> datatype;
    private final Method getter;
    private final IpsEnumAttribute annotation;

    public EnumAttribute(EnumType enumType, String name, Method getter) {
        super(name, getter.getAnnotation(IpsExtensionProperties.class), Deprecation.of(getter));
        this.enumType = enumType;
        this.datatype = getter.getReturnType();
        this.getter = getter;
        this.annotation = getter.getAnnotation(IpsEnumAttribute.class);
    }

    public Class<?> getDatatype() {
        return this.datatype;
    }

    public boolean isUnique() {
        return this.annotation.unique();
    }

    public boolean isIdentifier() {
        return this.annotation.identifier();
    }

    public boolean isDisplayName() {
        return this.annotation.displayName();
    }

    public boolean isMandatory() {
        return this.annotation.mandatory();
    }

    public Object getValue(Object enumValue) {
        return this.getValue(enumValue, Locale.getDefault());
    }

    public boolean isMultilingual() {
        return this.getter.getParameterTypes().length == 1;
    }

    public Object getValue(Object enumValue, Locale locale) {
        try {
            if (this.isMultilingual()) {
                return this.getter.invoke(enumValue, locale);
            }
            return this.getter.invoke(enumValue, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw this.cantGetValueException(e, locale);
        }
    }

    private RuntimeException cantGetValueException(Exception e, Locale locale) {
        return new RuntimeException("Can't get value for attribute \"" + this.getName() + "\"" + (String)(this.isMultilingual() ? " for locale " + locale : ""), e);
    }

    @Override
    protected String getMessageKey(DocumentationKind messageType) {
        return messageType.getKey(this.enumType.getName(), "EnumType", this.getName());
    }

    @Override
    protected MessagesHelper getMessageHelper() {
        return this.enumType.getMessageHelper();
    }

    protected static LinkedHashMap<String, EnumAttribute> createFrom(EnumType enumType, Class<?> enumClass) {
        return new SimpleTypePartsReader<EnumAttribute, IpsEnumType, IpsEnumAttribute>(IpsEnumType.class, IpsEnumType::attributeNames, IpsEnumAttribute.class, IpsEnumAttribute::name, (modelType, name, getterMethod) -> new EnumAttribute((EnumType)modelType, name, getterMethod)).createParts(enumClass, enumType);
    }

    public Optional<EnumAttribute> findSuperEnumAttribute() {
        return this.enumType.findSuperEnumType().map(s -> s.getAttribute(this.getName()));
    }

    @Override
    protected String getDocumentation(Locale locale, DocumentationKind type, String fallback) {
        return Documentation.of(this, type, locale, fallback, this::findSuperEnumAttribute);
    }

    public void validate(MessageList list, IValidationContext context, Object enumValue) {
        Objects.requireNonNull(list, "list must not be null");
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(enumValue, "enumValue must not be null");
        if (this.enumType.isExtensible() && this.isFromExtension(enumValue)) {
            this.validateMandatory(list, context, enumValue);
        }
    }

    private void validateMandatory(MessageList list, IValidationContext context, Object enumValue) {
        if (this.isMandatory()) {
            if (this.isMultilingual()) {
                Collection<LocalizedString> localizedStrings = this.getLocalizedStrings(enumValue);
                localizedStrings.forEach(l -> {
                    String value = l.getValue();
                    if (ObjectUtil.isNull((Object)value) || value.isEmpty()) {
                        this.addErrorMessage(list, context, MSGCODE_MANDATORY_ATTRIBUTE_IS_EMPTY, MSGKEY_MANDATORY_MULTILINGUAL_ATTRIBUTE_IS_EMPTY, enumValue, this.getLabel(context.getLocale()), l.getLocale().getDisplayName(context.getLocale()), enumValue);
                    }
                });
                if (localizedStrings.isEmpty()) {
                    this.addErrorMessage(list, context, MSGCODE_MANDATORY_ATTRIBUTE_IS_EMPTY, MSGKEY_MANDATORY_ATTRIBUTE_IS_EMPTY, enumValue, this.getLabel(context.getLocale()), enumValue);
                }
            } else {
                String s;
                Object value = this.getValue(enumValue);
                if (ObjectUtil.isNull((Object)value) || value instanceof String && (s = (String)value).isEmpty()) {
                    this.addErrorMessage(list, context, MSGCODE_MANDATORY_ATTRIBUTE_IS_EMPTY, MSGKEY_MANDATORY_ATTRIBUTE_IS_EMPTY, enumValue, this.getLabel(context.getLocale()), enumValue);
                }
            }
        }
    }

    void addErrorMessage(MessageList list, IValidationContext context, String msgCode, String msgKey, Object enumValue, Object ... replacementValues) {
        Locale locale = context.getLocale();
        ResourceBundle messages = this.getResourceBundle(locale);
        String text = String.format(messages.getString(msgKey), replacementValues);
        Message message = Message.error(text).code(msgCode).invalidObjectWithProperties(enumValue, this.getName()).create();
        list.add(message);
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle(EnumAttribute.class.getName(), locale);
    }

    private Collection<LocalizedString> getLocalizedStrings(Object enumValue) {
        try {
            Field field = this.enumType.getEnumClass().getDeclaredField(IpsStringUtils.toLowerFirstChar(this.getName()));
            field.setAccessible(true);
            Object object = field.get(enumValue);
            if (object instanceof DefaultInternationalString) {
                DefaultInternationalString defaultInternationalString = (DefaultInternationalString)object;
                return defaultInternationalString.getLocalizedStrings();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException("Can't validate multilingual attribute " + this.enumType + "." + this + " because accessing the internal field failed", e);
        }
        return List.of();
    }

    private boolean isFromExtension(Object enumValue) {
        try {
            Field field = this.enumType.getEnumClass().getDeclaredField("productRepository");
            field.setAccessible(true);
            return field.get(enumValue) != null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException("Can't validate multilingual attribute " + this.enumType + "." + this + " because accessing the internal field failed", e);
        }
    }
}

