/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.faktorips.runtime.CardinalityRange;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.model.annotation.IpsAssociationAdder;
import org.faktorips.runtime.model.annotation.IpsAssociationLinks;
import org.faktorips.runtime.model.annotation.IpsAssociationRemover;
import org.faktorips.runtime.model.type.Association;
import org.faktorips.runtime.model.type.PolicyAssociation;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.util.ValidationMessageUtil;

public class ProductAssociation
extends Association {
    public static final String MSGCODE_MAX_CARDINALITY_NOT_VALID = "ASSOCIATION-MAX_CARDINALITY_NOT_VALID";
    public static final String MSGKEY_MAX_CARDINALITY_NOT_VALID = "Validation.MaxCardinalityNotValid";
    public static final String MSGCODE_MIN_CARDINALITY_NOT_VALID = "ASSOCIATION-MIN_CARDINALITY_NOT_VALID";
    public static final String MSGKEY_MIN_CARDINALITY_NOT_VALID = "Validation.MinCardinalityNotValid";
    public static final String MSGCODE_MAX_CARDINALITY_EXCEEDS_MODEL_MAX = "ASSOCIATION-MAX_CARDINALITY_EXCEEDS_MODEL_MAX";
    public static final String MSGKEY_MAX_CARDINALITY_EXCEEDS_MODEL_MAX = "Validation.MaxCardinalityExceedsModelMax";
    public static final String MSGCODE_MIN_CARDINALITY_FALLS_BELOW_MODEL_MIN = "ASSOCIATION-MIN_CARDINALITY_FALLS_BELOW_MODEL_MIN";
    public static final String MSGKEY_MIN_CARDINALITY_FALLS_BELOW_MODEL_MIN = "Validation.MinCardinalityFallsBelowModelMin";
    public static final String MSGCODE_DATE_FROM_NOT_VALID = "ASSOCIATION-VALID_FROM_NOT_VALID";
    public static final String MSGKEY_DATE_FROM_NOT_VALID = "Validation.DateFromNotValid";
    public static final String MSGCODE_DATE_TO_NOT_VALID = "ASSOCIATION-VALID_TO_NOT_VALID";
    public static final String MSGKEY_DATE_TO_NOT_VALID = "Validation.DateToNotValid";
    private final boolean changingOverTime;
    private final Method getLinksMethod;
    private final Method addMethodWithCardinality;
    private final Method addMethod;
    private final Method removeMethod;

    public ProductAssociation(Type type, Method getterMethod, Method addMethod, Method addMethodWithCardinality, Method removeMethod, boolean changingOverTime, Method getLinksMethod) {
        super(type, getterMethod);
        this.addMethod = addMethod;
        this.addMethodWithCardinality = addMethodWithCardinality;
        this.removeMethod = removeMethod;
        this.changingOverTime = changingOverTime;
        this.getLinksMethod = getLinksMethod;
    }

    @Override
    public ProductAssociation createOverwritingAssociationFor(Type subType) {
        return new ProductAssociation(subType, this.getGetterMethod(), this.addMethod, this.addMethodWithCardinality, this.removeMethod, this.changingOverTime, this.getLinksMethod);
    }

    @Override
    public ProductCmptType getType() {
        return (ProductCmptType)super.getType();
    }

    @Override
    @Deprecated
    public ProductCmptType getModelType() {
        return this.getType();
    }

    @Override
    public ProductCmptType getTarget() {
        return (ProductCmptType)super.getTarget();
    }

    public List<IProductComponent> getTargetObjects(IProductComponent productComponentSource, Calendar effectiveDate) {
        ArrayList<IProductComponent> targets = new ArrayList<IProductComponent>();
        Object source = ProductAssociation.getRelevantProductObject(productComponentSource, effectiveDate, this.isChangingOverTime());
        Object returnValue = ProductAssociation.invokeMethod(this.getGetterMethod(), source, new Object[0]);
        if (returnValue instanceof Iterable) {
            Iterable it = (Iterable)returnValue;
            for (Object target : it) {
                targets.add((IProductComponent)target);
            }
        } else if (returnValue instanceof IProductComponent) {
            IProductComponent productCmpt = (IProductComponent)returnValue;
            targets.add(productCmpt);
        }
        return targets;
    }

    public <S extends IProductComponent> S addTargetObjects(S source, Calendar effectiveDate, Collection<IProductComponent> targets) {
        if (this.isToOneAssociation() && targets.size() > 1) {
            throw new IllegalArgumentException(String.format("The association %s on source object %s allows a maxmimum of one target object but %s were provided.", this.getName(), source, targets.size()));
        }
        if (this.addMethod == null) {
            if (this.isOverriding()) {
                return this.getSuperAssociation().addTargetObjects(source, effectiveDate, targets);
            }
            throw new IllegalArgumentException(String.format("The association %s on source object %s does not allow %s target objects%s.", this.getName(), source, this.isToOneAssociation() ? "setting" : "adding", this.isDerivedUnion() ? " because it is a derived union" : "; make sure a method annotated with @" + IpsAssociationAdder.class.getSimpleName() + " exists"));
        }
        Object relevantSource = ProductAssociation.getRelevantProductObject(source, effectiveDate, this.isChangingOverTime());
        for (IProductComponent target : targets) {
            ProductAssociation.invokeMethod(this.addMethod, relevantSource, target);
        }
        return source;
    }

    public <S extends IProductComponent> S addTargetObjects(S source, Calendar effectiveDate, IProductComponent ... targets) {
        return this.addTargetObjects(source, effectiveDate, Arrays.asList(targets));
    }

    public <S extends IProductComponent> S addTargetObject(S source, Calendar effectiveDate, IProductComponent target, CardinalityRange cardinality) {
        if (this.addMethodWithCardinality == null) {
            if (this.isOverriding()) {
                return this.getSuperAssociation().addTargetObject(source, effectiveDate, target, cardinality);
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = this.getName();
            objectArray[1] = source;
            Object object = objectArray[2] = this.isToOneAssociation() ? "setting" : "adding";
            objectArray[3] = this.isDerivedUnion() ? " because it is a derived union" : (this.isMatchingAssociationPresent() ? " because it has no matching association" : "; make sure a method annotated with @" + IpsAssociationAdder.class.getSimpleName() + "(withCardinality = true) exists");
            throw new IllegalArgumentException(String.format("The association %s on source object %s does not allow %s target objects with cardinality%s.", objectArray));
        }
        Object relevantSource = ProductAssociation.getRelevantProductObject(source, effectiveDate, this.isChangingOverTime());
        ProductAssociation.invokeMethod(this.addMethodWithCardinality, relevantSource, new Object[]{target, cardinality});
        return source;
    }

    public <S extends IProductComponent> S removeTargetObjects(S source, Calendar effectiveDate, List<IProductComponent> targetsToRemove) {
        if (this.isToOneAssociation()) {
            if (targetsToRemove.size() > 1) {
                throw new IllegalArgumentException(String.format("The association %s on source object %s allows a maxmimum of one target object but %s were tried to remove.", this.getName(), source, targetsToRemove.size()));
            }
            if (targetsToRemove.size() == 1) {
                this.resetTargetObject(source, effectiveDate, targetsToRemove.get(0));
            }
        } else {
            if (this.removeMethod == null) {
                if (this.isOverriding()) {
                    return this.getSuperAssociation().removeTargetObjects(source, effectiveDate, targetsToRemove);
                }
                throw new IllegalArgumentException(String.format("The association %s on source object %s does not allow removing target objects%s.", this.getName(), source, this.isDerivedUnion() ? " because it is a derived union" : "; make sure a method annotated with @" + IpsAssociationRemover.class.getSimpleName() + " exists"));
            }
            Object relevantSource = ProductAssociation.getRelevantProductObject(source, effectiveDate, this.isChangingOverTime());
            for (IProductComponent targetToRemove : targetsToRemove) {
                ProductAssociation.invokeMethod(this.removeMethod, relevantSource, targetToRemove);
            }
        }
        return source;
    }

    public <S extends IProductComponent> S removeTargetObjects(S source, Calendar effectiveDate, IProductComponent ... targetsToRemove) {
        return this.removeTargetObjects(source, effectiveDate, Arrays.asList(targetsToRemove));
    }

    @Override
    public PolicyCmptType getMatchingAssociationSourceType() {
        return (PolicyCmptType)super.getMatchingAssociationSourceType();
    }

    @Override
    public PolicyAssociation getMatchingAssociation() {
        return (PolicyAssociation)super.getMatchingAssociation();
    }

    public Optional<PolicyAssociation> findMatchingAssociation() {
        return Optional.ofNullable(this.getMatchingAssociation());
    }

    @Override
    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    public <T extends IProductComponent> Collection<IProductComponentLink<T>> getLinks(IProductComponent prodCmpt, Calendar effectiveDate) {
        if (this.isChangingOverTime()) {
            Object generation = ProductAssociation.getRelevantProductObject(prodCmpt, effectiveDate, true);
            return this.getLinksFromObject(generation);
        }
        return this.getLinksFromObject(prodCmpt);
    }

    public <T extends IProductComponent> Optional<IProductComponentLink<T>> getLink(IProductComponent source, IProductComponent target, Calendar effectiveDate) {
        return this.getLinks(source, effectiveDate).stream().filter(l -> Objects.equals(l.getTarget(), target)).map(l -> l).findFirst();
    }

    @Override
    public ProductAssociation getSuperAssociation() {
        return (ProductAssociation)super.getSuperAssociation();
    }

    @Override
    public void validate(MessageList list, IValidationContext context, IProductComponent source, Calendar effectiveDate) {
        List<IProductComponent> targetObjects = this.getTargetObjects(source, effectiveDate);
        this.validateMinCardinality(list, context, source, targetObjects, effectiveDate);
        this.validateMaxCardinality(list, context, source, targetObjects, effectiveDate);
        this.validateValidFrom(list, context, source, targetObjects, effectiveDate);
        this.validateValidTo(list, context, source, targetObjects);
    }

    private void validateMinCardinality(MessageList list, IValidationContext context, IProductComponent source, List<IProductComponent> targetObjects, Calendar effectiveDate) {
        this.validate(list, context, () -> targetObjects.size(), this::getMinCardinality, (V links, R minCardinality) -> links.compareTo((Integer)minCardinality) < 0, MSGCODE_MIN_CARDINALITY_NOT_VALID, MSGKEY_MIN_CARDINALITY_NOT_VALID, "minCardinality", new ObjectProperty(source, this.getName()));
        this.findMatchingAssociation().ifPresent(policyAssociation -> this.validateTotalMin(list, (PolicyAssociation)policyAssociation, this.getLinks(source, effectiveDate), context));
    }

    private void validateMaxCardinality(MessageList list, IValidationContext context, IProductComponent source, List<IProductComponent> targetObjects, Calendar effectiveDate) {
        this.validate(list, context, () -> targetObjects.size(), this::getMaxCardinality, (V links, R maxCardinality) -> links.compareTo((Integer)maxCardinality) > 0, MSGCODE_MAX_CARDINALITY_NOT_VALID, MSGKEY_MAX_CARDINALITY_NOT_VALID, "maxCardinality", new ObjectProperty(source, this.getName()));
        this.findMatchingAssociation().ifPresent(policyAssociation -> this.validateTotalMax(list, (PolicyAssociation)policyAssociation, this.getLinks(source, effectiveDate), context));
    }

    private void validateTotalMax(MessageList list, PolicyAssociation policyAssociation, Collection<IProductComponentLink<IProductComponent>> links, IValidationContext context) {
        int maxType = policyAssociation.getMaxCardinality();
        if (maxType != Integer.MAX_VALUE) {
            int sumMinCardinality = links.stream().mapToInt(relation -> (Integer)relation.getCardinality().getLowerBound()).sum();
            for (IProductComponentLink<IProductComponent> link : links) {
                int sumCardinality;
                if ((Integer)link.getCardinality().getUpperBound() < Integer.MAX_VALUE) {
                    sumCardinality = sumMinCardinality;
                    sumCardinality += ((Integer)link.getCardinality().getUpperBound()).intValue();
                    sumCardinality -= ((Integer)link.getCardinality().getLowerBound()).intValue();
                } else {
                    sumCardinality = Integer.MAX_VALUE;
                }
                if (sumCardinality <= maxType) continue;
                list.newError(MSGCODE_MAX_CARDINALITY_EXCEEDS_MODEL_MAX, ValidationMessageUtil.generateValidationMessage(context.getLocale(), this.getResourceBundleName(), MSGKEY_MAX_CARDINALITY_EXCEEDS_MODEL_MAX, sumCardinality, link.getTargetId(), maxType, this.getUsedName()), new ObjectProperty((Object)link.getCardinality(), "upperBound"), new ObjectProperty(link.getSource(), this.getName()));
            }
        }
    }

    private void validateTotalMin(MessageList list, PolicyAssociation policyAssociation, Collection<IProductComponentLink<IProductComponent>> links, IValidationContext context) {
        int minType = policyAssociation.getMinCardinality();
        for (IProductComponentLink<IProductComponent> link : links) {
            int sumMaxCardinality = (Integer)link.getCardinality().getLowerBound();
            for (IProductComponentLink<IProductComponent> otherLink : links) {
                if (link.equals(otherLink)) continue;
                if ((Integer)otherLink.getCardinality().getUpperBound() == Integer.MAX_VALUE) {
                    sumMaxCardinality = Integer.MAX_VALUE;
                    break;
                }
                sumMaxCardinality += ((Integer)otherLink.getCardinality().getUpperBound()).intValue();
            }
            if (sumMaxCardinality >= minType) continue;
            list.newError(MSGCODE_MIN_CARDINALITY_FALLS_BELOW_MODEL_MIN, ValidationMessageUtil.generateValidationMessage(context.getLocale(), this.getResourceBundleName(), MSGKEY_MIN_CARDINALITY_FALLS_BELOW_MODEL_MIN, sumMaxCardinality, link.getTargetId(), minType, this.getUsedName()), new ObjectProperty((Object)link.getCardinality(), "lowerBound"), new ObjectProperty(link.getSource(), this.getName()));
        }
    }

    private void validateValidTo(MessageList list, IValidationContext context, IProductComponent source, List<IProductComponent> targetObjects) {
        for (IProductComponent target : targetObjects) {
            this.validate(list, () -> target.getValidTo(), () -> source.getValidTo(), (V targetDate, R sourceDate) -> targetDate.compareTo((DateTime)sourceDate) < 0, (V targetDate, R sourceDate) -> ValidationMessageUtil.generateValidationMessage(context.getLocale(), this.getResourceBundleName(), MSGKEY_DATE_TO_NOT_VALID, targetDate, target, sourceDate, source), MSGCODE_DATE_TO_NOT_VALID, new ObjectProperty(target, "validTo"), new ObjectProperty(source, this.getName()));
        }
    }

    private void validateValidFrom(MessageList list, IValidationContext context, IProductComponent source, List<IProductComponent> targetObjects, Calendar effectiveDate) {
        for (IProductComponent target : targetObjects) {
            this.validate(list, () -> target.getValidFrom(), () -> this.isChangingOverTime() ? source.getGenerationBase(effectiveDate).getValidFrom() : source.getValidFrom(), (V targetDate, R sourceDate) -> targetDate.compareTo((DateTime)sourceDate) > 0, (V targetDate, R sourceDate) -> ValidationMessageUtil.generateValidationMessage(context.getLocale(), this.getResourceBundleName(), MSGKEY_DATE_FROM_NOT_VALID, targetDate, target, sourceDate, source), MSGCODE_DATE_FROM_NOT_VALID, new ObjectProperty(target, "validFrom"), new ObjectProperty(source, this.getName()));
        }
    }

    private <S extends IProductComponent> void resetTargetObject(S source, Calendar effectiveDate, IProductComponent targetToReset) {
        if (this.getTargetObjects(source, effectiveDate).contains(targetToReset)) {
            this.addTargetObjects(source, effectiveDate, new IProductComponent[]{null});
        }
    }

    private <T extends IProductComponent> Collection<IProductComponentLink<T>> getLinksFromObject(Object prodCmptOrGeneration) {
        if (this.getLinksMethod == null) {
            if (this.isOverriding()) {
                return this.getSuperAssociation().getLinksFromObject(prodCmptOrGeneration);
            }
            throw new IllegalArgumentException(String.format("The association %s on %s does not allow retrieving links%s.", this.getName(), prodCmptOrGeneration, this.isDerivedUnion() ? " because it is a derived union" : "; make sure a method annotated with @" + IpsAssociationLinks.class + " exists"));
        }
        if (this.isToOneAssociation()) {
            IProductComponentLink link = (IProductComponentLink)ProductAssociation.invokeMethod(this.getLinksMethod, prodCmptOrGeneration, new Object[0]);
            if (link == null) {
                return List.of();
            }
            return Collections.singletonList(link);
        }
        return (Collection)ProductAssociation.invokeMethod(this.getLinksMethod, prodCmptOrGeneration, new Object[0]);
    }
}

