/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductObject;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsChangingOverTime;
import org.faktorips.runtime.model.annotation.IpsConfigures;
import org.faktorips.runtime.model.type.Association;
import org.faktorips.runtime.model.type.Attribute;
import org.faktorips.runtime.model.type.Formula;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.ProductAssociation;
import org.faktorips.runtime.model.type.ProductAttribute;
import org.faktorips.runtime.model.type.TableUsage;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypeHierarchyVisitor;
import org.faktorips.runtime.model.type.TypePart;
import org.faktorips.runtime.model.type.read.FormulaCollector;
import org.faktorips.runtime.model.type.read.ProductAssociationCollector;
import org.faktorips.runtime.model.type.read.ProductAttributeCollector;
import org.faktorips.runtime.model.type.read.TableUsageCollector;
import org.faktorips.runtime.model.type.read.TypePartsReader;

public class ProductCmptType
extends Type {
    public static final String KIND_NAME = "ProductCmptType2";
    private final AnnotatedDeclaration generationDeclaration;
    private final LinkedHashMap<String, ProductAttribute> attributes;
    private final LinkedHashMap<String, ProductAssociation> associations;
    private final LinkedHashMap<String, TableUsage> tableUsages;
    private final LinkedHashMap<String, Formula> formulas;

    public ProductCmptType(String name, AnnotatedDeclaration annotatedDeclaration) {
        super(name, annotatedDeclaration);
        this.generationDeclaration = this.isChangingOverTime() ? AnnotatedDeclaration.from(annotatedDeclaration.get(IpsChangingOverTime.class).value()) : null;
        ProductAttributeCollector attributeCollector = new ProductAttributeCollector();
        ProductAssociationCollector associationCollector = new ProductAssociationCollector();
        TableUsageCollector tableUsageCollector = new TableUsageCollector();
        FormulaCollector formulaCollector = new FormulaCollector();
        this.initParts(attributeCollector, associationCollector, tableUsageCollector, formulaCollector);
        this.attributes = attributeCollector.createParts(this);
        this.associations = associationCollector.createParts(this);
        this.tableUsages = tableUsageCollector.createParts(this);
        this.formulas = formulaCollector.createParts(this);
    }

    private void initParts(ProductAttributeCollector attributeCollector, ProductAssociationCollector associationCollector, TableUsageCollector tableUsageCollector, FormulaCollector formulaCollector) {
        TypePartsReader typePartsReader = new TypePartsReader(attributeCollector, associationCollector, tableUsageCollector, formulaCollector);
        typePartsReader.init(this.getAnnotatedDeclaration());
        typePartsReader.read(this.getAnnotatedDeclaration());
        if (this.isChangingOverTime()) {
            typePartsReader.read(this.generationDeclaration);
        }
    }

    @Override
    protected String getKindName() {
        return KIND_NAME;
    }

    @Override
    protected List<Method> getDeclaredMethods() {
        List<Method> result = super.getDeclaredMethods();
        if (this.isChangingOverTime()) {
            result.addAll(this.generationDeclaration.getDeclaredMethods());
        }
        return result;
    }

    public boolean isChangingOverTime() {
        return this.getAnnotatedDeclaration().is(IpsChangingOverTime.class);
    }

    public boolean isConfigurationForPolicyCmptType() {
        return this.getAnnotatedDeclaration().is(IpsConfigures.class);
    }

    public boolean isSameOrSub(ProductCmptType reference) {
        if (reference.equals(this)) {
            return true;
        }
        return this.findSuperType().map(s -> s.isSameOrSub(reference)).orElse(false);
    }

    public PolicyCmptType getPolicyCmptType() {
        return IpsModel.getPolicyCmptType(this.getAnnotatedDeclaration().get(IpsConfigures.class).value().asSubclass(IModelObject.class));
    }

    public TableUsage getTableUsage(String name) {
        TableUsageFinder finder = new TableUsageFinder(name);
        finder.visitHierarchy(this);
        if (finder.tableUsage == null) {
            throw new IllegalArgumentException("The type " + this + " (or one of it's super types) hasn't got a table usage \"" + name + "\"");
        }
        return finder.tableUsage;
    }

    public List<TableUsage> getDeclaredTableUsages() {
        return new ArrayList<TableUsage>(this.tableUsages.values());
    }

    public TableUsage getDeclaredTableUsage(String name) {
        TableUsage tableUsage = this.tableUsages.get(IpsStringUtils.toLowerFirstChar(name));
        if (tableUsage == null) {
            throw new IllegalArgumentException("The type " + this + " hasn't got a declared table usage " + name);
        }
        return tableUsage;
    }

    public boolean hasDeclaredTableUsage(String name) {
        return this.tableUsages.containsKey(IpsStringUtils.toLowerFirstChar(name));
    }

    public List<Formula> getDeclaredFormulas() {
        return new ArrayList<Formula>(this.formulas.values());
    }

    public Formula getDeclaredFormula(String name) {
        Formula formula = this.formulas.get(IpsStringUtils.toLowerFirstChar(name));
        if (formula == null) {
            throw new IllegalArgumentException("The type " + this + " hasn't got a declared formula " + name);
        }
        return formula;
    }

    public boolean hasDeclaredFormula(String name) {
        return this.formulas.containsKey(IpsStringUtils.toLowerFirstChar(name));
    }

    public List<TableUsage> getTableUsages() {
        TableUsagesCollector tuCollector = new TableUsagesCollector();
        tuCollector.visitHierarchy(this);
        return tuCollector.result;
    }

    public Class<?> getGenerationJavaClass() {
        if (this.generationDeclaration != null) {
            return this.generationDeclaration.getImplementationClass();
        }
        return null;
    }

    public Class<?> getGenerationJavaInterface() {
        if (this.generationDeclaration != null) {
            return this.generationDeclaration.getPublishedInterface();
        }
        return null;
    }

    public Class<?> getGenerationDeclarationClass() {
        return this.getGenerationJavaInterface() == null ? this.getGenerationJavaClass() : this.getGenerationJavaInterface();
    }

    @Override
    public ProductCmptType getSuperType() {
        return this.findSuperType().orElse(null);
    }

    public Optional<ProductCmptType> findSuperType() {
        Class<?> superclass = this.getJavaClass().getSuperclass();
        return IpsModel.isProductCmptType(superclass) ? Optional.of(IpsModel.getProductCmptType(superclass.asSubclass(IProductComponent.class))) : Optional.empty();
    }

    @Override
    public ProductAttribute getDeclaredAttribute(int index) {
        return this.getDeclaredAttributes().get(index);
    }

    @Override
    public ProductAttribute getDeclaredAttribute(String name) {
        ProductAttribute attr = this.attributes.get(IpsStringUtils.toLowerFirstChar(name));
        if (attr == null) {
            throw new IllegalArgumentException("The type " + this + " hasn't got a declared attribute " + name);
        }
        return attr;
    }

    public List<ProductAttribute> getDeclaredAttributes() {
        return new ArrayList<ProductAttribute>(this.attributes.values());
    }

    @Override
    public ProductAttribute getAttribute(String name) {
        return (ProductAttribute)super.getAttribute(name);
    }

    public List<ProductAttribute> getAttributes() {
        Type.AttributeCollector attrCollector = new Type.AttributeCollector();
        attrCollector.visitHierarchy(this);
        return attrCollector.getResult();
    }

    public Formula getFormula(String name) {
        FormulaFinder finder = new FormulaFinder(name);
        finder.visitHierarchy(this);
        if (finder.formula == null) {
            throw new IllegalArgumentException("The type " + this + " (or one of it's super types) hasn't got a formula \"" + name + "\"");
        }
        return finder.formula;
    }

    public List<Formula> getFormulas() {
        FormulasCollector fCollector = new FormulasCollector();
        fCollector.visitHierarchy(this);
        return fCollector.result;
    }

    @Override
    public boolean isAttributeDeclared(String name) {
        return this.attributes.containsKey(IpsStringUtils.toLowerFirstChar(name));
    }

    @Override
    public ProductAssociation getDeclaredAssociation(int index) {
        return (ProductAssociation)super.getDeclaredAssociation(index);
    }

    @Override
    public ProductAssociation getDeclaredAssociation(String name) {
        ProductAssociation productAssociation = this.associations.get(IpsStringUtils.toLowerFirstChar(name));
        if (productAssociation == null) {
            throw new IllegalArgumentException("The type " + this + " hasn't got a declared association " + name);
        }
        return productAssociation;
    }

    public List<ProductAssociation> getDeclaredAssociations() {
        return new ArrayList<ProductAssociation>(new LinkedHashSet<ProductAssociation>(this.associations.values()));
    }

    @Override
    public boolean isAssociationDeclared(String name) {
        return this.associations.containsKey(IpsStringUtils.toLowerFirstChar(name));
    }

    @Override
    public ProductAssociation getAssociation(String name) {
        return (ProductAssociation)super.getAssociation(name);
    }

    public List<ProductAssociation> getAssociations() {
        Type.AssociationsCollector asscCollector = new Type.AssociationsCollector();
        asscCollector.visitHierarchy(this);
        return asscCollector.getResult();
    }

    public <T extends Annotation> Optional<Field> findDeclaredFieldFromGeneration(Class<T> annotationClass, Type.AnnotatedElementMatcher<T> matcher) {
        Class<?> genDeclarationClass = this.getGenerationDeclarationClass();
        Stream<Field> fields = Stream.of(genDeclarationClass.getDeclaredFields());
        if (genDeclarationClass.isInterface()) {
            fields = Stream.concat(fields, Stream.of(this.getGenerationJavaClass().getDeclaredFields()));
        }
        return fields.filter(field -> this.isMatchingField(annotationClass, matcher, (Field)field)).findFirst();
    }

    private <T extends Annotation> boolean isMatchingField(Class<T> annotationClass, Type.AnnotatedElementMatcher<T> matcher, Field field) {
        return field.isAnnotationPresent(annotationClass) && matcher.matches(field.getAnnotation(annotationClass));
    }

    @Override
    public <T extends Annotation> Optional<Field> findDeclaredField(Class<T> annotationClass, Type.AnnotatedElementMatcher<T> matcher) {
        return super.findDeclaredField(annotationClass, matcher);
    }

    public void validate(IProductComponent productComponent, MessageList messages, IValidationContext context) {
        if (!this.getJavaClass().isInstance(productComponent)) {
            throw new IllegalArgumentException(productComponent + " is not a " + this);
        }
        List<Calendar> validFroms = this.collectValidFroms(productComponent);
        this.getAttributes().forEach(a -> this.validatePart(a, messages, context, productComponent, validFroms));
        if (this.isConfigurationForPolicyCmptType()) {
            this.getPolicyCmptType().getAttributes().stream().filter(Attribute::isProductRelevant).forEach(a -> this.validatePart(a, messages, context, productComponent, validFroms));
        }
        this.getAssociations().stream().filter(Predicate.not(Association::isDerivedUnion)).forEach(a -> this.validatePart(a, messages, context, productComponent, validFroms));
    }

    private <T extends TypePart> void validatePart(T part, MessageList messages, IValidationContext context, IProductComponent productComponent, List<Calendar> validFroms) {
        if (part.isChangingOverTime()) {
            validFroms.forEach(effectiveDate -> part.validate(messages, context, productComponent, (Calendar)effectiveDate));
        } else {
            part.validate(messages, context, productComponent, null);
        }
    }

    private List<Calendar> collectValidFroms(IProductComponent productComponent) {
        List<Calendar> validFroms = productComponent.getRepository().getProductComponentGenerations(productComponent).stream().map(IProductObject::getValidFrom).map(this::toCalendar).toList();
        if (validFroms.isEmpty()) {
            validFroms = new ArrayList<Calendar>();
            validFroms.add(this.toCalendar(productComponent.getValidFrom()));
        }
        return validFroms;
    }

    private Calendar toCalendar(DateTime d) {
        return d == null ? null : d.toGregorianCalendar(TimeZone.getDefault());
    }

    static class TableUsageFinder
    extends TypeHierarchyVisitor {
        private String tableUsageName;
        private TableUsage tableUsage = null;

        public TableUsageFinder(String name) {
            this.tableUsageName = name;
        }

        @Override
        public boolean visitType(Type type) {
            boolean hasDeclaredTableUsage = ((ProductCmptType)type).hasDeclaredTableUsage(this.tableUsageName);
            if (hasDeclaredTableUsage) {
                this.tableUsage = ((ProductCmptType)type).getDeclaredTableUsage(this.tableUsageName);
            }
            return !hasDeclaredTableUsage;
        }
    }

    static class TableUsagesCollector
    extends TypeHierarchyVisitor {
        private List<TableUsage> result = new ArrayList<TableUsage>();

        TableUsagesCollector() {
        }

        @Override
        public boolean visitType(Type type) {
            this.result.addAll(((ProductCmptType)type).getDeclaredTableUsages());
            return true;
        }
    }

    static class FormulaFinder
    extends TypeHierarchyVisitor {
        private String formulaName;
        private Formula formula = null;

        public FormulaFinder(String formulaName) {
            this.formulaName = formulaName;
        }

        @Override
        public boolean visitType(Type type) {
            boolean hasDeclaredFormula = ((ProductCmptType)type).hasDeclaredFormula(this.formulaName);
            if (hasDeclaredFormula) {
                this.formula = ((ProductCmptType)type).getDeclaredFormula(this.formulaName);
            }
            return !hasDeclaredFormula;
        }
    }

    static class FormulasCollector
    extends TypeHierarchyVisitor {
        private final List<Formula> result = new ArrayList<Formula>();

        FormulasCollector() {
        }

        @Override
        public boolean visitType(Type type) {
            this.result.addAll(((ProductCmptType)type).getDeclaredFormulas());
            return true;
        }
    }
}

