/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 *
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 *
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/

package org.faktorips.runtime.model.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.faktorips.runtime.model.type.Formula;

/**
 * Preserves design time information about a formula for runtime reference via {@link Formula}.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface IpsFormula {

    /**
     * The formula name.
     */
    String name();

    /**
     * Indicates whether the formula is required.
     *
     * <p>
     * When set to {@code true}, this signifies that the formula must be present. The default value
     * is {@code false}.
     * </p>
     *
     * @return {@code true} if the formula is required, {@code false} otherwise
     */
    boolean required() default false;
}
