/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model;

import org.faktorips.annotation.UtilityClass;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IRuntimeRepository;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.caching.Memoizer;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsEnumType;
import org.faktorips.runtime.model.annotation.IpsExtensibleEnum;
import org.faktorips.runtime.model.annotation.IpsPolicyCmptType;
import org.faktorips.runtime.model.annotation.IpsProductCmptType;
import org.faktorips.runtime.model.annotation.IpsTableStructure;
import org.faktorips.runtime.model.enumtype.EnumType;
import org.faktorips.runtime.model.table.TableStructure;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;

@UtilityClass
public final class IpsModel
extends Enum<IpsModel> {
    private static final Memoizer<Class<? extends ITable<?>>, TableStructure> TABLE_MODEL_CACHE;
    private static final Memoizer<Class<?>, EnumType> ENUM_MODEL_CACHE;
    private static final Memoizer<AnnotatedDeclaration, ProductCmptType> PRODUCT_MODEL_CACHE;
    private static final Memoizer<AnnotatedDeclaration, PolicyCmptType> POLICY_MODEL_CACHE;
    private static final /* synthetic */ IpsModel[] $VALUES;

    public static IpsModel[] values() {
        return (IpsModel[])$VALUES.clone();
    }

    public static IpsModel valueOf(String name) {
        return Enum.valueOf(IpsModel.class, name);
    }

    private static <K, V> V get(Memoizer<K, V> memoizer, K key) {
        try {
            return memoizer.compute(key);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static TableStructure getTableStructure(Class<? extends ITable<?>> tableObjectClass) {
        return IpsModel.get(TABLE_MODEL_CACHE, tableObjectClass);
    }

    public static TableStructure getTableStructure(ITable<?> table) {
        return IpsModel.getTableStructure(table.getClass());
    }

    public static boolean isProductCmptType(Class<?> productModelClass) {
        return AnnotatedDeclaration.from(productModelClass).is(IpsProductCmptType.class);
    }

    public static ProductCmptType getProductCmptType(Class<? extends IProductComponent> productModelClass) {
        AnnotatedDeclaration annotatedDeclaration = AnnotatedDeclaration.from(productModelClass);
        Class<?> implementationClass = annotatedDeclaration.getImplementationClass();
        if (IProductComponent.class.isAssignableFrom(implementationClass) && !(annotatedDeclaration.getPublishedInterface() != null ? annotatedDeclaration.getPublishedInterface().isAnnotationPresent(IpsProductCmptType.class) : implementationClass.isAnnotationPresent(IpsProductCmptType.class)) && implementationClass.getSuperclass() != null) {
            annotatedDeclaration = AnnotatedDeclaration.from(implementationClass.getSuperclass());
        }
        return IpsModel.get(PRODUCT_MODEL_CACHE, annotatedDeclaration);
    }

    public static ProductCmptType getProductCmptType(IProductComponent productComponent) {
        return IpsModel.getProductCmptType(productComponent.getClass());
    }

    public static boolean isPolicyCmptType(Class<?> policyModelClass) {
        return AnnotatedDeclaration.from(policyModelClass).is(IpsPolicyCmptType.class);
    }

    public static PolicyCmptType getPolicyCmptType(Class<? extends IModelObject> policyModelClass) {
        return IpsModel.get(POLICY_MODEL_CACHE, AnnotatedDeclaration.from(policyModelClass));
    }

    public static PolicyCmptType getPolicyCmptType(IModelObject modelObject) {
        return IpsModel.getPolicyCmptType(modelObject.getClass());
    }

    public static Type getType(Class<?> modelObjectClass) {
        AnnotatedDeclaration annotatedModelType = AnnotatedDeclaration.from(modelObjectClass);
        if (annotatedModelType.is(IpsProductCmptType.class)) {
            return IpsModel.getProductCmptType(modelObjectClass.asSubclass(IProductComponent.class));
        }
        if (annotatedModelType.is(IpsPolicyCmptType.class)) {
            return IpsModel.getPolicyCmptType(modelObjectClass.asSubclass(IModelObject.class));
        }
        throw new IllegalArgumentException("The given " + modelObjectClass + " is not annotated as product or policy component type.");
    }

    public static boolean isEnumType(Class<?> enumObjectClass) {
        return AnnotatedDeclaration.from(enumObjectClass).is(IpsEnumType.class);
    }

    public static boolean isExtensibleEnumType(Class<?> enumObjectClass) {
        return AnnotatedDeclaration.from(enumObjectClass).is(IpsExtensibleEnum.class);
    }

    public static EnumType getEnumType(Class<?> enumObjectClass) {
        return IpsModel.get(ENUM_MODEL_CACHE, enumObjectClass);
    }

    public static EnumType getEnumType(Object enumInstance) {
        if (enumInstance instanceof Enum) {
            Enum enumValue = (Enum)enumInstance;
            return IpsModel.getEnumType(enumValue.getDeclaringClass());
        }
        return IpsModel.getEnumType(enumInstance.getClass());
    }

    public static MessageList validate(IRuntimeRepository repository, IValidationContext context) {
        MessageList messages = new MessageList();
        repository.getAllProductComponents().forEach(p -> IpsModel.getProductCmptType(p).validate((IProductComponent)p, messages, context));
        repository.getAllEnumClasses().stream().map(IpsModel::getEnumType).forEach(et -> et.validate(messages, context, repository.getEnumValues(et.getEnumClass())));
        return messages;
    }

    private static /* synthetic */ IpsModel[] $values() {
        return new IpsModel[0];
    }

    static {
        $VALUES = IpsModel.$values();
        TABLE_MODEL_CACHE = Memoizer.of(TableStructure.class, tableObjectClass -> {
            if (tableObjectClass.isAnnotationPresent(IpsTableStructure.class)) {
                return new TableStructure((Class<? extends ITable<?>>)tableObjectClass);
            }
            throw new IllegalArgumentException("The class " + tableObjectClass.getName() + " is not annotated as IpsTableStructure.");
        });
        ENUM_MODEL_CACHE = Memoizer.of(EnumType.class, enumObjectClass -> {
            if (enumObjectClass.isAnnotationPresent(IpsEnumType.class)) {
                return new EnumType((Class<?>)enumObjectClass);
            }
            throw new IllegalArgumentException("The class " + enumObjectClass.getName() + " is not annotated as IpsEnumType.");
        });
        PRODUCT_MODEL_CACHE = Memoizer.of(ProductCmptType.class, annotatedDeclaration -> {
            if (annotatedDeclaration.is(IpsProductCmptType.class)) {
                String name = annotatedDeclaration.get(IpsProductCmptType.class).name();
                return new ProductCmptType(name, (AnnotatedDeclaration)annotatedDeclaration);
            }
            throw new IllegalArgumentException("The class " + annotatedDeclaration.getDeclarationClassName() + " is not annotated as product component type.");
        });
        POLICY_MODEL_CACHE = Memoizer.of(PolicyCmptType.class, annotatedModelType -> {
            if (annotatedModelType.is(IpsPolicyCmptType.class)) {
                String name = annotatedModelType.get(IpsPolicyCmptType.class).name();
                return new PolicyCmptType(name, (AnnotatedDeclaration)annotatedModelType);
            }
            throw new IllegalArgumentException("The class " + annotatedModelType.getDeclarationClassName() + " is not annotated as policy component type.");
        });
    }
}

