/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.validation;

import java.util.Objects;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IValidationContext;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.validation.IGenericAttributeValidationConfiguration;
import org.faktorips.runtime.validation.Relevance;
import org.faktorips.values.ObjectUtil;
import org.faktorips.valueset.ValueSet;

public class GenericRelevanceValidation {
    private final IModelObject modelObject;
    private final PolicyAttribute policyAttribute;
    private final Class<? extends IModelObject> definingModelObjectClass;
    private final IGenericAttributeValidationConfiguration config;
    private ValueSet<?> valueSet;

    public GenericRelevanceValidation(IModelObject modelObject, Class<? extends IModelObject> definingModelObjectClass, PolicyAttribute policyAttribute, IGenericAttributeValidationConfiguration config) {
        this.modelObject = Objects.requireNonNull(modelObject, "modelObject must not be null");
        this.definingModelObjectClass = Objects.requireNonNull(definingModelObjectClass, "definingModelObjectClass must not be null");
        this.policyAttribute = Objects.requireNonNull(policyAttribute, "policyAttribute must not be null");
        this.config = Objects.requireNonNull(config, "config must not be null");
    }

    public static MessageList of(IModelObject modelObject, Class<? extends IModelObject> definingModelObjectClass, String propertyName, IValidationContext validationContext) {
        return new GenericRelevanceValidation(modelObject, definingModelObjectClass, IpsModel.getPolicyCmptType(modelObject).getAttribute(propertyName), validationContext.getGenericAttributeValidationConfiguration()).validate();
    }

    public MessageList validate() {
        MessageList messages = new MessageList();
        if (this.config.shouldValidate(this.policyAttribute, this.modelObject)) {
            this.valueSet = this.config.getValueSet(this.policyAttribute, this.modelObject);
            messages.add(this.validateValuePresentIfMandatory());
            messages.add(this.validateValueNullIfIrrelevant());
            messages.add(this.validateValueContainedIfPresent());
        }
        return messages;
    }

    private Message validateValuePresentIfMandatory() {
        if (this.isInvalidMandatory()) {
            return this.config.createMessageForMissingMandatoryValue(this.policyAttribute, this.modelObject, this.definingModelObjectClass);
        }
        return null;
    }

    private Message validateValueNullIfIrrelevant() {
        if (this.isInvalidIrrelevance()) {
            return this.config.createMessageForValuePresentForIrrelevantAttribute(this.policyAttribute, this.modelObject, this.definingModelObjectClass);
        }
        return null;
    }

    private Message validateValueContainedIfPresent() {
        if (this.isInvalidNotContained()) {
            return this.config.createMessageForValueNotInAllowedValueSet(this.policyAttribute, this.modelObject, this.definingModelObjectClass, this.valueSet);
        }
        return null;
    }

    private boolean isInvalidMandatory() {
        return !this.isValuePresent() && Relevance.isMandatory(this.getValueSet());
    }

    private boolean isInvalidIrrelevance() {
        return this.isValuePresent() && Relevance.isIrrelevant(this.getValueSet());
    }

    private boolean isInvalidNotContained() {
        return Relevance.isRelevant(this.getValueSet()) && this.isValuePresent() && this.getValueSet() != null && !this.getValueSet().contains(this.getValue());
    }

    private boolean isValuePresent() {
        CharSequence charSequence;
        Object value = this.policyAttribute.getValue(this.modelObject);
        return !(ObjectUtil.isNull((Object)value) || value instanceof CharSequence && IpsStringUtils.isBlank((charSequence = (CharSequence)value).toString()));
    }

    private <T> T getValue() {
        return (T)this.policyAttribute.getValue(this.modelObject);
    }

    private ValueSet<?> getValueSet() {
        return this.valueSet;
    }

    public static enum Error {
        IrrelevantValuePresent("IRRELEVANT"),
        MandatoryValueMissing("MANDATORY"),
        ValueNotInValueSet("INVALID");

        private String id;

        private Error(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getDefaultMessageCode(Class<? extends IModelObject> definingModelObjectClass, String propertyName) {
            return this.getId() + "." + definingModelObjectClass.getSimpleName() + "." + propertyName;
        }
    }
}

