/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.validation;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.math.BigDecimal;
import java.util.Collection;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.model.type.ValueSetKind;
import org.faktorips.values.Decimal;
import org.faktorips.values.Money;
import org.faktorips.valueset.BigDecimalRange;
import org.faktorips.valueset.DecimalRange;
import org.faktorips.valueset.DefaultRange;
import org.faktorips.valueset.DoubleRange;
import org.faktorips.valueset.IntegerRange;
import org.faktorips.valueset.LongRange;
import org.faktorips.valueset.MoneyRange;
import org.faktorips.valueset.OrderedValueSet;
import org.faktorips.valueset.StringLengthValueSet;
import org.faktorips.valueset.UnrestrictedValueSet;
import org.faktorips.valueset.ValueSet;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Relevance {
    IRRELEVANT{

        @Override
        public <T> ValueSet<T> asValueSetFor(IModelObject modelObject, PolicyAttribute policyAttribute, ValueSet<T> values) {
            Class<?> datatype = policyAttribute.getDatatype();
            ValueSetKind valueSetKind = policyAttribute.getValueSetKind();
            if (valueSetKind == ValueSetKind.Range) {
                return this.castValueSet(datatype);
            }
            return new OrderedValueSet(false, null, new Object[0]);
        }

        private <T> ValueSet<T> castValueSet(Class<T> datatype) {
            return Relevance.createEmptyRange(datatype);
        }
    }
    ,
    OPTIONAL{

        @Override
        public <T> ValueSet<T> asValueSetFor(IModelObject modelObject, PolicyAttribute policyAttribute, ValueSet<T> values) {
            Class<?> datatype = policyAttribute.getDatatype();
            ValueSetKind valueSetKind = policyAttribute.getValueSetKind();
            return Relevance.asValueSet(datatype, valueSetKind, true, values);
        }
    }
    ,
    MANDATORY{

        @Override
        public <T> ValueSet<T> asValueSetFor(IModelObject modelObject, PolicyAttribute policyAttribute, ValueSet<T> values) {
            Class<?> datatype = policyAttribute.getDatatype();
            ValueSetKind valueSetKind = policyAttribute.getValueSetKind();
            return Relevance.asValueSet(datatype, valueSetKind, false, values);
        }
    };


    private static <T> ValueSet<T> asValueSet(Class<T> datatype, ValueSetKind valueSetKind, boolean containsNull, ValueSet<T> values) {
        if (Relevance.isBoolean(datatype)) {
            return Relevance.asBooleanValueSet(containsNull, values);
        }
        if (Relevance.isCompatible(values, valueSetKind) && values.containsNull() == containsNull) {
            return values;
        }
        if (Relevance.isRange(valueSetKind, values)) {
            return Relevance.asRange(datatype, containsNull, values);
        }
        if (Relevance.isEnum(valueSetKind, values) || datatype.isEnum() || IpsModel.isEnumType(datatype)) {
            return Relevance.asEnum(datatype, containsNull, values);
        }
        if (ValueSetKind.StringLength == valueSetKind) {
            return Relevance.asStringLength(containsNull, values);
        }
        return new UnrestrictedValueSet(containsNull);
    }

    private static <T> ValueSet<T> asStringLength(boolean containsNull, ValueSet<T> values) {
        if (values instanceof StringLengthValueSet) {
            StringLengthValueSet stringLengthValueSet = (StringLengthValueSet)values;
            return new StringLengthValueSet(stringLengthValueSet.getMaximumLength(), containsNull);
        }
        return new StringLengthValueSet(null, containsNull);
    }

    private static <T> boolean isEnum(ValueSetKind valueSetKind, ValueSet<T> values) {
        return valueSetKind == ValueSetKind.Enum || values != null && values instanceof OrderedValueSet;
    }

    private static <T> boolean isRange(ValueSetKind valueSetKind, ValueSet<T> values) {
        return valueSetKind == ValueSetKind.Range || values != null && values.isRange();
    }

    private static <T> boolean isBoolean(Class<T> datatype) {
        return Boolean.class.equals(datatype) || Boolean.TYPE.equals(datatype);
    }

    private static <T> ValueSet<T> asEnum(Class<T> datatype, boolean containsNull, ValueSet<T> values) {
        if (values != null && values.isDiscrete()) {
            return new OrderedValueSet((Collection)values.getValues(true), containsNull, Relevance.nullValue(datatype), true);
        }
        if (!IpsModel.isExtensibleEnumType(datatype) && !datatype.isInterface()) {
            return new OrderedValueSet(containsNull, true, Relevance.nullValue(datatype), (Object[])datatype.getEnumConstants());
        }
        return new UnrestrictedValueSet(containsNull);
    }

    private static <T> T nullValue(Class<T> datatype) {
        if (Money.class.isAssignableFrom(datatype)) {
            return (T)Money.NULL;
        }
        if (Decimal.class.isAssignableFrom(datatype)) {
            return (T)Decimal.NULL;
        }
        return null;
    }

    private static <T> ValueSet<T> asRange(Class<T> datatype, boolean containsNull, ValueSet<T> values) {
        if (values != null && values.isRange()) {
            return Relevance.changeRangeRelevance(values, containsNull);
        }
        return Relevance.createRangeRelevance(datatype, containsNull);
    }

    private static <T> ValueSet<T> asBooleanValueSet(boolean containsNull, ValueSet<T> values) {
        if (values != null && values.isDiscrete()) {
            return new OrderedValueSet((Collection)values.getValues(true), containsNull, null);
        }
        return new OrderedValueSet(containsNull, null, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
    }

    private static boolean isCompatible(ValueSet<?> values, ValueSetKind valueSetKind) {
        if (values == null) {
            return false;
        }
        return switch (valueSetKind) {
            case ValueSetKind.AllValues, ValueSetKind.Derived -> true;
            case ValueSetKind.Enum -> values instanceof OrderedValueSet;
            case ValueSetKind.Range -> values.isRange();
            case ValueSetKind.StringLength -> values instanceof StringLengthValueSet;
            default -> false;
        };
    }

    public static boolean isIrrelevant(IModelObject modelObject, String property) {
        return Relevance.isIrrelevant(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property));
    }

    public static boolean isIrrelevant(IModelObject modelObject, PolicyAttribute policyAttribute) {
        return IRRELEVANT == Relevance.of(modelObject, policyAttribute);
    }

    public static boolean isIrrelevant(ValueSet<?> valueSet) {
        return IRRELEVANT == Relevance.of(valueSet);
    }

    public static boolean isMandatory(IModelObject modelObject, String property) {
        return Relevance.isMandatory(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property));
    }

    public static boolean isMandatory(IModelObject modelObject, PolicyAttribute policyAttribute) {
        return MANDATORY == Relevance.of(modelObject, policyAttribute);
    }

    public static boolean isMandatory(ValueSet<?> valueSet) {
        return MANDATORY == Relevance.of(valueSet);
    }

    public static boolean isOptional(IModelObject modelObject, String property) {
        return Relevance.isOptional(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property));
    }

    public static boolean isOptional(IModelObject modelObject, PolicyAttribute policyAttribute) {
        return OPTIONAL == Relevance.of(modelObject, policyAttribute);
    }

    public static boolean isOptional(ValueSet<?> valueSet) {
        return OPTIONAL == Relevance.of(valueSet);
    }

    public static boolean isRelevant(IModelObject modelObject, String property) {
        return Relevance.isRelevant(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property));
    }

    public static boolean isRelevant(IModelObject modelObject, PolicyAttribute policyAttribute) {
        return !Relevance.isIrrelevant(modelObject, policyAttribute);
    }

    public static boolean isRelevant(ValueSet<?> valueSet) {
        return !Relevance.isIrrelevant(valueSet);
    }

    public static Relevance of(IModelObject modelObject, String property) {
        return Relevance.of(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property));
    }

    public static Relevance of(IModelObject modelObject, PolicyAttribute policyAttribute) {
        return Relevance.of(policyAttribute.getValueSet(modelObject));
    }

    public static Relevance of(ValueSet<?> valueSet) {
        if (valueSet == null || valueSet.isEmpty()) {
            return IRRELEVANT;
        }
        if (valueSet.containsNull()) {
            return OPTIONAL;
        }
        return MANDATORY;
    }

    public <T> ValueSet<T> asValueSetFor(IModelObject modelObject, PolicyAttribute policyAttribute) {
        ValueSet<?> valueSetFromModel = policyAttribute.getValueSetFromModel();
        return this.asValueSetFor(modelObject, policyAttribute, valueSetFromModel);
    }

    public <T> ValueSet<T> asValueSetFor(IModelObject modelObject, String property) {
        return this.asValueSetFor(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property));
    }

    public abstract <T> ValueSet<T> asValueSetFor(IModelObject var1, PolicyAttribute var2, @CheckForNull ValueSet<T> var3);

    public <T> ValueSet<T> asValueSetFor(IModelObject modelObject, PolicyAttribute policyAttribute, @CheckForNull Collection<T> values) {
        return this.asValueSetFor(modelObject, policyAttribute, (ValueSet<T>)OrderedValueSet.of(values));
    }

    public <T> ValueSet<T> asValueSetFor(IModelObject modelObject, String property, @CheckForNull ValueSet<T> values) {
        return this.asValueSetFor(modelObject, IpsModel.getPolicyCmptType(modelObject).getAttribute(property), values);
    }

    public <T> ValueSet<T> asValueSetFor(IModelObject modelObject, String property, @CheckForNull Collection<T> values) {
        return this.asValueSetFor(modelObject, property, (ValueSet<T>)OrderedValueSet.of(values));
    }

    private static ValueSet<?> changeRangeRelevance(ValueSet<?> valueSet, boolean containsNull) {
        if (valueSet instanceof BigDecimalRange) {
            BigDecimalRange bigDecimalRange = (BigDecimalRange)valueSet;
            return BigDecimalRange.valueOf((BigDecimal)((BigDecimal)bigDecimalRange.getLowerBound()), (BigDecimal)((BigDecimal)bigDecimalRange.getUpperBound()), (BigDecimal)((BigDecimal)bigDecimalRange.getStep()), (boolean)containsNull);
        }
        if (valueSet instanceof DecimalRange) {
            DecimalRange decimalRange = (DecimalRange)valueSet;
            return DecimalRange.valueOf((Decimal)((Decimal)decimalRange.getLowerBound()), (Decimal)((Decimal)decimalRange.getUpperBound()), (Decimal)((Decimal)decimalRange.getStep()), (boolean)containsNull);
        }
        if (valueSet instanceof DoubleRange) {
            DoubleRange doubleRange = (DoubleRange)valueSet;
            return DoubleRange.valueOf((Double)((Double)doubleRange.getLowerBound()), (Double)((Double)doubleRange.getUpperBound()), (Double)((Double)doubleRange.getStep()), (boolean)containsNull);
        }
        if (valueSet instanceof IntegerRange) {
            IntegerRange integerRange = (IntegerRange)valueSet;
            return IntegerRange.valueOf((Integer)((Integer)integerRange.getLowerBound()), (Integer)((Integer)integerRange.getUpperBound()), (Integer)((Integer)integerRange.getStep()), (boolean)containsNull);
        }
        if (valueSet instanceof LongRange) {
            LongRange longRange = (LongRange)valueSet;
            return LongRange.valueOf((Long)((Long)longRange.getLowerBound()), (Long)((Long)longRange.getUpperBound()), (Long)((Long)longRange.getStep()), (boolean)containsNull);
        }
        if (valueSet instanceof MoneyRange) {
            MoneyRange moneyRange = (MoneyRange)valueSet;
            return MoneyRange.valueOf((Money)((Money)moneyRange.getLowerBound()), (Money)((Money)moneyRange.getUpperBound()), (Money)((Money)moneyRange.getStep()), (boolean)containsNull);
        }
        return null;
    }

    private static ValueSet<?> createRangeRelevance(Class<?> datatype, boolean containsNull) {
        if (BigDecimal.class.isAssignableFrom(datatype)) {
            return BigDecimalRange.valueOf((BigDecimal)null, null, null, (boolean)containsNull);
        }
        if (Decimal.class.isAssignableFrom(datatype)) {
            return DecimalRange.valueOf((Decimal)null, null, null, (boolean)containsNull);
        }
        if (Double.class.isAssignableFrom(datatype) || Double.TYPE.isAssignableFrom(datatype)) {
            return DoubleRange.valueOf((Double)null, null, null, (boolean)containsNull);
        }
        if (Integer.class.isAssignableFrom(datatype) || Integer.TYPE.isAssignableFrom(datatype)) {
            return IntegerRange.valueOf((Integer)null, null, null, (boolean)containsNull);
        }
        if (Long.class.isAssignableFrom(datatype) || Long.TYPE.isAssignableFrom(datatype)) {
            return LongRange.valueOf((Long)null, null, null, (boolean)containsNull);
        }
        if (Money.class.isAssignableFrom(datatype)) {
            return MoneyRange.valueOf((Money)null, null, null, (boolean)containsNull);
        }
        return null;
    }

    private static ValueSet<?> createEmptyRange(Class<?> datatype) {
        if (BigDecimal.class.isAssignableFrom(datatype)) {
            return BigDecimalRange.empty();
        }
        if (Decimal.class.isAssignableFrom(datatype)) {
            return DecimalRange.empty();
        }
        if (Double.class.isAssignableFrom(datatype) || Double.TYPE.isAssignableFrom(datatype)) {
            return DoubleRange.empty();
        }
        if (Integer.class.isAssignableFrom(datatype) || Integer.TYPE.isAssignableFrom(datatype)) {
            return IntegerRange.empty();
        }
        if (Long.class.isAssignableFrom(datatype) || Long.TYPE.isAssignableFrom(datatype)) {
            return LongRange.empty();
        }
        if (Money.class.isAssignableFrom(datatype)) {
            return MoneyRange.empty();
        }
        return Relevance.newDefaultRange();
    }

    private static DefaultRange newDefaultRange() {
        return new DefaultRange();
    }
}

