/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    public static final String FAKTOR_IPS_SCHEMA_URL = "https://doc.faktorzehn.org/schema/faktor-ips/";
    public static final String W3C_XML_SCHEMA_INSTANCE_NS_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XMLNS_ATTRIBUTE = "xmlns";
    public static final String XML_EXT_PROPERTIES_ELEMENT = "ExtensionProperties";
    public static final String XML_IPS_DEFAULT_NAMESPACE = "http://www.faktorzehn.org";
    public static final String XML_ATTRIBUTE_SPACE = "xml:space";
    public static final String XML_ATTRIBUTE_SPACE_VALUE = "preserve";
    private static final Pattern XML_ELEMENT = Pattern.compile("(?<=[^?!/])>");
    private static final String PRESERVE_SPACE = " xml:space=\"preserve\">";
    private static final Pattern INDENTED_CDATA = Pattern.compile(">[\\n\\r\\s]+<!\\[CDATA");
    private static final String INDENTED_CDATA_REPLACEMENT = "><![CDATA";
    private static final Pattern INDENTED_AFTER_CDATA = Pattern.compile("]]>[\\n\\r\\s]+</");
    private static final String INDENTED_AFTER_CDATA_REPLACEMENT = "]]></";
    private static final Pattern MIXED_CONTENT_WITH_EXTENSION_PROPERTIES_AND_LINE_BREAKS = Pattern.compile("(?<=>)\\R([ \\t]+)([ \\t]+)([^<\\r\\n]+)\\R\\1\\R\\2(?=<ExtensionProperties>)");
    private static final String MIXED_CONTENT_WITH_EXTENSION_PROPERTIES_AND_LINE_BREAKS_REPLACEMENT = "$3";
    private static final Pattern MIXED_CONTENT_WITH_EXTENSION_PROPERTIES = Pattern.compile("(?<=>)\\R([ \\t]+)([^<\\r\\n]+)\\R\\1(?=<ExtensionProperties>)");
    private static final String MIXED_CONTENT_WITH_EXTENSION_PROPERTIES_REPLACEMENT = "$2";
    private static final Pattern INDENTED_DATA = Pattern.compile("(?<=>)\\R(?: |\\t)+(\\R *)(?=<)");
    private static final String INDENTED_DATA_REPLACEMENT = "$1";
    private static final String CARRIAGE_RETURN = "\r";
    private static final String DOUBLE_CARRIAGE_RETURN = "\r\r";
    private static final String IDEOGRAPHIC_ESC = "&#12288;";
    private static final String IDEOGRAPHIC = "\u3000";
    private static final String MEDIUM_MATH_ESC = "&#8287;";
    private static final String MEDIUM_MATH = "\u205f";
    private static final String HAIR_ESC = "&#8202;";
    private static final String HAIR = "\u200a";
    private static final String THIN_ESC = "&#8201;";
    private static final String THIN = "\u2009";
    private static final String PUNCTUATION_ESC = "&#8200;";
    private static final String PUNCTUATION = "\u2008";
    private static final String FIGURE_ESC = "&#8199;";
    private static final String FIGURE = "\u2007";
    private static final String SIX_PER_EM_ESC = "&#8198;";
    private static final String SIX_PER_EM = "\u2006";
    private static final String FOUR_PER_EM_ESC = "&#8197;";
    private static final String FOUR_PER_EM = "\u2005";
    private static final String THREE_PER_EM_ESC = "&#8196;";
    private static final String THREE_PER_EM = "\u2004";
    private static final String EM_SPACE_ESC = "&#8195;";
    private static final String EM_SPACE = "\u2003";
    private static final String EN_SPACE_ESC = "&#8194;";
    private static final String EN_SPACE = "\u2002";
    private static final String EM_QUAD_ESC = "&#8193;";
    private static final String EM_QUAD = "\u2001";
    private static final String EN_QUAD_ESC = "&#8192;";
    private static final String EN_QUAD = "\u2000";
    private static final String ZERO_WIDTH_NO_BREAK_ESC = "&#65279;";
    private static final String ZERO_WIDTH_NO_BREAK = "\ufeff";
    private static final String NARROW_NO_BREAK_ESC = "&#8239;";
    private static final String NARROW_NO_BREAK = "\u202f";
    private static final String NO_BREAK_ESC = "&#160;";
    private static final String NO_BREAK = "\u00a0";
    private static ThreadLocal<Transformer> transformerHolder = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                return transformerFactory.newTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                return null;
            }
        }
    };
    private static ThreadLocal<DocumentBuilder> docBuilderHolder = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            return XmlUtil.createDocumentBuilder();
        }
    };

    private XmlUtil() {
    }

    public static final Element getFirstElement(Node parent, String tagName) {
        return XmlUtil.findFirstElement(parent, tagName).orElse(null);
    }

    public static final Optional<Element> findFirstElement(Node parent, String tagName) {
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element element;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !(element = (Element)node).getNodeName().equals(tagName)) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    public static final Element getFirstElement(Node parent) {
        return XmlUtil.findFirstElement(parent).orElse(null);
    }

    public static final Optional<Element> findFirstElement(Node parent) {
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    public static final Element getElement(Node parent, String tagName, int index) {
        NodeList nl = parent.getChildNodes();
        int count = 0;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element element;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !(element = (Element)node).getNodeName().equals(tagName)) continue;
            if (count == index) {
                return element;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException();
    }

    public static final List<Element> getElements(Node parent, String tagName) {
        return XmlUtil.getChildElements(parent, tagName);
    }

    public static List<Element> getChildElements(Node parent, String ... tagNames) {
        HashSet<String> allowedNames = new HashSet<String>(Arrays.asList(tagNames));
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!(item instanceof Element)) continue;
            Element el = (Element)item;
            if (!allowedNames.contains(item.getNodeName())) continue;
            elements.add(el);
        }
        return elements;
    }

    public static final Text getTextNode(Node node) {
        node.normalize();
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 3) continue;
            return (Text)nl.item(i);
        }
        return null;
    }

    public static final CDATASection getFirstCDataSection(Node node) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 4) continue;
            return (CDATASection)nl.item(i);
        }
        return null;
    }

    public static final String getCDATAorTextContent(Node node) {
        if (XmlUtil.getFirstCDataSection(node) != null) {
            return XmlUtil.getFirstCDataSection(node).getData();
        }
        if (XmlUtil.getTextNode(node) != null) {
            return XmlUtil.getTextNode(node).getData();
        }
        return null;
    }

    public static final String getValueFromNode(Element elem, String nodeName) {
        return XmlUtil.findFirstElement(elem, nodeName).map(e -> {
            Node child = e.getFirstChild();
            return child != null ? child.getNodeValue() : null;
        }).orElse(null);
    }

    public static final List<Element> getElementsFromNode(Element elem, String nodeName, String attributeName, String attributeValue) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nl = elem.getChildNodes();
        int max = nl.getLength();
        for (int i = 0; i < max; ++i) {
            Element el;
            String typeAttr;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !attributeValue.equals(typeAttr = (el = (Element)node).getAttribute(attributeName)) || !el.getNodeName().equals(nodeName)) continue;
            result.add(el);
        }
        return result;
    }

    public static void writeXMLtoFile(File file, Document doc, String doctype, int indentWidth, String encoding) throws TransformerException {
        XmlUtil.writeXMLtoResult(new StreamResult(file), doc, doctype, indentWidth, encoding);
    }

    public static void writeXMLtoStream(OutputStream os, Document doc, String doctype, int indentWidth, String encoding) throws TransformerException {
        XmlUtil.writeXMLtoResult(new StreamResult(os), doc, doctype, indentWidth, encoding);
    }

    public static void writeXMLtoResult(Result res, Document doc, String doctype, int indentWidth, String encoding) throws TransformerException {
        DOMSource src = new DOMSource(doc);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("doctype-public", "");
        if (encoding != null) {
            transformer.setOutputProperty("encoding", encoding);
        }
        if (doctype != null) {
            transformer.setOutputProperty("doctype-system", doctype);
        }
        transformer.setOutputProperty("indent", "yes");
        if (indentWidth > 0) {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indentWidth));
        }
        transformer.transform(src, res);
    }

    public static final DocumentBuilder getDocumentBuilder() {
        return docBuilderHolder.get();
    }

    public static final Document parseDocument(InputStream is) throws SAXException, IOException {
        return XmlUtil.getDocumentBuilder().parse(is);
    }

    public static final String nodeToString(Node node, String encoding, String lineSeparator) throws TransformerException {
        return XmlUtil.nodeToString(node, encoding, lineSeparator, false);
    }

    public static final String nodeToString(Node node, String encoding, String lineSeparator, boolean escapeBlanks) throws TransformerException {
        boolean preserveSpace = XmlUtil.removePreserveSpace(node);
        StringWriter writer = new StringWriter();
        XmlUtil.nodeToWriter(node, writer, encoding);
        String xml = writer.toString();
        if (preserveSpace) {
            xml = XmlUtil.addPreserveSpace(xml);
        }
        xml = XmlUtil.noIndentationAroundCDATA(xml);
        xml = XmlUtil.noIndentationToXmlDataContent(xml);
        return XmlUtil.removeOrEscapeUnwantedCharacters(xml, escapeBlanks, lineSeparator);
    }

    public static final void nodeToWriter(Node node, Writer writer, String encoding) throws TransformerException {
        Transformer transformer = XmlUtil.getTransformer();
        transformer.setOutputProperty("encoding", encoding);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
    }

    private static String noIndentationToXmlDataContent(String xml) {
        return INDENTED_DATA.matcher(MIXED_CONTENT_WITH_EXTENSION_PROPERTIES.matcher(MIXED_CONTENT_WITH_EXTENSION_PROPERTIES_AND_LINE_BREAKS.matcher(xml).replaceAll(MIXED_CONTENT_WITH_EXTENSION_PROPERTIES_AND_LINE_BREAKS_REPLACEMENT)).replaceAll(MIXED_CONTENT_WITH_EXTENSION_PROPERTIES_REPLACEMENT)).replaceAll(INDENTED_DATA_REPLACEMENT);
    }

    private static String removeOrEscapeUnwantedCharacters(String xml, boolean escapeBlanks, String lineSeparator) {
        ArrayList<Object> searchList = new ArrayList<Object>();
        ArrayList<String> replacementList = new ArrayList<String>();
        if (escapeBlanks) {
            searchList.addAll(Arrays.asList(NO_BREAK, NARROW_NO_BREAK, ZERO_WIDTH_NO_BREAK, EN_QUAD, EM_QUAD, EN_SPACE, EM_SPACE, THREE_PER_EM, FOUR_PER_EM, SIX_PER_EM, FIGURE, PUNCTUATION, THIN, HAIR, MEDIUM_MATH, IDEOGRAPHIC, DOUBLE_CARRIAGE_RETURN));
            replacementList.addAll(Arrays.asList(NO_BREAK_ESC, NARROW_NO_BREAK_ESC, ZERO_WIDTH_NO_BREAK_ESC, EN_QUAD_ESC, EM_QUAD_ESC, EN_SPACE_ESC, EM_SPACE_ESC, THREE_PER_EM_ESC, FOUR_PER_EM_ESC, SIX_PER_EM_ESC, FIGURE_ESC, PUNCTUATION_ESC, THIN_ESC, HAIR_ESC, MEDIUM_MATH_ESC, IDEOGRAPHIC_ESC, CARRIAGE_RETURN));
        } else {
            searchList.add(DOUBLE_CARRIAGE_RETURN);
            replacementList.add(CARRIAGE_RETURN);
        }
        searchList.add("\r\n");
        replacementList.add(lineSeparator);
        searchList.add(CARRIAGE_RETURN);
        replacementList.add(lineSeparator);
        searchList.add("\n");
        replacementList.add(lineSeparator);
        for (int i = 0; i <= 31; ++i) {
            if (i == 9 || i == 10) continue;
            String unicodeControlCharacter = "&#" + i + ";";
            searchList.add(unicodeControlCharacter);
            replacementList.add("");
        }
        String[] searchArray = searchList.toArray(new String[searchList.size()]);
        String[] replacementArray = replacementList.toArray(new String[replacementList.size()]);
        return IpsStringUtils.replaceEach(xml, searchArray, replacementArray);
    }

    private static boolean removePreserveSpace(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && attributes.getNamedItem(XML_ATTRIBUTE_SPACE) != null) {
            attributes.removeNamedItem(XML_ATTRIBUTE_SPACE);
            return true;
        }
        return false;
    }

    private static String addPreserveSpace(String xml) {
        return XML_ELEMENT.matcher(xml).replaceFirst(PRESERVE_SPACE);
    }

    private static String noIndentationAroundCDATA(String xml) {
        return INDENTED_AFTER_CDATA.matcher(INDENTED_CDATA.matcher(xml).replaceAll(INDENTED_CDATA_REPLACEMENT)).replaceAll(INDENTED_AFTER_CDATA_REPLACEMENT);
    }

    private static Transformer getTransformer() {
        return transformerHolder.get();
    }

    private static final DocumentBuilder createDocumentBuilder() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new RuntimeException("Error creating document builder.", e1);
        }
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void warning(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        return builder;
    }
}

