/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.util.Locale;
import java.util.Optional;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.model.annotation.IpsConfiguredValidationRule;
import org.faktorips.runtime.model.annotation.IpsExtensionProperties;
import org.faktorips.runtime.model.annotation.IpsValidationRule;
import org.faktorips.runtime.model.type.Deprecation;
import org.faktorips.runtime.model.type.Documentation;
import org.faktorips.runtime.model.type.DocumentationKind;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypePart;

public class ValidationRule
extends TypePart {
    private final IpsValidationRule validationRuleAnnotation;
    private final IpsConfiguredValidationRule validationConfigurationRule;

    public ValidationRule(Type type, IpsValidationRule validationRuleAnnotation, IpsConfiguredValidationRule validationConfigurationRule, IpsExtensionProperties extensionProperties, Optional<Deprecation> deprecation) {
        super(validationRuleAnnotation.name(), type, extensionProperties, deprecation);
        this.validationRuleAnnotation = validationRuleAnnotation;
        this.validationConfigurationRule = validationConfigurationRule;
    }

    @Override
    public boolean isChangingOverTime() {
        if (this.validationConfigurationRule != null) {
            return this.validationConfigurationRule.changingOverTime();
        }
        return false;
    }

    public boolean isActivatedByDefault() {
        if (this.validationConfigurationRule != null) {
            return this.validationConfigurationRule.defaultActivated();
        }
        return false;
    }

    public boolean isProductRelevant() {
        return this.validationConfigurationRule != null;
    }

    @Override
    public String getName() {
        return this.validationRuleAnnotation.name();
    }

    public String getMsgCode() {
        return this.validationRuleAnnotation.msgCode();
    }

    public Severity getSeverity() {
        return this.validationRuleAnnotation.severity();
    }

    @Override
    protected String getDocumentation(Locale locale, DocumentationKind type, String fallback) {
        return Documentation.of(this, type, locale, fallback, this::findSuperValidationRule);
    }

    public boolean isOverriding() {
        return this.getType().findSuperType().map(s -> ((PolicyCmptType)s).isValidationRulePresent(this.getName())).orElse(false);
    }

    public ValidationRule getSuperValidationRule() {
        return this.findSuperValidationRule().orElse(null);
    }

    public Optional<ValidationRule> findSuperValidationRule() {
        return this.isOverriding() ? this.getType().findSuperType().map(s -> ((PolicyCmptType)s).getValidationRule(this.getName())) : Optional.empty();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("@IpsValidationRule( name = '");
        sb.append(this.getName());
        sb.append("', msgCode = '");
        sb.append(this.getMsgCode());
        sb.append("', severity = '");
        sb.append((Object)this.getSeverity());
        sb.append("')");
        if (this.isProductRelevant()) {
            sb.append("\n");
            sb.append("@IpsConfiguredValidationRule(changeOverTime = ");
            sb.append(this.isChangingOverTime());
            sb.append(", defaultActivated = ");
            sb.append(this.isActivatedByDefault());
            sb.append(")");
        }
        return sb.toString();
    }
}

