/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsConfiguredBy;
import org.faktorips.runtime.model.annotation.IpsValidatedBy;
import org.faktorips.runtime.model.type.ModelObjectAttribute;
import org.faktorips.runtime.model.type.PolicyAssociation;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypeHierarchyVisitor;
import org.faktorips.runtime.model.type.ValidationRule;
import org.faktorips.runtime.model.type.read.PolicyAssociationCollector;
import org.faktorips.runtime.model.type.read.PolicyAttributeCollector;
import org.faktorips.runtime.model.type.read.TypePartCollector;
import org.faktorips.runtime.model.type.read.TypePartsReader;
import org.faktorips.runtime.model.type.read.ValidationRuleCollector;

public class PolicyCmptType
extends Type {
    public static final String KIND_NAME = "PolicyCmptType";
    private final LinkedHashMap<String, PolicyAttribute> attributes;
    private final LinkedHashMap<String, PolicyAssociation> associations;
    private final LinkedHashMap<String, ValidationRule> validationRules;

    public PolicyCmptType(String name, AnnotatedDeclaration annotatedDeclararation) {
        super(name, annotatedDeclararation);
        PolicyAttributeCollector attributeCollector = new PolicyAttributeCollector();
        PolicyAssociationCollector associationCollector = new PolicyAssociationCollector();
        this.initParts(annotatedDeclararation, attributeCollector, associationCollector);
        this.attributes = attributeCollector.createParts(this);
        this.associations = associationCollector.createParts(this);
        AnnotatedDeclaration validationClass = this.getClassContainingValidationRules(annotatedDeclararation);
        ValidationRuleCollector validationRuleCollector = new ValidationRuleCollector();
        this.initParts(validationClass, validationRuleCollector);
        this.validationRules = validationRuleCollector.createParts(this);
    }

    private void initParts(AnnotatedDeclaration annotatedDeclararation, TypePartCollector<?, ?> ... collectors) {
        TypePartsReader typePartsReader = new TypePartsReader(collectors);
        typePartsReader.init(annotatedDeclararation);
        typePartsReader.read(annotatedDeclararation);
    }

    private AnnotatedDeclaration getClassContainingValidationRules(AnnotatedDeclaration policyCmptType) {
        if (policyCmptType.is(IpsValidatedBy.class)) {
            Class<?> validator = policyCmptType.get(IpsValidatedBy.class).value();
            return AnnotatedDeclaration.from(validator);
        }
        return policyCmptType;
    }

    @Override
    protected String getKindName() {
        return KIND_NAME;
    }

    public boolean isConfiguredByProductCmptType() {
        return this.getAnnotatedDeclaration().is(IpsConfiguredBy.class);
    }

    public ProductCmptType getProductCmptType() {
        return IpsModel.getProductCmptType(this.getAnnotatedDeclaration().get(IpsConfiguredBy.class).value().asSubclass(IProductComponent.class));
    }

    @Override
    public PolicyCmptType getSuperType() {
        return this.findSuperType().orElse(null);
    }

    public Optional<PolicyCmptType> findSuperType() {
        Class<?> superclass = this.getJavaClass().getSuperclass();
        return IpsModel.isPolicyCmptType(superclass) ? Optional.of(IpsModel.getPolicyCmptType(superclass.asSubclass(IModelObject.class))) : Optional.empty();
    }

    @Override
    public PolicyAttribute getDeclaredAttribute(String name) {
        PolicyAttribute attr = this.attributes.get(IpsStringUtils.toLowerFirstChar(name));
        if (attr == null) {
            throw new IllegalArgumentException("The type " + String.valueOf(this) + " hasn't got a declared attribute " + name);
        }
        return attr;
    }

    @Override
    public PolicyAttribute getDeclaredAttribute(int index) {
        return (PolicyAttribute)super.getDeclaredAttribute(index);
    }

    public List<PolicyAttribute> getDeclaredAttributes() {
        return new ArrayList<PolicyAttribute>(this.attributes.values());
    }

    @Override
    public PolicyAttribute getAttribute(String name) {
        return (PolicyAttribute)super.getAttribute(name);
    }

    public List<PolicyAttribute> getAttributes() {
        Type.AttributeCollector attrCollector = new Type.AttributeCollector();
        attrCollector.visitHierarchy(this);
        return attrCollector.getResult();
    }

    public List<ModelObjectAttribute> getModelObjectAttributes(IModelObject modelObject) {
        return this.getAttributes().stream().map(a -> ModelObjectAttribute.of(modelObject, a)).toList();
    }

    @Override
    public PolicyAssociation getDeclaredAssociation(String name) {
        PolicyAssociation policyAssociation = this.associations.get(IpsStringUtils.toLowerFirstChar(name));
        if (policyAssociation == null) {
            throw new IllegalArgumentException("The type " + String.valueOf(this) + " hasn't got a declared association " + name);
        }
        return policyAssociation;
    }

    @Override
    public PolicyAssociation getDeclaredAssociation(int index) {
        return (PolicyAssociation)super.getDeclaredAssociation(index);
    }

    public List<PolicyAssociation> getDeclaredAssociations() {
        return new ArrayList<PolicyAssociation>(new LinkedHashSet<PolicyAssociation>(this.associations.values()));
    }

    @Override
    public PolicyAssociation getAssociation(String name) {
        return (PolicyAssociation)super.getAssociation(name);
    }

    public List<PolicyAssociation> getAssociations() {
        Type.AssociationsCollector asscCollector = new Type.AssociationsCollector();
        asscCollector.visitHierarchy(this);
        return asscCollector.getResult();
    }

    @Override
    public boolean isAssociationDeclared(String name) {
        return this.associations.containsKey(IpsStringUtils.toLowerFirstChar(name));
    }

    @Override
    public boolean isAttributeDeclared(String name) {
        return this.attributes.containsKey(IpsStringUtils.toLowerFirstChar(name));
    }

    public ValidationRule getDeclaredValidationRule(String name) {
        ValidationRule rule = this.validationRules.get(IpsStringUtils.toLowerFirstChar(name));
        if (rule == null) {
            throw new IllegalArgumentException("The type " + String.valueOf(this) + " hasn't got the validation rule " + name);
        }
        return rule;
    }

    public ValidationRule getDeclaredValidationRule(int index) {
        return this.getDeclaredValidationRules().get(index);
    }

    public List<ValidationRule> getDeclaredValidationRules() {
        return new ArrayList<ValidationRule>(this.validationRules.values());
    }

    public ValidationRule getValidationRule(String name) {
        ValidationRule rule = this.validationRuleFinder(name);
        if (rule == null) {
            throw new IllegalArgumentException("The type " + String.valueOf(this) + " (or one of its supertypes) hasn't got the validation rule \"" + name + "\"");
        }
        return rule;
    }

    public List<ValidationRule> getValidationRules() {
        RuleCollector ruleCollector = new RuleCollector();
        ruleCollector.visitHierarchy(this);
        return ruleCollector.getResult();
    }

    public boolean isValidationRuleDeclared(String name) {
        return this.validationRules.containsKey(IpsStringUtils.toLowerFirstChar(name));
    }

    public boolean isValidationRulePresent(String name) {
        return this.validationRuleFinder(name) != null;
    }

    private ValidationRule validationRuleFinder(String name) {
        ValidationRuleFinder finder = new ValidationRuleFinder(name);
        finder.visitHierarchy(this);
        return finder.validationRule;
    }

    static class RuleCollector
    extends TypeHierarchyVisitor {
        private final List<ValidationRule> result = new ArrayList<ValidationRule>();
        private final Set<String> validationRulesNames = new HashSet<String>();

        RuleCollector() {
        }

        @Override
        public boolean visitType(Type type) {
            for (ValidationRule declaredValidationRule : ((PolicyCmptType)type).getDeclaredValidationRules()) {
                if (this.validationRulesNames.contains(declaredValidationRule.getName())) continue;
                this.validationRulesNames.add(declaredValidationRule.getName());
                this.result.add(declaredValidationRule);
            }
            return true;
        }

        public List<ValidationRule> getResult() {
            return this.result;
        }
    }

    static class ValidationRuleFinder
    extends TypeHierarchyVisitor {
        private String validationRuleName;
        private ValidationRule validationRule = null;

        public ValidationRuleFinder(String validationRuleName) {
            this.validationRuleName = IpsStringUtils.toLowerFirstChar(validationRuleName);
        }

        @Override
        public boolean visitType(Type type) {
            boolean isValidationRuleDeclared = ((PolicyCmptType)type).isValidationRuleDeclared(this.validationRuleName);
            if (isValidationRuleDeclared) {
                this.validationRule = ((PolicyCmptType)type).getDeclaredValidationRule(this.validationRuleName);
            }
            return !isValidationRuleDeclared;
        }
    }
}

